/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.v4l4j;

import au.edu.jcu.v4l4j.CaptureCallback;
import au.edu.jcu.v4l4j.DeviceInfo;
import au.edu.jcu.v4l4j.FrameGrabber;
import au.edu.jcu.v4l4j.ImageFormat;
import au.edu.jcu.v4l4j.ImageFormatList;
import au.edu.jcu.v4l4j.ResolutionInfo;
import au.edu.jcu.v4l4j.VideoDevice;
import au.edu.jcu.v4l4j.VideoFrame;
import au.edu.jcu.v4l4j.exceptions.StateException;
import au.edu.jcu.v4l4j.exceptions.V4L4JException;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamResolution;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V4l4jDevice
implements WebcamDevice,
CaptureCallback,
WebcamDevice.FPSSource {
    private static final Logger LOG = LoggerFactory.getLogger(V4l4jDevice.class);
    private static final String[] BEST_FORMATS = new String[]{"MJPEG", "JPEG", "YU", "UY", "YV", "UV", "BGR24", "RGB24", "BGR32", "RGB32"};
    private final File videoFile;
    private final VideoDevice videoDevice;
    private final ImageFormat videoBestImageFormat;
    private FrameGrabber grabber = null;
    private final List<Dimension> videoResolutions;
    private Dimension resolution = null;
    private AtomicBoolean open = new AtomicBoolean(false);
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private final Exchanger<BufferedImage> exchanger = new Exchanger();
    private volatile V4L4JException exception = null;
    private long t1 = -1L;
    private long t2 = -1L;
    private volatile double fps = 0.0;

    public V4l4jDevice(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Video file cannot be null!");
        }
        this.videoFile = file;
        this.videoDevice = V4l4jDevice.getVideoDevice(file);
        this.videoBestImageFormat = V4l4jDevice.getVideoBestImageFormat(this.videoDevice);
        this.videoResolutions = V4l4jDevice.getVideoResolutions(this.videoBestImageFormat);
    }

    private static VideoDevice getVideoDevice(File file) {
        LOG.debug("Creating V4L4J device from file {}", (Object)file);
        try {
            return new VideoDevice(file.getAbsolutePath());
        }
        catch (V4L4JException e) {
            throw new WebcamException("Cannot instantiate V4L4J device from " + file, (Throwable)e);
        }
    }

    private static DeviceInfo getVideoDeviceInfo(VideoDevice device) {
        LOG.trace("Get video device info");
        LOG.trace("Support BGR conversion {}", (Object)device.supportBGRConversion());
        LOG.trace("Support JPG conversion {}", (Object)device.supportJPEGConversion());
        LOG.trace("Support RGB conversion {}", (Object)device.supportRGBConversion());
        LOG.trace("Support YUV conversion {}", (Object)device.supportYUVConversion());
        LOG.trace("Support YVU conversion {}", (Object)device.supportYVUConversion());
        DeviceInfo info = null;
        try {
            info = device.getDeviceInfo();
        }
        catch (V4L4JException e) {
            throw new WebcamException("Cannot get V4L4J device info from " + device, (Throwable)e);
        }
        if (info == null) {
            throw new WebcamException("Cannot get device info from device");
        }
        return info;
    }

    private static ImageFormat getVideoBestImageFormat(VideoDevice device) {
        if (device == null) {
            throw new IllegalArgumentException("Device must not be null!");
        }
        ImageFormatList formatsList = V4l4jDevice.getVideoDeviceInfo(device).getFormatList();
        List formats = formatsList.getJPEGEncodableFormats();
        int min = Integer.MAX_VALUE;
        ImageFormat bestFormat = null;
        for (ImageFormat format : formats) {
            ResolutionInfo info = format.getResolutionInfo();
            ResolutionInfo.Type type = info.getType();
            String name = format.getName();
            switch (type) {
                case UNSUPPORTED: 
                case DISCRETE: 
                case STEPWISE: {
                    break;
                }
                default: {
                    throw new WebcamException("Unknown resolution type " + type);
                }
            }
            LOG.trace("Testing {} ({})", (Object)name, (Object)type);
            for (int i = 0; i < BEST_FORMATS.length; ++i) {
                if (!name.startsWith(BEST_FORMATS[i]) || i >= min) continue;
                min = i;
                bestFormat = format;
            }
        }
        LOG.debug("Best image format match {}", bestFormat);
        if (bestFormat == null) {
            throw new WebcamException("No suitable image format detected");
        }
        return bestFormat;
    }

    private static List<Dimension> getResolutionsDiscrete(ResolutionInfo info) {
        ArrayList<Dimension> resolutions = new ArrayList<Dimension>();
        for (ResolutionInfo.DiscreteResolution resolution : info.getDiscreteResolutions()) {
            resolutions.add(new Dimension(resolution.getWidth(), resolution.getHeight()));
        }
        return resolutions;
    }

    private static List<Dimension> getResolutionsStepwise(ResolutionInfo info) {
        ArrayList<Dimension> resolutions = new ArrayList<Dimension>();
        ResolutionInfo.StepwiseResolution resolution = info.getStepwiseResolution();
        int minW = resolution.getMinWidth();
        int minH = resolution.getMinHeight();
        int maxW = resolution.getMaxWidth();
        int maxH = resolution.getMaxHeight();
        int stepW = resolution.getWidthStep();
        int stepH = resolution.getHeightStep();
        for (WebcamResolution r : WebcamResolution.values()) {
            boolean sok;
            Dimension size = r.getSize();
            int w = size.width;
            int h = size.height;
            boolean wok = w <= maxW && w >= minW;
            boolean hok = h <= maxH && h >= minH;
            boolean bl = sok = w % stepW == 0 && h % stepH == 0;
            if (!wok || !hok || !sok) continue;
            resolutions.add(size);
        }
        return resolutions;
    }

    private static List<Dimension> getResolutionsUnsupported(ResolutionInfo info) {
        ArrayList<Dimension> resolutions = new ArrayList<Dimension>();
        resolutions.add(WebcamResolution.QQVGA.getSize());
        resolutions.add(WebcamResolution.QVGA.getSize());
        resolutions.add(WebcamResolution.VGA.getSize());
        return resolutions;
    }

    private static List<Dimension> getVideoResolutions(ImageFormat format) {
        if (format == null) {
            throw new IllegalArgumentException("Image format cannot be null!");
        }
        ResolutionInfo info = format.getResolutionInfo();
        ResolutionInfo.Type type = info.getType();
        switch (type) {
            case DISCRETE: {
                return V4l4jDevice.getResolutionsDiscrete(info);
            }
            case STEPWISE: {
                return V4l4jDevice.getResolutionsStepwise(info);
            }
            case UNSUPPORTED: {
                return V4l4jDevice.getResolutionsUnsupported(info);
            }
        }
        throw new WebcamException("Unknown resolution type " + type);
    }

    public String getName() {
        return this.videoFile.getAbsolutePath();
    }

    public Dimension[] getResolutions() {
        return this.videoResolutions.toArray(new Dimension[this.videoResolutions.size()]);
    }

    public Dimension getResolution() {
        if (this.resolution == null) {
            if (this.videoResolutions.isEmpty()) {
                throw new WebcamException("No valid resolution detected for " + this.videoFile);
            }
            this.resolution = this.videoResolutions.get(0);
        }
        return this.resolution;
    }

    public void setResolution(Dimension size) {
        this.resolution = size;
    }

    public BufferedImage getImage() {
        if (!this.open.get()) {
            throw new RuntimeException("Cannot get image from closed device");
        }
        V4L4JException ex = this.exception;
        if (ex != null) {
            throw new WebcamException((Throwable)ex);
        }
        int timeout = 3;
        try {
            return this.exchanger.exchange(null, timeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (TimeoutException e) {
            LOG.error("UNable to get image in {} seconds timeout");
            return null;
        }
    }

    public synchronized void open() {
        if (this.disposed.get()) {
            throw new WebcamException("Cannot open device because it has been already disposed");
        }
        if (!this.open.compareAndSet(false, true)) {
            return;
        }
        if (!this.videoDevice.supportJPEGConversion()) {
            throw new WebcamException("Video device does not support JPEG conversion");
        }
        LOG.debug("Opening V4L4J device {}", (Object)this.videoFile);
        Dimension d = this.getResolution();
        LOG.debug("Constructing V4L4J frame grabber");
        try {
            this.grabber = this.videoDevice.getJPEGFrameGrabber(d.width, d.height, 0, 0, 80, this.videoBestImageFormat);
        }
        catch (V4L4JException e) {
            throw new WebcamException((Throwable)e);
        }
        this.grabber.setCaptureCallback((CaptureCallback)this);
        int w1 = d.width;
        int h1 = d.height;
        int w2 = this.grabber.getWidth();
        int h2 = this.grabber.getHeight();
        if (w1 != w2 || h1 != h2) {
            LOG.error(String.format("Resolution mismatch %dx%d vs %dx%d, setting new one", w1, h1, w2, h2));
            this.resolution = new Dimension(w2, h2);
        }
        LOG.debug("Starting V4L4J frame grabber");
        try {
            this.grabber.startCapture();
        }
        catch (V4L4JException e) {
            throw new WebcamException((Throwable)e);
        }
        LOG.debug("Webcam V4L4J is now open");
    }

    public synchronized void close() {
        if (!this.open.compareAndSet(true, false)) {
            return;
        }
        LOG.debug("Closing V4L4J device {}", (Object)this.videoFile);
        try {
            this.grabber.stopCapture();
        }
        catch (StateException e) {
            LOG.trace("State exception on close", (Throwable)e);
        }
        finally {
            try {
                this.exchanger.exchange(null, 1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.debug("Exchange interrupted in close");
            }
            catch (TimeoutException e) {
                LOG.debug("Exchange timeout in close");
            }
        }
        this.grabber = null;
        this.videoDevice.releaseFrameGrabber();
        LOG.debug("V4L4J device {} has been closed", (Object)this.videoFile);
    }

    public void dispose() {
        if (!this.disposed.compareAndSet(false, true)) {
            return;
        }
        LOG.debug("Disposing V4L4J device {}", (Object)this.videoFile);
        if (this.open.get()) {
            this.close();
        }
        this.videoDevice.releaseControlList();
        this.videoDevice.release();
        LOG.debug("V4L4J device {} has been disposed", (Object)this.videoFile);
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public void nextFrame(VideoFrame frame) {
        LOG.trace("Next frame {}", (Object)frame);
        if (!this.open.get()) {
            return;
        }
        if (this.t1 == -1L || this.t2 == -1L) {
            this.t1 = System.currentTimeMillis();
            this.t2 = System.currentTimeMillis();
        }
        try {
            this.exchanger.exchange(frame.getBufferedImage());
        }
        catch (InterruptedException e) {
            return;
        }
        finally {
            frame.recycle();
        }
        this.t1 = this.t2;
        this.t2 = System.currentTimeMillis();
        this.fps = (4.0 * this.fps + (double)(1000L / (this.t2 - this.t1 + 1L))) / 5.0;
    }

    public void exceptionReceived(V4L4JException e) {
        e.printStackTrace();
        LOG.error("Exception received from V4L4J", (Throwable)e);
        this.exception = e;
    }

    public double getFPS() {
        return this.fps;
    }
}

