/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam.ds.v4l4j;

import com.github.sarxos.v4l4j.V4L4J;
import com.github.sarxos.webcam.WebcamDevice;
import com.github.sarxos.webcam.WebcamDriver;
import com.github.sarxos.webcam.ds.v4l4j.V4l4jDevice;
import com.github.sarxos.webcam.util.NixVideoDevUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V4l4jDriver
implements WebcamDriver {
    private static final Logger LOG = LoggerFactory.getLogger(V4l4jDriver.class);

    public List<WebcamDevice> getDevices() {
        ArrayList<WebcamDevice> devices = new ArrayList<WebcamDevice>();
        File[] vfiles = NixVideoDevUtils.getVideoFiles();
        if (LOG.isDebugEnabled()) {
            for (File vfile : vfiles) {
                LOG.debug("Video file detected {}", (Object)vfile);
            }
        }
        for (File vfile : vfiles) {
            devices.add(new V4l4jDevice(vfile));
        }
        return devices;
    }

    public boolean isThreadSafe() {
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    static {
        V4L4J.init();
    }
}

