/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import java.util.ArrayList;
import java.util.List;
import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.mXparser;

public class RecursiveArgument
extends Argument {
    public static final int TYPE_ID_RECURSIVE = 102;
    public static final String TYPE_DESC_RECURSIVE = "User defined recursive argument";
    private List<Double> baseValues;
    private int recursiveCounter;
    private int startingIndex;

    public RecursiveArgument(String string, String string2, String string3) {
        super(string, string2, new PrimitiveElement[0]);
        if (string.equals(this.getArgumentName())) {
            this.argumentType = 3;
            this.baseValues = new ArrayList<Double>();
            this.n = new Argument(string3, new PrimitiveElement[0]);
            this.argumentExpression.addArguments(this.n);
            this.argumentExpression.addArguments(this);
            this.argumentExpression.setDescription(string);
            this.recursiveCounter = -1;
        }
    }

    public RecursiveArgument(String string, String string2, Argument argument, PrimitiveElement ... primitiveElementArray) {
        super(string, string2, new PrimitiveElement[0]);
        if (string.equals(this.getArgumentName())) {
            this.argumentType = 3;
            this.baseValues = new ArrayList<Double>();
            this.n = argument;
            this.argumentExpression.addArguments(argument);
            this.argumentExpression.addArguments(this);
            this.argumentExpression.addDefinitions(primitiveElementArray);
            this.argumentExpression.setDescription(string);
            this.recursiveCounter = -1;
        }
    }

    public RecursiveArgument(String string, PrimitiveElement ... primitiveElementArray) {
        super(string, new PrimitiveElement[0]);
        if (mXparser.regexMatch(string, "(\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\((\\s)*([a-zA-Z_])+([a-zA-Z0-9_])*(\\s)*(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            this.argumentType = 3;
            this.baseValues = new ArrayList<Double>();
            this.recursiveCounter = -1;
            this.argumentExpression.addArguments(this.n);
            this.argumentExpression.addArguments(this);
            this.argumentExpression.addDefinitions(primitiveElementArray);
            this.argumentExpression.setDescription(string);
        } else {
            this.argumentExpression = new Expression(new PrimitiveElement[0]);
            this.argumentExpression.setSyntaxStatus(false, "[" + string + "] Invalid argument definition (patterns: f(n) = f(n-1) ...  ).");
        }
    }

    public void addBaseCase(int n, double d) {
        int n2 = this.baseValues.size();
        if (n > n2 - 1) {
            for (int i = n2; i < n; ++i) {
                this.baseValues.add(new Double(Double.NaN));
            }
            this.baseValues.add(new Double(d));
        } else {
            this.baseValues.set(n, new Double(d));
        }
    }

    public void resetAllCases() {
        this.baseValues.clear();
        this.recursiveCounter = -1;
    }

    public double getArgumentValue(double d) {
        if (this.recursiveCounter == -1) {
            this.startingIndex = (int)Math.round(d);
        }
        int n = this.baseValues.size();
        int n2 = (int)Math.round(d);
        ++this.recursiveCounter;
        if (this.recursiveCounter <= this.startingIndex && n2 <= this.startingIndex) {
            if (n2 >= 0 && n2 < n && !Double.isNaN(this.baseValues.get(n2))) {
                --this.recursiveCounter;
                return this.baseValues.get(n2);
            }
            if (n2 >= 0) {
                this.n.setArgumentValue(n2);
                Expression expression = new Expression(this.argumentExpression.expressionString, this.argumentExpression.argumentsList, this.argumentExpression.functionsList, this.argumentExpression.constantsList, true, this.argumentExpression.UDFExpression, this.argumentExpression.UDFVariadicParamsAtRunTime);
                expression.setDescription(super.getArgumentName());
                if (super.getVerboseMode()) {
                    expression.setVerboseMode();
                }
                double d2 = expression.calculate();
                this.addBaseCase(n2, d2);
                --this.recursiveCounter;
                return d2;
            }
            --this.recursiveCounter;
            return Double.NaN;
        }
        --this.recursiveCounter;
        return Double.NaN;
    }
}

