/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Constant;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.Function;
import org.mariuszgromada.math.mxparser.PrimitiveElement;
import org.mariuszgromada.math.mxparser.RecursiveArgument;
import org.mariuszgromada.math.mxparser.mXparser;

public class Tutorial {
    public static void main(String[] stringArray) {
        mXparser.consolePrintln("                      mXparser - version 4.2.0\n         A flexible mathematical eXpressions parser for JAVA.\n\nYou may use this software under the condition of Simplified BSD License:\n\nCopyright 2010-2017 MARIUSZ GROMADA. All rights reserved.\n\nRedistribution and use in source and binary forms, with or without modification, are\npermitted provided that the following conditions are met:\n\n   1. Redistributions of source code must retain the above copyright notice, this list of\n      conditions and the following disclaimer.\n\n   2. Redistributions in binary form must reproduce the above copyright notice, this list\n      of conditions and the following disclaimer in the documentation and/or other materials\n      provided with the distribution.\n\nTHIS SOFTWARE IS PROVIDED BY MARIUSZ GROMADA ``AS IS'' AND ANY EXPRESS OR IMPLIED\nWARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND\nFITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MARIUSZ GROMADA OR\nCONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR\nCONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR\nSERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON\nANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING\nNEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF\nADVISED OF THE POSSIBILITY OF SUCH DAMAGE.\n\nThe views and conclusions contained in the software and documentation are those of the\nauthors and should not be interpreted as representing official policies, either expressed\nor implied, of MARIUSZ GROMADA.\n\nIf you have any questions/bugs feel free to contact:\n\n    Mariusz Gromada\n    mariuszgromada.org@gmail.com\n    http://mathspace.plt/\n    http://mathparser.org/\n    http://github.com/mariuszgromada/MathParser.org-mXparser\n    http://mariuszgromada.github.io/MathParser.org-mXparser/\n    http://mxparser.sourceforge.net/\n    http://bitbucket.org/mariuszgromada/mxparser/\n    http://mxparser.codeplex.com/\n    http://janetsudoku.mariuszgromada.org/\n");
        Expression expression = new Expression(new PrimitiveElement[0]);
        mXparser.consolePrintln(expression.getHelp());
        mXparser.consolePrintln();
        mXparser.consolePrintln(expression.getHelp("sine"));
        mXparser.consolePrintln();
        mXparser.consolePrintln(expression.getHelp("inver"));
        Expression expression2 = new Expression("2+1", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression2.getExpressionString() + " = " + expression2.calculate());
        expression2.setExpressionString("2-1");
        mXparser.consolePrintln(expression2.getExpressionString() + " = " + expression2.calculate());
        Expression expression3 = new Expression("2-(32-4)/(23+(4)/(5))-(2-4)*(4+6-98.2)+4", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression3.getExpressionString() + " = " + expression3.calculate());
        Expression expression4 = new Expression("2^3+2^(-3)+2^3^(-4)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression4.getExpressionString() + " = " + expression4.calculate());
        Expression expression5 = new Expression("2=3", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression5.getExpressionString() + " = " + expression5.calculate());
        Expression expression6 = new Expression("2<3", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression6.getExpressionString() + " = " + expression6.calculate());
        Expression expression7 = new Expression("(2=3) | (2<3)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression7.getExpressionString() + " = " + expression7.calculate());
        Expression expression8 = new Expression("(2=3) & (2<3)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression8.getExpressionString() + " = " + expression8.calculate());
        Expression expression9 = new Expression("sin(2)-cos(3)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression9.getExpressionString() + " = " + expression9.calculate());
        Expression expression10 = new Expression("min(3,4) + max(-2,-1)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression10.getExpressionString() + " = " + expression10.calculate());
        Expression expression11 = new Expression("C(10,5)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression11.getExpressionString() + " = " + expression11.calculate());
        Expression expression12 = new Expression("if(2<3,1,0)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression12.getExpressionString() + " = " + expression12.calculate());
        Expression expression13 = new Expression("if(3<2,1,0)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression13.getExpressionString() + " = " + expression13.calculate());
        Expression expression14 = new Expression("if(3<2, 1, if(1=1, 5, 0) )", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression14.getExpressionString() + " = " + expression14.calculate());
        Argument argument = new Argument("x=1", new PrimitiveElement[0]);
        Argument argument2 = new Argument("y=2", new PrimitiveElement[0]);
        Argument argument3 = new Argument("z", 3.0);
        Argument argument4 = new Argument("n", 4.0);
        Expression expression15 = new Expression("sin(x+y)-cos(y/z)", argument, argument2, argument3);
        mXparser.consolePrintln(expression15.getExpressionString() + " = " + expression15.calculate());
        Expression expression16 = new Expression("if(x>y, x-z, if(y<z, sin(x+y), cos(z)) )", argument, argument2, argument3);
        mXparser.consolePrintln(expression16.getExpressionString() + " = " + expression16.calculate());
        argument.setArgumentValue(5.0);
        mXparser.consolePrintln(argument.getArgumentName() + " = " + argument.getArgumentValue());
        argument2 = new Argument("y", "2*x+5", argument);
        mXparser.consolePrintln(argument2.getArgumentName() + " = " + argument2.getArgumentValue());
        argument2 = new Argument("y", "sin(y)-z", argument2, argument3);
        mXparser.consolePrintln(argument2.getArgumentName() + " = " + argument2.getArgumentValue());
        argument2.setArgumentExpressionString("n*sin(y)-z");
        mXparser.consolePrintln(argument2.getArgumentName() + " = ... \n syntax = " + argument2.checkSyntax() + "\n message = \n" + argument2.getErrorMessage());
        argument2.addDefinitions(argument4);
        mXparser.consolePrintln(argument2.getArgumentName() + " = ... \n syntax = " + argument2.checkSyntax() + "\n message = \n" + argument2.getErrorMessage());
        mXparser.consolePrintln(argument2.getArgumentName() + " = " + argument2.getArgumentValue());
        Expression expression17 = new Expression("sum(i,1,10,i)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression17.getExpressionString() + " = " + expression17.calculate());
        Expression expression18 = new Expression("sum(i,1,10,i,0.5)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression18.getExpressionString() + " = " + expression18.calculate());
        Expression expression19 = new Expression("prod(i,1,5,i)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression19.getExpressionString() + " = " + expression19.calculate());
        Expression expression20 = new Expression("prod(i,1,5,i,0.5)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression20.getExpressionString() + " = " + expression20.calculate());
        Expression expression21 = new Expression("sin(x)-sum(n,0,10,(-1)^n*(x^(2*n+1))/(2*n+1)!)", argument);
        argument.setArgumentValue(1.0);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression21.getExpressionString() + " = " + expression21.calculate());
        argument.setArgumentValue(5.0);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression21.getExpressionString() + " = " + expression21.calculate());
        argument.setArgumentValue(10.0);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression21.getExpressionString() + " = " + expression21.calculate());
        Argument argument5 = new Argument("d", 0.1);
        Expression expression22 = new Expression("2*sum(x, -1, 1, d*sqrt(1-x^2), d)", argument5);
        mXparser.consolePrintln("d = " + argument5.getArgumentValue() + ", " + expression22.getExpressionString() + " = " + expression22.calculate());
        argument5.setArgumentValue(0.01);
        mXparser.consolePrintln("d = " + argument5.getArgumentValue() + ", " + expression22.getExpressionString() + " = " + expression22.calculate());
        Expression expression23 = new Expression("cos(x)-der(sin(x), x)", argument);
        mXparser.consolePrintln(expression23.getExpressionString() + " = " + expression23.calculate());
        argument.setArgumentValue(0.0);
        Expression expression24 = new Expression("der-(abs(x), x)", argument);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression24.getExpressionString() + " = " + expression24.calculate());
        Expression expression25 = new Expression("der+(abs(x), x)", argument);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression25.getExpressionString() + " = " + expression25.calculate());
        argument.setArgumentValue(1.0);
        Expression expression26 = new Expression("cos(x)-der(sum(n,0,10,(-1)^n*(x^(2*n+1))/(2*n+1)!), x)", argument);
        argument.setArgumentValue(1.0);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression26.getExpressionString() + " = " + expression26.calculate());
        argument.setArgumentValue(5.0);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression26.getExpressionString() + " = " + expression26.calculate());
        argument.setArgumentValue(10.0);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression26.getExpressionString() + " = " + expression26.calculate());
        Expression expression27 = new Expression("2*int(sqrt(1-x^2), x, -1, 1)", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression27.getExpressionString() + " = " + expression27.calculate());
        Expression expression28 = new Expression("pi", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression28.getExpressionString() + " = " + expression28.calculate());
        Expression expression29 = new Expression("e", new PrimitiveElement[0]);
        mXparser.consolePrintln(expression29.getExpressionString() + " = " + expression29.calculate());
        Function function = new Function("f", "x^2", "x");
        Expression expression30 = new Expression("f(2)", new PrimitiveElement[0]);
        expression30.addDefinitions(function);
        mXparser.consolePrintln(expression30.getExpressionString() + " = " + expression30.calculate());
        function = new Function("f(a,b,c)=a+b+c", new PrimitiveElement[0]);
        Expression expression31 = new Expression("f(1, 2, 3)", new PrimitiveElement[0]);
        expression31.addDefinitions(function);
        mXparser.consolePrintln(expression31.getExpressionString() + " = " + expression31.calculate());
        function = new Function("f", "x^2", "x");
        Function function2 = new Function("g", "f(x)^2", "x");
        function2.addDefinitions(function);
        mXparser.consolePrintln("g(2) = " + function2.calculate(2.0));
        Expression expression32 = new Expression("f(x)+g(2*x)", argument);
        expression32.addDefinitions(function, function2);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression32.getExpressionString() + " = " + expression32.calculate());
        argument.setArgumentValue(2.0);
        Expression expression33 = new Expression("der(g(x),x)", argument);
        expression33.addDefinitions(function2);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression33.getExpressionString() + " = " + expression33.calculate());
        function = new Function("f", "sin(x)", "x");
        Function function3 = new Function("F", "int(f(t), t, 0, x)", "x");
        function3.addDefinitions(function);
        Expression expression34 = new Expression("f(x) - der(F(x),x)", argument);
        expression34.addDefinitions(function, function3);
        mXparser.consolePrintln("x = " + argument.getArgumentValue() + ", " + expression34.getExpressionString() + " = " + expression34.calculate() + ", computing time : " + expression34.getComputingTime() + " s.");
        argument4 = new Argument("n", new PrimitiveElement[0]);
        RecursiveArgument recursiveArgument = new RecursiveArgument("fib1", "fib1(n-1)+fib1(n-2)", argument4, new PrimitiveElement[0]);
        recursiveArgument.addBaseCase(0, 0.0);
        recursiveArgument.addBaseCase(1, 1.0);
        mXparser.consolePrintln("fib1: ");
        for (int i = 0; i <= 10; ++i) {
            mXparser.consolePrint(recursiveArgument.getArgumentValue(i) + ", ");
        }
        mXparser.consolePrintln();
        RecursiveArgument recursiveArgument2 = new RecursiveArgument("fib2", "if( n>1, fib2(n-1)+fib2(n-2), if(n=1,1,0) )", argument4, new PrimitiveElement[0]);
        mXparser.consolePrintln("fib2: ");
        for (int i = 0; i <= 10; ++i) {
            mXparser.consolePrint(recursiveArgument2.getArgumentValue(i) + ", ");
        }
        mXparser.consolePrintln();
        Expression expression35 = new Expression("sum(i, 0, 10, fib1(i))", recursiveArgument);
        mXparser.consolePrintln(expression35.getExpressionString() + " = " + expression35.calculate() + ", computing time : " + expression35.getComputingTime() + " s.");
        Expression expression36 = new Expression("sum(i, 0, 10, fib2(i))", recursiveArgument2);
        mXparser.consolePrintln(expression36.getExpressionString() + " = " + expression36.calculate() + ", computing time : " + expression36.getComputingTime() + " s.");
        Function function4 = new Function("fib3", "if(n>1, fib3(n-1)+fib3(n-2), if(n>0,1,0))", "n");
        mXparser.consolePrintln("fib2: ");
        for (int i = 0; i <= 10; ++i) {
            mXparser.consolePrint(function4.calculate(i) + ", ");
        }
        mXparser.consolePrintln();
        Expression expression37 = new Expression("sum(i, 0, 10, fib3(i))", new PrimitiveElement[0]);
        expression37.addDefinitions(function4);
        mXparser.consolePrintln(expression37.getExpressionString() + " = " + expression37.calculate() + ", computing time : " + expression37.getComputingTime() + " s.");
        Function function5 = new Function("T", "if(n>1, 2*x*T(n-1,x)-T(n-2,x), if(n>0, x, 1) )", "n", "x");
        Argument argument6 = new Argument("k", 5.0);
        Expression expression38 = new Expression("T(k,x) - ( (x + sqrt(x^2-1))^k + (x - sqrt(x^2-1))^k)/2", argument6, argument);
        expression38.addDefinitions(function5);
        mXparser.consolePrintln(expression38.getExpressionString() + " = " + expression38.calculate() + ", computing time : " + expression38.getComputingTime() + " s.");
        Function function6 = new Function("Cnk", "if( k>0, if( k<n, Cnk(n-1,k-1)+Cnk(n-1,k), 1), 1)", "n", "k");
        Expression expression39 = new Expression("C(10,5) - Cnk(10,5)", new PrimitiveElement[0]);
        expression39.addDefinitions(function6);
        mXparser.consolePrintln(expression39.getExpressionString() + " = " + expression39.calculate() + ", computing time : " + expression39.getComputingTime() + " s.");
        Constant constant = new Constant("a", 5.0);
        Constant constant2 = new Constant("b", 10.0);
        Constant constant3 = new Constant("c", 15.0);
        Expression expression40 = new Expression("a+b+c", new PrimitiveElement[0]);
        expression40.addDefinitions(constant, constant2, constant3);
        expression40.setVerboseMode();
        expression40.checkSyntax();
        mXparser.consolePrintln();
        mXparser.consolePrintln(expression40.getErrorMessage());
        mXparser.consolePrintln(expression40.getExpressionString() + " = " + expression40.calculate() + ", computing time : " + expression40.getComputingTime() + " s.");
    }
}

