/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.ProbabilityDistributions;

public final class Calculus {
    public static final int LEFT_DERIVATIVE = 1;
    public static final int RIGHT_DERIVATIVE = 2;
    public static final int GENERAL_DERIVATIVE = 3;

    public static final double integralTrapezoid(Expression expression, Argument argument, double d, double d2, double d3, int n) {
        double d4 = 0.5 * (d2 - d);
        double d5 = mXparser.getFunctionValue(expression, argument, d) + mXparser.getFunctionValue(expression, argument, d2) + 2.0 * mXparser.getFunctionValue(expression, argument, d + d4);
        double d6 = d5 * d4 * 0.5;
        double d7 = 0.0;
        double d8 = d;
        int n2 = 1;
        for (int i = 1; i <= n; ++i) {
            n2 += n2;
            d8 = d + 0.5 * d4;
            d7 = d6;
            for (int j = 1; j <= n2; ++j) {
                d5 += 2.0 * mXparser.getFunctionValue(expression, argument, d8);
                d8 += d4;
            }
            d6 = d5 * (d4 *= 0.5) * 0.5;
            if (!(Math.abs(d6 - d7) <= d3)) continue;
            return d6;
        }
        return d6;
    }

    public static final double derivative(Expression expression, Argument argument, double d, int n, double d2, int n2) {
        int n3 = 0;
        double d3 = 2.0 * d2;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        d7 = n == 1 ? -0.1 : 0.1;
        double d8 = 0.0;
        if (n == 1 || n == 2) {
            d4 = mXparser.getFunctionValue(expression, argument, d);
            d8 = mXparser.getFunctionValue(expression, argument, d + d7) - d4;
            d5 = d8 / d7;
        } else {
            d5 = (mXparser.getFunctionValue(expression, argument, d + d7) - mXparser.getFunctionValue(expression, argument, d - d7)) / (2.0 * d7);
        }
        do {
            d6 = d5;
            d7 /= 2.0;
            if (n == 1 || n == 2) {
                d8 = mXparser.getFunctionValue(expression, argument, d + d7) - d4;
                d5 = d8 / d7;
            } else {
                d5 = (mXparser.getFunctionValue(expression, argument, d + d7) - mXparser.getFunctionValue(expression, argument, d - d7)) / (2.0 * d7);
            }
            d3 = Math.abs(d5 - d6);
        } while (++n3 < n2 && (d3 > d2 || Double.isNaN(d5)));
        return d5;
    }

    public static final double derivativeNth(Expression expression, double d, Argument argument, double d2, int n, double d3, int n2) {
        int n3;
        d = Math.round(d);
        int n4 = 0;
        double d4 = 2.0 * d3;
        double d5 = 0.0;
        double d6 = 0.01;
        double d7 = 0.0;
        if (n == 2) {
            n3 = 1;
            while ((double)n3 <= d) {
                d7 += MathFunctions.binomCoeff(-1.0, d - (double)n3) * MathFunctions.binomCoeff(d, n3) * mXparser.getFunctionValue(expression, argument, d2 + (double)n3 * d6);
                ++n3;
            }
        } else {
            n3 = 1;
            while ((double)n3 <= d) {
                d7 += MathFunctions.binomCoeff(-1.0, n3) * MathFunctions.binomCoeff(d, n3) * mXparser.getFunctionValue(expression, argument, d2 - (double)n3 * d6);
                ++n3;
            }
        }
        d7 /= Math.pow(d6, d);
        do {
            d5 = d7;
            d6 /= 2.0;
            d7 = 0.0;
            if (n == 2) {
                n3 = 1;
                while ((double)n3 <= d) {
                    d7 += MathFunctions.binomCoeff(-1.0, d - (double)n3) * MathFunctions.binomCoeff(d, n3) * mXparser.getFunctionValue(expression, argument, d2 + (double)n3 * d6);
                    ++n3;
                }
            } else {
                n3 = 1;
                while ((double)n3 <= d) {
                    d7 += MathFunctions.binomCoeff(-1.0, n3) * MathFunctions.binomCoeff(d, n3) * mXparser.getFunctionValue(expression, argument, d2 - (double)n3 * d6);
                    ++n3;
                }
            }
            d4 = Math.abs((d7 /= Math.pow(d6, d)) - d5);
        } while (++n4 < n2 && (d4 > d3 || Double.isNaN(d7)));
        return d7;
    }

    public static final double forwardDifference(Expression expression, Argument argument, double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = argument.getArgumentValue();
        double d3 = mXparser.getFunctionValue(expression, argument, d + 1.0) - mXparser.getFunctionValue(expression, argument, d);
        argument.setArgumentValue(d2);
        return d3;
    }

    public static final double forwardDifference(Expression expression, Argument argument) {
        double d = argument.getArgumentValue();
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = expression.calculate();
        argument.setArgumentValue(d + 1.0);
        double d3 = expression.calculate() - d2;
        argument.setArgumentValue(d);
        return d3;
    }

    public static final double backwardDifference(Expression expression, Argument argument, double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = argument.getArgumentValue();
        double d3 = mXparser.getFunctionValue(expression, argument, d) - mXparser.getFunctionValue(expression, argument, d - 1.0);
        argument.setArgumentValue(d2);
        return d3;
    }

    public static final double backwardDifference(Expression expression, Argument argument) {
        double d = argument.getArgumentValue();
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = expression.calculate();
        argument.setArgumentValue(d - 1.0);
        double d3 = d2 - expression.calculate();
        argument.setArgumentValue(d);
        return d3;
    }

    public static final double forwardDifference(Expression expression, double d, Argument argument, double d2) {
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = argument.getArgumentValue();
        double d4 = mXparser.getFunctionValue(expression, argument, d2 + d) - mXparser.getFunctionValue(expression, argument, d2);
        argument.setArgumentValue(d3);
        return d4;
    }

    public static final double forwardDifference(Expression expression, double d, Argument argument) {
        double d2 = argument.getArgumentValue();
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = expression.calculate();
        argument.setArgumentValue(d2 + d);
        double d4 = expression.calculate() - d3;
        argument.setArgumentValue(d2);
        return d4;
    }

    public static final double backwardDifference(Expression expression, double d, Argument argument, double d2) {
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = argument.getArgumentValue();
        double d4 = mXparser.getFunctionValue(expression, argument, d2) - mXparser.getFunctionValue(expression, argument, d2 - d);
        argument.setArgumentValue(d3);
        return d4;
    }

    public static final double backwardDifference(Expression expression, double d, Argument argument) {
        double d2 = argument.getArgumentValue();
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        double d3 = expression.calculate();
        argument.setArgumentValue(d2 - d);
        double d4 = d3 - expression.calculate();
        argument.setArgumentValue(d2);
        return d4;
    }

    public static final double solveBrent(Expression expression, Argument argument, double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        if (d2 < d) {
            d6 = d;
            d = d2;
            d2 = d6;
        }
        double d7 = mXparser.getFunctionValue(expression, argument, d);
        double d8 = mXparser.getFunctionValue(expression, argument, d2);
        if (MathFunctions.abs(d7) <= d3) {
            return d;
        }
        if (MathFunctions.abs(d8) <= d3) {
            return d2;
        }
        if (d2 == d) {
            return Double.NaN;
        }
        if (d7 * d8 > 0.0) {
            boolean bl = false;
            int n = 0;
            while ((double)n < d4) {
                double d9 = ProbabilityDistributions.rndUniformContinuous(d, d2);
                double d10 = ProbabilityDistributions.rndUniformContinuous(d, d2);
                if (d10 < d9) {
                    d6 = d9;
                    d9 = d10;
                    d10 = d6;
                }
                d7 = mXparser.getFunctionValue(expression, argument, d9);
                d8 = mXparser.getFunctionValue(expression, argument, d10);
                if (MathFunctions.abs(d7) <= d3) {
                    return d9;
                }
                if (MathFunctions.abs(d8) <= d3) {
                    return d10;
                }
                if (d7 * d8 < 0.0) {
                    bl = true;
                    d = d9;
                    d2 = d10;
                    break;
                }
                ++n;
            }
            if (!bl) {
                return Double.NaN;
            }
        }
        double d11 = d5 = d;
        double d12 = mXparser.getFunctionValue(expression, argument, d5);
        if (MathFunctions.abs(d7) < MathFunctions.abs(d8)) {
            d6 = d;
            d = d2;
            d2 = d6;
            d6 = d7;
            d7 = d8;
            d8 = d6;
        }
        boolean bl = true;
        int n = 0;
        while (MathFunctions.abs(d8) > d3 && MathFunctions.abs(d2 - d) > d3 && (double)n < d4) {
            double d13;
            if (d7 != d12 && d8 != d12) {
                double d14 = d * d8 * d12 / ((d7 - d8) * (d7 - d12));
                double d15 = d2 * d7 * d12 / ((d8 - d7) * (d8 - d12));
                double d16 = d5 * d7 * d8 / ((d12 - d7) * (d12 - d8));
                d13 = d14 + d15 + d16;
            } else {
                d13 = d2 - d8 * (d2 - d) / (d8 - d7);
            }
            if (d13 < 3.0 * (d + d2) / 4.0 || d13 > d2 || bl && MathFunctions.abs(d13 - d2) >= MathFunctions.abs(d2 - d5) / 2.0 || !bl && MathFunctions.abs(d13 - d2) >= MathFunctions.abs(d5 - d11) / 2.0) {
                d13 = (d + d2) / 2.0;
                bl = true;
            } else {
                bl = true;
            }
            double d17 = mXparser.getFunctionValue(expression, argument, d13);
            d11 = d5;
            d5 = d2;
            d12 = d8;
            if (d7 * d17 < 0.0) {
                d2 = d13;
            } else {
                d = d13;
            }
            if (MathFunctions.abs(d7) < MathFunctions.abs(d8)) {
                d6 = d;
                d = d2;
                d2 = d6;
                d6 = d7;
                d7 = d8;
                d8 = d6;
            }
            ++n;
        }
        return MathFunctions.round(d2, MathFunctions.decimalDigitsBefore(d3) - 1);
    }
}

