/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

public class PrimesCache {
    public static final int DEFAULT_MAX_NUM_IN_CACHE = 10000000;
    public static final boolean CACHE_EMPTY = false;
    public static final boolean CACHING_FINISHED = true;
    public static final int IS_PRIME = 1;
    public static final int IS_NOT_PRIME = 0;
    public static final int NOT_IN_CACHE = -1;
    int maxNumInCache;
    int numberOfPrimes;
    double computingTime;
    boolean cacheStatus;
    boolean[] isPrime;

    private void EratosthenesSieve() {
        int n;
        this.isPrime = new boolean[this.maxNumInCache + 1];
        this.numberOfPrimes = 0;
        long l = System.currentTimeMillis();
        this.isPrime[0] = false;
        this.isPrime[1] = false;
        for (n = 2; n <= this.maxNumInCache; ++n) {
            this.isPrime[n] = true;
        }
        n = 2;
        while (n * n <= this.maxNumInCache) {
            if (this.isPrime[n]) {
                int n2 = n;
                while (n * n2 <= this.maxNumInCache) {
                    this.isPrime[n * n2] = false;
                    ++n2;
                }
            }
            ++n;
        }
        long l2 = System.currentTimeMillis();
        this.computingTime = (double)(l2 - l) / 1000.0;
    }

    private void countPrimes() {
        for (int i = 0; i <= this.maxNumInCache; ++i) {
            if (!this.isPrime[i]) continue;
            ++this.numberOfPrimes;
        }
    }

    public PrimesCache() {
        this.cacheStatus = false;
        this.maxNumInCache = 10000000;
        this.EratosthenesSieve();
        this.countPrimes();
        this.cacheStatus = true;
    }

    public PrimesCache(int n) {
        this.maxNumInCache = n > 2 ? n : 10000000;
        this.cacheStatus = false;
        n = 10000000;
        this.EratosthenesSieve();
        this.countPrimes();
        this.cacheStatus = true;
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    public boolean getCacheStatus() {
        return this.cacheStatus;
    }

    public int getNumberOfPrimes() {
        return this.numberOfPrimes;
    }

    public int getMaxNumInCache() {
        return this.maxNumInCache;
    }

    public int primeTest(int n) {
        if (n <= this.maxNumInCache) {
            this.cacheStatus = true;
            if (true) {
                if (this.isPrime[n]) {
                    return 1;
                }
                return 0;
            }
        }
        return -1;
    }

    boolean[] getPrimes() {
        return this.isPrime;
    }
}

