/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import java.util.Random;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.SpecialFunctions;

public final class ProbabilityDistributions {
    public static Random randomGenerator = new Random();

    public static final double rndUniformContinuous(double d, double d2, Random random) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d2 < d) {
            return Double.NaN;
        }
        if (d == d2) {
            return d;
        }
        double d3 = d + random.nextDouble() * (d2 - d);
        return d3;
    }

    public static final double rndUniformContinuous(double d, double d2) {
        return ProbabilityDistributions.rndUniformContinuous(d, d2, randomGenerator);
    }

    public static final double rndUniformContinuous(Random random) {
        return random.nextDouble();
    }

    public static final double randomUniformContinuous() {
        return ProbabilityDistributions.rndUniformContinuous(randomGenerator);
    }

    public static final double pdfUniformContinuous(double d, double d2, double d3) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d3 < d2) {
            return Double.NaN;
        }
        if (d2 == d3) {
            if (d == d2) {
                return 1.0;
            }
            return 0.0;
        }
        if (d < d2 || d > d3) {
            return 0.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        return 1.0 / (d3 - d2);
    }

    public static final double cdfUniformContinuous(double d, double d2, double d3) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d3 < d2) {
            return Double.NaN;
        }
        if (d2 == d3) {
            if (d < d2) {
                return 0.0;
            }
            return 1.0;
        }
        if (d < d2) {
            return 0.0;
        }
        if (d >= d3) {
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return (d - d2) / (d3 - d2);
    }

    public static final double qntUniformContinuous(double d, double d2, double d3) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d < 0.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d3 < d2) {
            return Double.NaN;
        }
        if (d2 == d3) {
            if (d == 1.0) {
                return d3;
            }
            return Double.NaN;
        }
        if (d == 0.0) {
            return d2;
        }
        if (d == 1.0) {
            return d3;
        }
        return d2 + d * (d3 - d2);
    }

    public static final double rndInteger(int n, int n2, Random random) {
        if (Double.isNaN(n)) {
            return Double.NaN;
        }
        if (Double.isNaN(n2)) {
            return Double.NaN;
        }
        if (n2 < n) {
            return Double.NaN;
        }
        if (n == n2) {
            return n;
        }
        int n3 = n2 - n + 1;
        int n4 = n + random.nextInt(n3);
        return n4;
    }

    public static final double rndInteger(int n, int n2) {
        return ProbabilityDistributions.rndInteger(n, n2, randomGenerator);
    }

    public static final int rndInteger(Random random) {
        return random.nextInt();
    }

    public static final int rndIndex(int n, Random random) {
        if (n < 0) {
            return -1;
        }
        return random.nextInt(n);
    }

    public static final int rndIndex(int n) {
        if (n < 0) {
            return -1;
        }
        return randomGenerator.nextInt(n);
    }

    public static final int rndInteger() {
        return ProbabilityDistributions.rndInteger(randomGenerator);
    }

    public static final double rndNormal(double d, double d2, Random random) {
        double d3;
        boolean bl;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (random == null) {
            return Double.NaN;
        }
        if (d2 < 0.0) {
            return Double.NaN;
        }
        if (d2 == 0.0) {
            return d;
        }
        do {
            double d4;
            double d5;
            double d6;
            double d7;
            double d8;
            if ((d8 = (d7 = 2.0 * (d6 = random.nextDouble()) - 1.0) * d7 + (d5 = 2.0 * (d4 = random.nextDouble()) - 1.0) * d5) >= 1.0 || d8 == 0.0) {
                d3 = 0.0;
                bl = false;
                continue;
            }
            double d9 = MathFunctions.sqrt(-2.0 * MathFunctions.ln(d8) / d8);
            d3 = d7 * d9;
            bl = true;
        } while (!bl);
        return d + d2 * d3;
    }

    public static final double rndNormal(double d, double d2) {
        return ProbabilityDistributions.rndNormal(d, d2, randomGenerator);
    }

    public static final double pdfNormal(double d, double d2, double d3) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d3 < 0.0) {
            return Double.NaN;
        }
        if (d3 == 0.0) {
            if (d == d2) {
                return 1.0;
            }
            return 0.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double d4 = (d - d2) / d3;
        return MathFunctions.exp(-0.5 * d4 * d4) / (2.5066282746310007 * d3);
    }

    public static final double cdfNormal(double d, double d2, double d3) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d3 < 0.0) {
            return Double.NaN;
        }
        if (d3 == 0.0) {
            if (d < d2) {
                return 0.0;
            }
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        return 0.5 * SpecialFunctions.erfc((d2 - d) / (d3 * 1.4142135623730951));
    }

    public static final double qntNormal(double d, double d2, double d3) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d < 0.0 || d > 1.0) {
            return Double.NaN;
        }
        if (d3 < 0.0) {
            return Double.NaN;
        }
        if (d3 == 0.0) {
            if (d == 1.0) {
                return d2;
            }
            return Double.NaN;
        }
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return d2 - d3 * 1.4142135623730951 * SpecialFunctions.erfcInv(2.0 * d);
    }
}

