/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.mathcollection.Coefficients;
import org.mariuszgromada.math.mxparser.mathcollection.Evaluate;
import org.mariuszgromada.math.mxparser.mathcollection.MathConstants;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;

public final class SpecialFunctions {
    private static final double EI_DBL_EPSILON = Math.ulp(1.0);
    private static final double EI_EPSILON = 10.0 * EI_DBL_EPSILON;
    private static final int doubleWidth = 53;
    private static final double doublePrecision = Math.pow(2.0, -53.0);
    private static final double GSL_DBL_EPSILON = 2.220446049250313E-16;

    public static double exponentialIntegralEi(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < -5.0) {
            return SpecialFunctions.continuedFractionEi(d);
        }
        if (d == 0.0) {
            return -1.7976931348623157E308;
        }
        if (d < 6.8) {
            return SpecialFunctions.powerSeriesEi(d);
        }
        if (d < 50.0) {
            return SpecialFunctions.argumentAdditionSeriesEi(d);
        }
        return SpecialFunctions.continuedFractionEi(d);
    }

    private static double continuedFractionEi(double d) {
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = Math.exp(d);
        double d7 = -d + 1.0;
        double d8 = d7 * d3 + d6 * d2;
        double d9 = d7 * d5 + d6 * d4;
        int n = 1;
        d6 = 1.0;
        while (Math.abs(d8 * d5 - d3 * d9) > EI_EPSILON * Math.abs(d3 * d9)) {
            if (Math.abs(d9) > 1.0) {
                d2 = d3 / d9;
                d3 = d8 / d9;
                d4 = d5 / d9;
                d5 = 1.0;
            } else {
                d2 = d3;
                d3 = d8;
                d4 = d5;
                d5 = d9;
            }
            d6 = -n * n;
            d8 = (d7 += 2.0) * d3 + d6 * d2;
            d9 = d7 * d5 + d6 * d4;
            ++n;
        }
        return -d8 / d9;
    }

    private static double powerSeriesEi(double d) {
        double d2 = -d;
        double d3 = -d;
        double d4 = 0.0;
        double d5 = 1.0;
        double d6 = 1.0;
        double d7 = 1.0;
        if (d == 0.0) {
            return -1.7976931348623157E308;
        }
        while (Math.abs(d3 - d4) > EI_EPSILON * Math.abs(d4)) {
            d4 = d3;
            d3 += (d5 += 1.0 / d6) * (d2 *= -d) / (d7 *= (d6 += 1.0));
        }
        return 0.5772156649015329 + Math.log(Math.abs(d)) - Math.exp(d) * d3;
    }

    private static double argumentAdditionSeriesEi(double d) {
        int n = (int)(d + 0.5);
        int n2 = 0;
        double d2 = n;
        double d3 = d - d2;
        double d4 = d2;
        double d5 = Math.exp(d3);
        double d6 = 1.0;
        double d7 = (d5 - 1.0) / d4;
        double d8 = Double.MAX_VALUE;
        double d9 = 1.0;
        double d10 = 1.0;
        while (Math.abs(d8) > EI_EPSILON * Math.abs(d7)) {
            d8 = d9 * (d5 * (d6 += (d10 *= -d3) / (d9 *= (double)(++n2))) - 1.0) / (d4 *= d2);
            d7 += d8;
        }
        return Coefficients.EI[n - 7] + d7 * Math.exp(d2);
    }

    public static final double logarithmicIntegralLi(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == 2.0) {
            return 1.045163780117493;
        }
        return SpecialFunctions.exponentialIntegralEi(MathFunctions.ln(d));
    }

    public static final double offsetLogarithmicIntegralLi(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < 0.0) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return -1.045163780117493;
        }
        return SpecialFunctions.logarithmicIntegralLi(d) - 1.045163780117493;
    }

    public static final double erf(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 0.0;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return -1.0;
        }
        return SpecialFunctions.erfImp(d, false);
    }

    public static final double erfc(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == 0.0) {
            return 1.0;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return 2.0;
        }
        return SpecialFunctions.erfImp(d, true);
    }

    public static final double erfInv(double d) {
        double d2;
        double d3;
        double d4;
        if (d == 0.0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d <= -1.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d < 0.0) {
            d4 = -d;
            d3 = 1.0 - d4;
            d2 = -1.0;
        } else {
            d4 = d;
            d3 = 1.0 - d;
            d2 = 1.0;
        }
        return SpecialFunctions.erfInvImpl(d4, d3, d2);
    }

    private static final double erfImp(double d, boolean bl) {
        double d2;
        if (d < 0.0) {
            if (!bl) {
                return -SpecialFunctions.erfImp(-d, false);
            }
            if (d < -0.5) {
                return 2.0 - SpecialFunctions.erfImp(-d, true);
            }
            return 1.0 + SpecialFunctions.erfImp(-d, false);
        }
        if (d < 0.5) {
            d2 = d < 1.0E-10 ? d * 1.125 + d * 0.0033791670955125737 : d * 1.125 + d * Evaluate.polynomial(d, Coefficients.erfImpAn) / Evaluate.polynomial(d, Coefficients.erfImpAd);
        } else if (d < 110.0 || d < 110.0 && bl) {
            double d3;
            double d4;
            boolean bl2 = bl = !bl;
            if (d < 0.75) {
                d4 = Evaluate.polynomial(d - 0.5, Coefficients.erfImpBn) / Evaluate.polynomial(d - 0.5, Coefficients.erfImpBd);
                d3 = 0.3440242111682892;
            } else if (d < 1.25) {
                d4 = Evaluate.polynomial(d - 0.75, Coefficients.erfImpCn) / Evaluate.polynomial(d - 0.75, Coefficients.erfImpCd);
                d3 = 0.4199909269809723;
            } else if (d < 2.25) {
                d4 = Evaluate.polynomial(d - 1.25, Coefficients.erfImpDn) / Evaluate.polynomial(d - 1.25, Coefficients.erfImpDd);
                d3 = 0.4898625f;
            } else if (d < 3.5) {
                d4 = Evaluate.polynomial(d - 2.25, Coefficients.erfImpEn) / Evaluate.polynomial(d - 2.25, Coefficients.erfImpEd);
                d3 = 0.5317370891571045;
            } else if (d < 5.25) {
                d4 = Evaluate.polynomial(d - 3.5, Coefficients.erfImpFn) / Evaluate.polynomial(d - 3.5, Coefficients.erfImpFd);
                d3 = 0.5489973425865173;
            } else if (d < 8.0) {
                d4 = Evaluate.polynomial(d - 5.25, Coefficients.erfImpGn) / Evaluate.polynomial(d - 5.25, Coefficients.erfImpGd);
                d3 = 0.5571740865707397;
            } else if (d < 11.5) {
                d4 = Evaluate.polynomial(d - 8.0, Coefficients.erfImpHn) / Evaluate.polynomial(d - 8.0, Coefficients.erfImpHd);
                d3 = 0.5609807968139648;
            } else if (d < 17.0) {
                d4 = Evaluate.polynomial(d - 11.5, Coefficients.erfImpIn) / Evaluate.polynomial(d - 11.5, Coefficients.erfImpId);
                d3 = 0.5626493692398071;
            } else if (d < 24.0) {
                d4 = Evaluate.polynomial(d - 17.0, Coefficients.erfImpJn) / Evaluate.polynomial(d - 17.0, Coefficients.erfImpJd);
                d3 = 0.5634598135948181;
            } else if (d < 38.0) {
                d4 = Evaluate.polynomial(d - 24.0, Coefficients.erfImpKn) / Evaluate.polynomial(d - 24.0, Coefficients.erfImpKd);
                d3 = 0.5638477802276611;
            } else if (d < 60.0) {
                d4 = Evaluate.polynomial(d - 38.0, Coefficients.erfImpLn) / Evaluate.polynomial(d - 38.0, Coefficients.erfImpLd);
                d3 = 0.5640528202056885;
            } else if (d < 85.0) {
                d4 = Evaluate.polynomial(d - 60.0, Coefficients.erfImpMn) / Evaluate.polynomial(d - 60.0, Coefficients.erfImpMd);
                d3 = 0.5641309022903442;
            } else {
                d4 = Evaluate.polynomial(d - 85.0, Coefficients.erfImpNn) / Evaluate.polynomial(d - 85.0, Coefficients.erfImpNd);
                d3 = 0.5641584396362305;
            }
            double d5 = MathFunctions.exp(-d * d) / d;
            d2 = d5 * d3 + d5 * d4;
        } else {
            d2 = 0.0;
            boolean bl3 = bl = !bl;
        }
        if (bl) {
            d2 = 1.0 - d2;
        }
        return d2;
    }

    public static final double erfcInv(double d) {
        double d2;
        double d3;
        double d4;
        if (d <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (d >= 2.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (d > 1.0) {
            d4 = 2.0 - d;
            d3 = 1.0 - d4;
            d2 = -1.0;
        } else {
            d3 = 1.0 - d;
            d4 = d;
            d2 = 1.0;
        }
        return SpecialFunctions.erfInvImpl(d3, d4, d2);
    }

    private static final double erfInvImpl(double d, double d2, double d3) {
        double d4;
        if (d <= 0.5) {
            double d5 = d * (d + 10.0);
            double d6 = Evaluate.polynomial(d, Coefficients.ervInvImpAn) / Evaluate.polynomial(d, Coefficients.ervInvImpAd);
            d4 = d5 * 0.08913147449493408 + d5 * d6;
        } else if (d2 >= 0.25) {
            double d7 = MathFunctions.sqrt(-2.0 * MathFunctions.ln(d2));
            double d8 = d2 - 0.25;
            double d9 = Evaluate.polynomial(d8, Coefficients.ervInvImpBn) / Evaluate.polynomial(d8, Coefficients.ervInvImpBd);
            d4 = d7 / (2.249481201171875 + d9);
        } else {
            double d10 = MathFunctions.sqrt(-MathFunctions.ln(d2));
            if (d10 < 3.0) {
                double d11 = d10 - 1.125;
                double d12 = Evaluate.polynomial(d11, Coefficients.ervInvImpCn) / Evaluate.polynomial(d11, Coefficients.ervInvImpCd);
                d4 = 0.807220458984375 * d10 + d12 * d10;
            } else if (d10 < 6.0) {
                double d13 = d10 - 3.0;
                double d14 = Evaluate.polynomial(d13, Coefficients.ervInvImpDn) / Evaluate.polynomial(d13, Coefficients.ervInvImpDd);
                d4 = 0.9399557113647461 * d10 + d14 * d10;
            } else if (d10 < 18.0) {
                double d15 = d10 - 6.0;
                double d16 = Evaluate.polynomial(d15, Coefficients.ervInvImpEn) / Evaluate.polynomial(d15, Coefficients.ervInvImpEd);
                d4 = 0.9836282730102539 * d10 + d16 * d10;
            } else if (d10 < 44.0) {
                double d17 = d10 - 18.0;
                double d18 = Evaluate.polynomial(d17, Coefficients.ervInvImpFn) / Evaluate.polynomial(d17, Coefficients.ervInvImpFd);
                d4 = 0.9971456527709961 * d10 + d18 * d10;
            } else {
                double d19 = d10 - 44.0;
                double d20 = Evaluate.polynomial(d19, Coefficients.ervInvImpGn) / Evaluate.polynomial(d19, Coefficients.ervInvImpGd);
                d4 = 0.9994134902954102 * d10 + d20 * d10;
            }
        }
        return d3 * d4;
    }

    private static final double gammaInt(long l) {
        if (l == 0L) {
            return 0.5772156649015329;
        }
        if (l == 1L) {
            return 1.0;
        }
        if (l == 2L) {
            return 1.0;
        }
        if (l == 3L) {
            return 2.0;
        }
        if (l == 4L) {
            return 6.0;
        }
        if (l == 5L) {
            return 24.0;
        }
        if (l == 6L) {
            return 120.0;
        }
        if (l == 7L) {
            return 720.0;
        }
        if (l == 8L) {
            return 5040.0;
        }
        if (l == 9L) {
            return 40320.0;
        }
        if (l == 10L) {
            return 362880.0;
        }
        if (l >= 11L) {
            return MathFunctions.factorial(l - 1L);
        }
        if (l <= -1L) {
            long l2 = -l;
            double d = MathFunctions.factorial(l2);
            double d2 = -1.0;
            if (l2 % 2L == 0L) {
                d2 = 1.0;
            }
            return d2 / ((double)l2 * d) - 1.0 / (double)l2 * SpecialFunctions.gammaInt(l + 1L);
        }
        return Double.NaN;
    }

    public static final double gamma(double d) {
        double d2;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        double d3 = MathFunctions.abs(d);
        if (MathFunctions.abs(d3 - (d2 = (double)Math.round(d3))) <= 1.0E-14) {
            long l = (long)d2;
            if (d < 0.0) {
                l = -l;
            }
            return SpecialFunctions.gammaInt(l);
        }
        return SpecialFunctions.lanchosGamma(d);
    }

    public static final double lanchosGamma(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        double d2 = MathFunctions.abs(d);
        double d3 = Math.round(d2);
        if (d > 1.0E-14) {
            if (MathFunctions.abs(d2 - d3) <= 1.0E-14) {
                return MathFunctions.factorial(d3 - 1.0);
            }
        } else if (d < -1.0E-14) {
            if (MathFunctions.abs(d2 - d3) <= 1.0E-14) {
                return Double.NaN;
            }
        } else {
            return Double.NaN;
        }
        if (d < 0.5) {
            return Math.PI / (MathFunctions.sin(Math.PI * d) * SpecialFunctions.lanchosGamma(1.0 - d));
        }
        int n = 7;
        double d4 = Coefficients.lanchosGamma[0];
        double d5 = (d -= 1.0) + (double)n + 0.5;
        for (int i = 1; i < Coefficients.lanchosGamma.length; ++i) {
            d4 += Coefficients.lanchosGamma[i] / (d + (double)i);
        }
        return MathFunctions.sqrt(Math.PI * 2) * MathFunctions.power(d5, d + 0.5) * MathFunctions.exp(-d5) * d4;
    }

    public static double logGamma(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return Double.POSITIVE_INFINITY;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        if (MathFunctions.isInteger(d)) {
            if (d >= 0.0) {
                return MathFunctions.ln(Math.abs(SpecialFunctions.gammaInt(Math.round(d))));
            }
            return MathFunctions.ln(Math.abs(SpecialFunctions.gammaInt(-Math.round(-d))));
        }
        if (d < -34.0) {
            double d2 = -d;
            double d3 = SpecialFunctions.logGamma(d2);
            double d4 = Math.floor(d2);
            if (Math.abs(d4 - d2) <= 1.0E-14) {
                return Double.NaN;
            }
            double d5 = d2 - d4;
            if (d5 > 0.5) {
                d5 = (d4 += 1.0) - d2;
            }
            if (Math.abs(d5 = d2 * Math.sin(Math.PI * d5)) <= 1.0E-14) {
                return Double.NaN;
            }
            d5 = MathConstants.LNPI - Math.log(d5) - d3;
            return d5;
        }
        if (d < 13.0) {
            double d6 = 1.0;
            while (d >= 3.0) {
                d6 *= (d -= 1.0);
            }
            while (d < 2.0) {
                if (Math.abs(d) <= 1.0E-14) {
                    return Double.NaN;
                }
                d6 /= d;
                d += 1.0;
            }
            if (d6 < 0.0) {
                d6 = -d6;
            }
            if (d == 2.0) {
                return Math.log(d6);
            }
            double d7 = (d -= 2.0) * Evaluate.polevl(d, Coefficients.logGammaB, 5) / Evaluate.p1evl(d, Coefficients.logGammaC, 6);
            return Math.log(d6) + d7;
        }
        if (d > 2.556348E305) {
            return Double.NaN;
        }
        double d8 = (d - 0.5) * Math.log(d) - d + 0.9189385332046728;
        if (d > 1.0E8) {
            return d8;
        }
        double d9 = 1.0 / (d * d);
        d8 = d >= 1000.0 ? (d8 += ((7.936507936507937E-4 * d9 - 0.002777777777777778) * d9 + 0.08333333333333333) / d) : (d8 += Evaluate.polevl(d9, Coefficients.logGammaA, 4) / d);
        return d8;
    }

    public static final double sgnGamma(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        if (d > 0.0) {
            return 1.0;
        }
        if (MathFunctions.isInteger(d)) {
            return MathFunctions.sgn(SpecialFunctions.gammaInt(-Math.round(-d)));
        }
        double d2 = Math.floor(d = -d);
        double d3 = Math.floor(d2 % 2.0);
        if (d3 == 0.0) {
            return -1.0;
        }
        return 1.0;
    }

    public static final double regularizedGammaLowerP(double d, double d2) {
        double d3;
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (MathFunctions.almostEqual(d2, 0.0)) {
            return 0.0;
        }
        if (MathFunctions.almostEqual(d, 0.0)) {
            return 1.0 + SpecialFunctions.exponentialIntegralEi(-d2) / 0.5772156649015329;
        }
        if (MathFunctions.almostEqual(d, 1.0)) {
            return 1.0 - Math.exp(-d2);
        }
        if (d2 < 0.0) {
            return Double.NaN;
        }
        if (d < 0.0) {
            return SpecialFunctions.regularizedGammaLowerP(d + 1.0, d2) + Math.pow(d2, d) * Math.exp(-d2) / (d * SpecialFunctions.gamma(d));
        }
        double d4 = d * Math.log(d2) - d2 - SpecialFunctions.logGamma(d);
        if (d4 < -709.782712893384) {
            return 1.0;
        }
        if (d2 <= 1.0 || d2 <= d) {
            double d5 = d;
            double d6 = 1.0;
            double d7 = 1.0;
            while ((d6 = d6 * d2 / (d5 += 1.0)) / (d7 += d6) > 1.0E-15) {
            }
            return Math.exp(d4) * d7 / d;
        }
        int n = 0;
        double d8 = 1.0 - d;
        double d9 = d2 + d8 + 1.0;
        double d10 = 1.0;
        double d11 = d2;
        double d12 = d2 + 1.0;
        double d13 = d9 * d2;
        double d14 = d12 / d13;
        do {
            double d15 = (d8 += 1.0) * (double)(++n);
            double d16 = d12 * (d9 += 2.0) - d10 * d15;
            double d17 = d13 * d9 - d11 * d15;
            if (d17 != 0.0) {
                double d18 = d16 / d17;
                d3 = Math.abs((d14 - d18) / d18);
                d14 = d18;
            } else {
                d3 = 1.0;
            }
            d10 = d12;
            d12 = d16;
            d11 = d13;
            d13 = d17;
            if (!(Math.abs(d16) > 4.503599627370496E15)) continue;
            d10 *= 2.220446049250313E-16;
            d12 *= 2.220446049250313E-16;
            d11 *= 2.220446049250313E-16;
            d13 *= 2.220446049250313E-16;
        } while (d3 > 1.0E-15);
        return 1.0 - Math.exp(d4) * d14;
    }

    public static final double incompleteGammaLower(double d, double d2) {
        return SpecialFunctions.gamma(d) * SpecialFunctions.regularizedGammaLowerP(d, d2);
    }

    public static final double regularizedGammaUpperQ(double d, double d2) {
        double d3;
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (MathFunctions.almostEqual(d2, 0.0)) {
            return 1.0;
        }
        if (MathFunctions.almostEqual(d, 0.0)) {
            return -SpecialFunctions.exponentialIntegralEi(-d2) / 0.5772156649015329;
        }
        if (MathFunctions.almostEqual(d, 1.0)) {
            return Math.exp(-d2);
        }
        if (d2 < 0.0) {
            return Double.NaN;
        }
        if (d < 0.0) {
            return SpecialFunctions.regularizedGammaUpperQ(d + 1.0, d2) - Math.pow(d2, d) * Math.exp(-d2) / (d * SpecialFunctions.gamma(d));
        }
        double d4 = d * Math.log(d2) - d2 - SpecialFunctions.logGamma(d);
        if (d4 < -709.782712893384) {
            return 0.0;
        }
        d4 = Math.exp(d4);
        double d5 = 1.0 - d;
        double d6 = d2 + d5 + 1.0;
        double d7 = 0.0;
        double d8 = 1.0;
        double d9 = d2;
        double d10 = d2 + 1.0;
        double d11 = d6 * d2;
        double d12 = d10 / d11;
        do {
            double d13 = (d5 += 1.0) * (d7 += 1.0);
            double d14 = d10 * (d6 += 2.0) - d8 * d13;
            double d15 = d11 * d6 - d9 * d13;
            if (d15 != 0.0) {
                double d16 = d14 / d15;
                d3 = Math.abs((d12 - d16) / d16);
                d12 = d16;
            } else {
                d3 = 1.0;
            }
            d8 = d10;
            d10 = d14;
            d9 = d11;
            d11 = d15;
            if (!(Math.abs(d14) > 4.503599627370496E15)) continue;
            d8 *= 2.220446049250313E-16;
            d10 *= 2.220446049250313E-16;
            d9 *= 2.220446049250313E-16;
            d11 *= 2.220446049250313E-16;
        } while (d3 > 1.0E-15);
        return d12 * d4;
    }

    public static final double incompleteGammaUpper(double d, double d2) {
        return SpecialFunctions.gamma(d) * SpecialFunctions.regularizedGammaUpperQ(d, d2);
    }

    public static final double diGamma(double d) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        if (d <= 0.0 && MathFunctions.isInteger(d)) {
            return Double.NaN;
        }
        if (d < 0.0) {
            return SpecialFunctions.diGamma(1.0 - d) + Math.PI / Math.tan(-Math.PI * d);
        }
        if (d <= 1.0E-6) {
            return -0.5772156649015329 - 1.0 / d + 1.6449340668482264 * d;
        }
        double d2 = 0.0;
        while (d < 12.0) {
            d2 -= 1.0 / d;
            d += 1.0;
        }
        if (d >= 12.0) {
            double d3 = 1.0 / d;
            d2 += Math.log(d) - 0.5 * d3;
            d3 *= d3;
            d2 -= d3 * (0.08333333333333333 - d3 * (0.008333333333333333 - d3 * (0.003968253968253968 - d3 * (0.004166666666666667 - d3 * 0.007575757575757576))));
        }
        return d2;
    }

    public static double logBeta(double d, double d2) {
        double d3;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d <= 0.0 || d2 <= 0.0) {
            return Double.NaN;
        }
        double d4 = SpecialFunctions.logGamma(d);
        if (Double.isNaN(d4)) {
            d4 = Math.log(Math.abs(SpecialFunctions.gamma(d)));
        }
        if (Double.isNaN(d3 = SpecialFunctions.logGamma(d2))) {
            d3 = Math.log(Math.abs(SpecialFunctions.gamma(d2)));
        }
        double d5 = SpecialFunctions.logGamma(d + d2);
        if (Double.isNaN(d3)) {
            d5 = Math.log(Math.abs(SpecialFunctions.gamma(d + d2)));
        }
        if (!(Double.isNaN(d4) || Double.isNaN(d3) || Double.isNaN(d5))) {
            return d4 + d3 - d5;
        }
        return Double.NaN;
    }

    public static double beta(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d <= 0.0 || d2 <= 0.0) {
            return Double.NaN;
        }
        if (d > 99.0 || d2 > 99.0) {
            return Math.exp(SpecialFunctions.logBeta(d, d2));
        }
        return SpecialFunctions.gamma(d) * SpecialFunctions.gamma(d2) / SpecialFunctions.gamma(d + d2);
    }

    public static double incompleteBeta(double d, double d2, double d3) {
        long l;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d3 < -1.0E-14) {
            return Double.NaN;
        }
        if (d3 > 1.00000000000001) {
            return Double.NaN;
        }
        if (d <= 0.0 || d2 <= 0.0) {
            return Double.NaN;
        }
        if (MathFunctions.almostEqual(d3, 0.0)) {
            return 0.0;
        }
        if (MathFunctions.almostEqual(d3, 1.0)) {
            return SpecialFunctions.beta(d, d2);
        }
        boolean bl = MathFunctions.almostEqual(d, 0.0);
        boolean bl2 = MathFunctions.almostEqual(d2, 0.0);
        boolean bl3 = MathFunctions.isInteger(d);
        boolean bl4 = MathFunctions.isInteger(d2);
        long l2 = 0L;
        long l3 = 0L;
        if (bl3) {
            l2 = (long)MathFunctions.integerPart(d);
        }
        if (bl4) {
            l3 = (long)MathFunctions.integerPart(d2);
        }
        if (bl && bl2) {
            return Math.log(d3 / (1.0 - d3));
        }
        if (bl && bl4) {
            l = l3;
            if (l >= 1L) {
                if (l == 1L) {
                    return Math.log(d3);
                }
                if (l == 2L) {
                    return Math.log(d3) + d3;
                }
                double d4 = Math.log(d3);
                for (long i = 1L; i <= l - 1L; ++i) {
                    d4 -= MathFunctions.binomCoeff((double)(l - 1L), i) * Math.pow(-1.0, i) * (Math.pow(d3, i) / (double)i);
                }
                return d4;
            }
            if (l <= -1L) {
                if (l == -1L) {
                    return Math.log(d3 / (1.0 - d3)) + 1.0 / (1.0 - d3) - 1.0;
                }
                if (l == -2L) {
                    return Math.log(d3 / (1.0 - d3)) - 1.0 / d3 - 1.0 / (2.0 * d3 * d3);
                }
                double d5 = -Math.log(d3 / (1.0 - d3));
                for (long i = 1L; i <= -l - 1L; ++i) {
                    d5 -= Math.pow(d3, -i) / (double)i;
                }
                return d5;
            }
        }
        if (bl3 && bl2) {
            l = l2;
            if (l >= 1L) {
                if (l == 1L) {
                    return -Math.log(1.0 - d3);
                }
                if (l == 2L) {
                    return -Math.log(1.0 - d3) - d3;
                }
                double d6 = -Math.log(1.0 - d3);
                for (long i = 1L; i <= l - 1L; ++i) {
                    d6 -= Math.pow(d3, i) / (double)i;
                }
                return d6;
            }
            if (l <= -1L) {
                long l4;
                if (l == -1L) {
                    return Math.log(d3 / (1.0 - d3)) - 1.0 / d3;
                }
                double d7 = -Math.log(d3 / (1.0 - d3));
                for (l4 = 1L; l4 <= -l; ++l4) {
                    d7 += Math.pow(1.0 - d3, -l4) / (double)l4;
                }
                for (l4 = 1L; l4 <= -l; ++l4) {
                    d7 -= Math.pow(MathFunctions.factorial(l4 - 1L), 2.0) / (double)l4;
                }
                return d7;
            }
        }
        if (bl3) {
            l = l2;
            if (MathFunctions.almostEqual(d2, 1.0) && l <= -1L) {
                return (double)(-(1L / -l)) * Math.pow(d3, l);
            }
        }
        return SpecialFunctions.regularizedBeta(d, d2, d3) * SpecialFunctions.beta(d, d2);
    }

    public static double regularizedBeta(double d, double d2, double d3) {
        double d4;
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Double.isNaN(d3)) {
            return Double.NaN;
        }
        if (d <= 0.0 || d2 <= 0.0) {
            return Double.NaN;
        }
        if (d3 < -1.0E-14) {
            return Double.NaN;
        }
        if (d3 > 1.00000000000001) {
            return Double.NaN;
        }
        if (MathFunctions.almostEqual(d3, 0.0)) {
            return 0.0;
        }
        if (MathFunctions.almostEqual(d3, 1.0)) {
            return 1.0;
        }
        double d5 = d3 == 0.0 || d3 == 1.0 ? 0.0 : Math.exp(SpecialFunctions.logGamma(d + d2) - SpecialFunctions.logGamma(d) - SpecialFunctions.logGamma(d2) + d * Math.log(d3) + d2 * Math.log(1.0 - d3));
        boolean bl = d3 >= (d + 1.0) / (d + d2 + 2.0);
        double d6 = doublePrecision;
        double d7 = Math.nextUp(0.0) / d6;
        if (bl) {
            d3 = 1.0 - d3;
            d4 = d;
            d = d2;
            d2 = d4;
        }
        d4 = d + d2;
        double d8 = d + 1.0;
        double d9 = d - 1.0;
        double d10 = 1.0;
        double d11 = 1.0 - d4 * d3 / d8;
        if (Math.abs(d11) < d7) {
            d11 = d7;
        }
        double d12 = d11 = 1.0 / d11;
        int n = 1;
        int n2 = 2;
        while (n <= 50000) {
            double d13 = (double)n * (d2 - (double)n) * d3 / ((d9 + (double)n2) * (d + (double)n2));
            if (Math.abs(d11 = 1.0 + d13 * d11) < d7) {
                d11 = d7;
            }
            if (Math.abs(d10 = 1.0 + d13 / d10) < d7) {
                d10 = d7;
            }
            d11 = 1.0 / d11;
            d12 *= d11 * d10;
            d13 = -(d + (double)n) * (d4 + (double)n) * d3 / ((d + (double)n2) * (d8 + (double)n2));
            if (Math.abs(d11 = 1.0 + d13 * d11) < d7) {
                d11 = d7;
            }
            if (Math.abs(d10 = 1.0 + d13 / d10) < d7) {
                d10 = d7;
            }
            d11 = 1.0 / d11;
            double d14 = d11 * d10;
            d12 *= d14;
            if (Math.abs(d14 - 1.0) <= d6) {
                return bl ? 1.0 - d5 * d12 / d : d5 * d12 / d;
            }
            ++n;
            n2 += 2;
        }
        return bl ? 1.0 - d5 * d12 / d : d5 * d12 / d;
    }

    private static final double halleyIteration(double d, double d2, int n) {
        double d3 = d2;
        for (int i = 0; i < n; ++i) {
            double d4 = Math.exp(d3);
            double d5 = d3 + 1.0;
            double d6 = d3 * d4 - d;
            d6 = d3 > 0.0 ? d6 / d5 / d4 : (d6 /= d4 * d5 - 0.5 * (d5 + 1.0) * d6 / d5);
            double d7 = 2.220446049250313E-16 * Math.max(Math.abs(d3 -= d6), 1.0 / (Math.abs(d5) * d4));
            if (!(Math.abs(d6) < d7)) continue;
            return d3;
        }
        return Double.NaN;
    }

    private static final double seriesEval(double d) {
        double d2 = Coefficients.lambertWqNearZero[8] + d * (Coefficients.lambertWqNearZero[9] + d * (Coefficients.lambertWqNearZero[10] + d * Coefficients.lambertWqNearZero[11]));
        double d3 = Coefficients.lambertWqNearZero[5] + d * (Coefficients.lambertWqNearZero[6] + d * (Coefficients.lambertWqNearZero[7] + d * d2));
        double d4 = Coefficients.lambertWqNearZero[1] + d * (Coefficients.lambertWqNearZero[2] + d * (Coefficients.lambertWqNearZero[3] + d * (Coefficients.lambertWqNearZero[4] + d * d3)));
        return Coefficients.lambertWqNearZero[0] + d * d4;
    }

    private static final double lambertW0(double d) {
        double d2;
        if (Math.abs(d) <= 1.0E-14) {
            return 0.0;
        }
        if (Math.abs(d + 0.36787944117144233) <= 1.0E-14) {
            return -1.0;
        }
        if (Math.abs(d - 1.0) <= 1.0E-14) {
            return 0.5671432904097838;
        }
        if (Math.abs(d - Math.E) <= 1.0E-14) {
            return 1.0;
        }
        if (Math.abs(d + MathConstants.LN_SQRT2) <= 1.0E-14) {
            return -2.0 * MathConstants.LN_SQRT2;
        }
        if (d < -0.36787944117144233) {
            return Double.NaN;
        }
        double d3 = d + 0.36787944117144233;
        if (d3 < 0.001) {
            return SpecialFunctions.seriesEval(Math.sqrt(d3));
        }
        if (d < 1.0) {
            double d4 = Math.sqrt(5.43656365691809 * d3);
            d2 = -1.0 + d4 * (1.0 + d4 * (-0.3333333333333333 + d4 * 11.0 / 72.0));
        } else {
            d2 = Math.log(d);
            if (d > 3.0) {
                d2 -= Math.log(d2);
            }
        }
        return SpecialFunctions.halleyIteration(d, d2, 100);
    }

    private static final double lambertW1(double d) {
        if (d >= -1.0E-14) {
            return Double.NaN;
        }
        if (d < -0.36787944117144233) {
            return Double.NaN;
        }
        if (Math.abs(d + 0.36787944117144233) <= 1.0E-14) {
            return -1.0;
        }
        double d2 = 0.3361;
        double d3 = -0.0042;
        double d4 = -0.0201;
        double d5 = -1.0 - MathFunctions.ln(-d);
        return -1.0 - d5 - 2.0 / d2 * (1.0 - 1.0 / (1.0 + d2 * Math.sqrt(d5 / 2.0) / (1.0 + d3 * d5 * Math.exp(d4 * Math.sqrt(d5)))));
    }

    public static final double lambertW(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (Math.abs(d2) <= 1.0E-14) {
            return SpecialFunctions.lambertW0(d);
        }
        if (Math.abs(d2 + 1.0) <= 1.0E-14) {
            return SpecialFunctions.lambertW1(d);
        }
        return Double.NaN;
    }
}

