/*
 * Decompiled with CFR 0.152.
 */
package org.mariuszgromada.math.mxparser.mathcollection;

import org.mariuszgromada.math.mxparser.Argument;
import org.mariuszgromada.math.mxparser.Expression;
import org.mariuszgromada.math.mxparser.mXparser;
import org.mariuszgromada.math.mxparser.mathcollection.MathFunctions;
import org.mariuszgromada.math.mxparser.mathcollection.NumberTheory;

public final class Statistics {
    public static final double avg(Expression expression, Argument argument, double d, double d2, double d3) {
        if (Double.isNaN(d3) || Double.isNaN(d) || Double.isNaN(d2) || d3 == 0.0) {
            return Double.NaN;
        }
        double d4 = 0.0;
        int n = 0;
        if (d2 >= d && d3 > 0.0) {
            double d5;
            for (d5 = d; d5 < d2; d5 += d3) {
                d4 += mXparser.getFunctionValue(expression, argument, d5);
                ++n;
            }
            if (d3 - (d5 - d2) > 0.5 * d3) {
                d4 += mXparser.getFunctionValue(expression, argument, d2);
                ++n;
            }
        } else if (d2 <= d && d3 < 0.0) {
            double d6;
            for (d6 = d; d6 > d2; d6 += d3) {
                d4 += mXparser.getFunctionValue(expression, argument, d6);
                ++n;
            }
            if (-d3 - (d2 - d6) > -0.5 * d3) {
                d4 += mXparser.getFunctionValue(expression, argument, d2);
                ++n;
            }
        } else if (d == d2) {
            return mXparser.getFunctionValue(expression, argument, d);
        }
        return d4 / (double)n;
    }

    public static final double var(Expression expression, Argument argument, double d, double d2, double d3) {
        if (Double.isNaN(d3) || Double.isNaN(d) || Double.isNaN(d2) || d3 == 0.0) {
            return Double.NaN;
        }
        return Statistics.var(mXparser.getFunctionValues(expression, argument, d, d2, d3));
    }

    public static final double std(Expression expression, Argument argument, double d, double d2, double d3) {
        if (Double.isNaN(d3) || Double.isNaN(d) || Double.isNaN(d2) || d3 == 0.0) {
            return Double.NaN;
        }
        return Statistics.std(mXparser.getFunctionValues(expression, argument, d, d2, d3));
    }

    public static final double avg(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        double d = 0.0;
        for (double d2 : dArray) {
            if (Double.isNaN(d2)) {
                return Double.NaN;
            }
            d += d2;
        }
        return d / (double)dArray.length;
    }

    public static final double var(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            if (Double.isNaN(dArray[0])) {
                return Double.NaN;
            }
            return 0.0;
        }
        double d = Statistics.avg(dArray);
        double d2 = 0.0;
        for (double d3 : dArray) {
            if (Double.isNaN(d3)) {
                return Double.NaN;
            }
            d2 += (d3 - d) * (d3 - d);
        }
        return d2 / (double)(dArray.length - 1);
    }

    public static final double std(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            if (Double.isNaN(dArray[0])) {
                return Double.NaN;
            }
            return 0.0;
        }
        return MathFunctions.sqrt(Statistics.var(dArray));
    }

    public static final double median(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        if (dArray.length == 2) {
            return (dArray[0] + dArray[1]) / 2.0;
        }
        for (double d : dArray) {
            if (!Double.isNaN(d)) continue;
            return Double.NaN;
        }
        NumberTheory.sortAsc(dArray);
        if (dArray.length % 2 == 1) {
            int n = (dArray.length - 1) / 2;
            return dArray[n];
        }
        int n = dArray.length / 2 - 1;
        return (dArray[n] + dArray[n + 1]) / 2.0;
    }

    public static final double mode(double ... dArray) {
        if (dArray == null) {
            return Double.NaN;
        }
        if (dArray.length == 0) {
            return Double.NaN;
        }
        if (dArray.length == 1) {
            return dArray[0];
        }
        for (double d : dArray) {
            if (!Double.isNaN(d)) continue;
            return Double.NaN;
        }
        double[][] dArray2 = NumberTheory.getDistValues(dArray, true);
        return dArray2[0][0];
    }
}

