/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf;

import com.qoppa.pdf.IPassword;
import com.qoppa.pdf.PDFException;
import com.qoppa.pdfViewer.h.b;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;

public abstract class DocumentInfo {
    public static final String KEY_TITLE = "Title";
    public static final String KEY_AUTHOR = "Author";
    public static final String KEY_SUBJECT = "Subject";
    public static final String KEY_KEYWORDS = "Keywords";
    public static final String KEY_CREATOR = "Creator";
    public static final String KEY_PRODUCER = "Producer";
    public static final String KEY_TRAPPED = "Trapped";
    public static final String KEY_CREATIONDATE = "CreationDate";
    public static final String KEY_MODDATE = "ModDate";

    public static DocumentInfo getDocumentInfo(String string, IPassword iPassword) throws PDFException {
        BufferedInputStream bufferedInputStream = null;
        try {
            DocumentInfo documentInfo;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            DocumentInfo documentInfo2 = documentInfo = b.b(bufferedInputStream, iPassword);
            return documentInfo2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new PDFException("File not found: " + string);
        }
        finally {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static DocumentInfo getDocumentInfo(InputStream inputStream, IPassword iPassword) throws PDFException {
        return b.b(inputStream, iPassword);
    }

    public static DocumentInfo getDocumentInfo(URL uRL, IPassword iPassword) throws PDFException {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            DocumentInfo documentInfo = b.b(bufferedInputStream, iPassword);
            return documentInfo;
        }
        catch (IOException iOException) {
            throw new PDFException("Error opening URL: " + uRL.toString());
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public abstract String getTitle();

    public abstract void setTitle(String var1) throws PDFException;

    public abstract String getAuthor();

    public abstract String getSubject();

    public abstract String getKeywords();

    public abstract String getCreator();

    public abstract String getProducer();

    public abstract String getTrapped();

    public abstract Date getCreationDate();

    public abstract Date getModDate();

    public abstract int getPageCount();

    public abstract void setAuthor(String var1) throws PDFException;

    public abstract void setCreationDate(Date var1) throws PDFException;

    public abstract void setCreator(String var1) throws PDFException;

    public abstract void setKeywords(String var1) throws PDFException;

    public abstract void setModifiedDate(Date var1) throws PDFException;

    public abstract void setProducer(String var1) throws PDFException;

    public abstract void setSubject(String var1) throws PDFException;

    public abstract String getXMPMetadata(String var1) throws UnsupportedEncodingException;

    public abstract void setXMPMetadata(String var1, String var2) throws PDFException, UnsupportedEncodingException;

    public abstract void setXMPMetadata(byte[] var1) throws PDFException;

    public abstract byte[] getXMPMetadata();

    public abstract void setCustomProperty(String var1, String var2) throws PDFException;

    public abstract String getCustomProperty(String var1);
}

