/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf;

import com.qoppa.pdf.permissions.PasswordPermissions;

public class PDFPermissions
extends PasswordPermissions {
    private boolean w = false;
    protected boolean r = true;
    protected boolean l = true;
    protected boolean m = true;
    protected boolean f = true;
    protected boolean p = true;
    protected boolean h = true;
    protected boolean q = true;
    protected boolean t = true;
    protected boolean n = true;
    protected static final int j = 4;
    protected static final int s = 8;
    protected static final int v = 16;
    protected static final int i = 32;
    protected static final int u = 256;
    protected static final int g = 512;
    protected static final int e = 1024;
    protected static final int o = 2048;
    public static final int ENCRYPTION_RC4_128 = 0;
    public static final int ENCRYPTION_AES_128 = 1;
    public static final int ENCRYPTION_RC4_40 = 2;
    public static final int ENCRYPTION_AES_256 = 3;
    public static final int DO_NOT_USE_ENCRYPTION_AES_256_R5 = 4;

    public PDFPermissions() {
        this(true);
    }

    public PDFPermissions(boolean bl) {
        this.w = false;
        this.r = bl;
        this.l = bl;
        this.m = bl;
        this.f = bl;
        this.p = bl;
        this.h = bl;
        this.q = bl;
        this.t = bl;
        this.n = bl;
    }

    public PDFPermissions(int n2, boolean bl) {
        this.setPermFlag(n2);
        this.w = bl;
    }

    @Override
    public int getPermFlag() {
        int n2 = 0;
        if (this.l) {
            n2 |= 0x800;
        }
        if (this.f) {
            n2 |= 0x400;
        }
        if (this.h) {
            n2 |= 0x200;
        }
        if (this.t) {
            n2 |= 0x100;
        }
        if (this.q) {
            n2 |= 0x20;
        }
        if (this.p) {
            n2 |= 0x10;
        }
        if (this.m) {
            n2 |= 8;
        }
        if (this.r) {
            n2 |= 4;
        }
        return n2;
    }

    @Override
    public boolean hasAllPermissions() {
        return this.f && this.m && this.p && this.h && this.t && this.q && this.r && this.l;
    }

    @Override
    public boolean isAssembleDocumentAllowed() {
        return this.m || this.f;
    }

    @Override
    public boolean isChangeDocumentAllowed() {
        return this.m;
    }

    @Override
    public boolean isExtractTextGraphicsAllowed() {
        return this.p;
    }

    @Override
    public boolean isExtractTextGraphicsForAccessibilityAllowed() {
        return this.p || this.h;
    }

    @Override
    public boolean isFillFormFieldsAllowed() {
        return this.m || this.q || this.t;
    }

    @Override
    public boolean isModifyAnnotsAllowed() {
        return this.m || this.q;
    }

    @Override
    public boolean isPrintAllowed() {
        return this.r;
    }

    @Override
    public boolean isPrintHighResAllowed() {
        return this.l;
    }

    @Override
    public boolean ownerPasswordEntered() {
        return this.w;
    }

    @Override
    public void setAssembleDocumentAllowed(boolean bl) {
        this.f = bl;
    }

    @Override
    public void setChangeDocumentAllowed(boolean bl) {
        this.m = bl;
    }

    @Override
    public void setExtractTextGraphicsAllowed(boolean bl) {
        this.p = bl;
    }

    @Override
    public void setExtractTextGraphicsForAccessibilityAllowed(boolean bl) {
        this.h = bl;
    }

    @Override
    public void setFillFormFieldsAllowed(boolean bl) {
        this.t = bl;
    }

    @Override
    public void setModifyAnnotsAllowed(boolean bl) {
        this.q = bl;
    }

    @Override
    public void setPermFlag(int n2) {
        this.setPrintAllowed(true);
        if ((n2 & 4) == 0) {
            this.setPrintAllowed(false);
        }
        this.setChangeDocumentAllowed(true);
        if ((n2 & 8) == 0) {
            this.setChangeDocumentAllowed(false);
        }
        this.setExtractTextGraphicsAllowed(true);
        if ((n2 & 0x10) == 0) {
            this.setExtractTextGraphicsAllowed(false);
        }
        this.setModifyAnnotsAllowed(true);
        if ((n2 & 0x20) == 0) {
            this.setModifyAnnotsAllowed(false);
        }
        this.setFillFormFieldsAllowed(true);
        if ((n2 & 0x100) == 0) {
            this.setFillFormFieldsAllowed(false);
        }
        this.setExtractTextGraphicsForAccessibilityAllowed(true);
        if ((n2 & 0x200) == 0) {
            this.setExtractTextGraphicsForAccessibilityAllowed(false);
        }
        this.setAssembleDocumentAllowed(true);
        if ((n2 & 0x400) == 0) {
            this.setAssembleDocumentAllowed(false);
        }
        this.setPrintHighResAllowed(true);
        if ((n2 & 0x800) == 0) {
            this.setPrintHighResAllowed(false);
        }
    }

    @Override
    public void setPrintAllowed(boolean bl) {
        this.r = bl;
    }

    @Override
    public void setPrintHighResAllowed(boolean bl) {
        this.l = bl;
    }
}

