/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf;

import com.qoppa.pdf.b.ec;
import com.qoppa.pdf.b.y;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;

public class SignatureSettings {
    private static boolean d = true;
    private static Hashtable<String, Certificate> c = null;
    private static boolean b = true;

    private SignatureSettings() {
    }

    public static void setCaCertsEnabled(boolean bl) {
        if (bl == d) {
            return;
        }
        d = bl;
        SignatureSettings.reloadTrustedCertificates();
    }

    public static boolean isCaCertsEnabled() {
        return d;
    }

    public static void setOSCertsEnabled(boolean bl) {
        if (bl == b) {
            return;
        }
        b = bl;
        SignatureSettings.reloadTrustedCertificates();
    }

    public static boolean isOSCertsEnabled() {
        return b;
    }

    public static void addX509Certificate(X509Certificate x509Certificate) {
        SignatureSettings.getTrustedCertificates().put(SignatureSettings.getUniqueIdentifier(x509Certificate), x509Certificate);
    }

    public static void addKeyStore(KeyStore keyStore) throws KeyStoreException {
        if (keyStore == null) {
            throw new IllegalArgumentException("KeyStore cannot be null");
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = keyStore.getCertificate(string);
            if (certificate == null || !(certificate instanceof X509Certificate)) continue;
            SignatureSettings.getTrustedCertificates().put(SignatureSettings.getUniqueIdentifier((X509Certificate)certificate), certificate);
        }
    }

    public static void reloadTrustedCertificates() {
        if (c != null) {
            c = null;
        }
        SignatureSettings.getTrustedCertificates();
    }

    public static Hashtable<String, Certificate> getTrustedCertificates() {
        if (c == null) {
            c = new Hashtable();
            if (d) {
                SignatureSettings.c();
            }
            if (b) {
                SignatureSettings.b();
            }
        }
        return c;
    }

    private static void c() {
        c.putAll(SignatureSettings.getCaCerts());
    }

    public static Hashtable<String, Certificate> getCaCerts() {
        Hashtable<String, Certificate> hashtable = new Hashtable<String, Certificate>();
        try {
            KeyStore keyStore = SignatureSettings.loadCaKeyStore();
            PKIXParameters pKIXParameters = new PKIXParameters(keyStore);
            for (TrustAnchor trustAnchor : pKIXParameters.getTrustAnchors()) {
                X509Certificate x509Certificate = trustAnchor.getTrustedCert();
                hashtable.put(SignatureSettings.getUniqueIdentifier(x509Certificate), x509Certificate);
            }
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
        return hashtable;
    }

    public static KeyStore loadCaKeyStore() {
        try {
            String string = String.valueOf(System.getProperty("java.home")) + "/lib/security/cacerts";
            FileInputStream fileInputStream = new FileInputStream(string);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String string2 = "changeit";
            keyStore.load(fileInputStream, string2.toCharArray());
            return keyStore;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void b() {
        try {
            KeyStore keyStore;
            if (ec.t() && (keyStore = SignatureSettings.loadOSKeyStore()) != null) {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    Certificate certificate = keyStore.getCertificate(enumeration.nextElement());
                    if (!(certificate instanceof X509Certificate)) continue;
                    c.put(SignatureSettings.getUniqueIdentifier((X509Certificate)certificate), certificate);
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
    }

    public static KeyStore loadOSKeyStore() {
        try {
            if (ec.t()) {
                KeyStore keyStore = KeyStore.getInstance("Windows-ROOT");
                keyStore.load(null, null);
                return keyStore;
            }
            if (ec.e()) {
                KeyStore keyStore = KeyStore.getInstance("KeyChainStore", "Apple");
                keyStore.load(null, null);
                return keyStore;
            }
        }
        catch (CertificateException certificateException) {
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (IOException iOException) {
        }
        catch (NoSuchProviderException noSuchProviderException) {
            // empty catch block
        }
        return null;
    }

    public static String getUniqueIdentifier(X509Certificate x509Certificate) {
        return y.h((Object)(x509Certificate.getSubjectX500Principal() + x509Certificate.getSerialNumber().toString()));
    }
}

