/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf;

import com.qoppa.pdf.b.ec;
import com.qoppa.pdf.b.z;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;

public class SignatureValidity {
    private boolean h = false;
    private boolean r = true;
    private boolean i = true;
    private boolean b = true;
    private boolean j = true;
    private boolean o = true;
    private boolean c = false;
    private boolean e = false;
    private boolean d = false;
    private boolean p = false;
    private boolean l = false;
    private boolean g = false;
    private boolean f = true;
    private boolean m = true;
    private Throwable n;
    private String k;
    public static final Font QUESTION_FONT = new Font("sansserif", 1, 32);
    private static Shape q = null;

    public boolean isValidCertificateChain() {
        return this.o;
    }

    public void setValidCertificateChain(boolean bl) {
        this.o = bl;
    }

    public boolean isValidRevocationList() {
        return this.b;
    }

    public void setValidRevocationList(boolean bl) {
        this.b = bl;
    }

    public boolean isValidSignatureHash() {
        return this.i;
    }

    public void setValidSignatureHash(boolean bl) {
        this.i = bl;
    }

    public boolean isValidTimestamp() {
        return this.d;
    }

    public void setValidTimestamp(boolean bl) {
        this.d = bl;
    }

    public boolean isAllValid() {
        if (this.n != null || !this.h || this.e) {
            return false;
        }
        return this.r && this.o && this.b && this.i && this.j && this.c && this.m && this.f;
    }

    public boolean isValidWithWarning() {
        return this.n == null && this.r && this.i && this.b && this.o && this.f;
    }

    public boolean isNotValid() {
        return this.n != null || !this.r || !this.i || !this.b || !this.o || !this.m;
    }

    public boolean isValidExpiration() {
        return this.j;
    }

    public void setValidExpiration(boolean bl) {
        this.j = bl;
    }

    public boolean isTrustedChain() {
        return this.c;
    }

    public void setTrustedChain(boolean bl) {
        this.c = bl;
    }

    public void drawSmallIcon(Graphics2D graphics2D) {
        graphics2D = (Graphics2D)graphics2D.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        if (this.isAllValid()) {
            graphics2D.setStroke(new BasicStroke(5.0f, 1, 1));
            graphics2D.setColor(Color.green.darker());
            graphics2D.drawLine(2, 13, 8, 18);
            graphics2D.drawLine(8, 18, 22, 4);
        } else if (this.isNotValid()) {
            graphics2D.setStroke(new BasicStroke(5.0f, 1, 1));
            graphics2D.setColor(Color.red.darker());
            graphics2D.drawLine(2, 2, 20, 20);
            graphics2D.drawLine(2, 20, 20, 2);
        } else {
            SignatureValidity.b(graphics2D);
        }
    }

    private static void b(Graphics2D graphics2D) {
        if (q == null) {
            GlyphVector glyphVector = QUESTION_FONT.createGlyphVector(graphics2D.getFontRenderContext(), "?");
            q = glyphVector.getOutline();
        }
        graphics2D.setColor(new Color(156, 198, 239));
        graphics2D.translate(1.0, q.getBounds2D().getHeight() + 2.0);
        graphics2D.fill(q);
        graphics2D.setColor(Color.black);
        graphics2D.draw(q);
    }

    public Icon getLargeIcon() {
        return new _b(1.5 * ec.d());
    }

    public Icon getSmallIcon() {
        return new _b(0.6 * ec.d());
    }

    public String getValidityText() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isAllValid()) {
            stringBuffer.append(String.valueOf(z.b.b("SignatureIsValid")) + ": ");
        } else if (this.isNotValid()) {
            stringBuffer.append(String.valueOf(z.b.b("SignatureIsNotValid")) + ": ");
        } else {
            stringBuffer.append(String.valueOf(z.b.b("SignatureValidityIsUnknown")) + ": ");
        }
        if (!this.h) {
            stringBuffer.append("\n- " + z.b.b("SignatureNotTested"));
            return stringBuffer.toString();
        }
        if (!this.r) {
            stringBuffer.append("\n- " + z.b.b("SignatureObjectIsInvalid"));
        } else if (this.i) {
            if (this.e) {
                stringBuffer.append("\n- " + z.b.b("OriginalContentNotModifiedButContentAdded"));
            } else {
                stringBuffer.append("\n- " + z.b.b("DocumentNotModified"));
            }
        } else {
            stringBuffer.append("\n- " + z.b.b("DocumentModified"));
        }
        List<String> list = this.getValidationMessages();
        int n2 = 0;
        while (n2 < list.size()) {
            stringBuffer.append("\n- " + list.get(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public List<String> getValidationMessages() {
        Vector<String> vector = new Vector<String>();
        if (!this.o) {
            vector.add(z.b.b("InvalidCertificatesInChain"));
        }
        if (!this.b) {
            vector.add(z.b.b("OneOfCertificatesRevoked"));
        }
        if (!this.j) {
            vector.add(z.b.b("CertificateExpiredOrNotValid"));
        }
        if (!this.d) {
            vector.add(z.b.b("SignatureTimestampNotSecure"));
        } else {
            if (this.g) {
                vector.add(z.b.b("SignatureFromTSATrusted"));
            } else {
                vector.add(z.b.b("SignatureFromTSANotTrusted"));
            }
            if (!this.l) {
                vector.add(z.b.b("SignatureTimestampCertInvalid"));
            }
            if (!this.p) {
                vector.add(z.b.b("SignatureTimestampInvalid"));
            }
        }
        if (this.o && !this.c) {
            vector.add(z.b.b("SignersIdentityNotVerifiable"));
        }
        if (!this.m) {
            vector.add(z.b.b("SignatureKeyUsageInvalid"));
        }
        if (!this.f) {
            vector.add(z.b.b("CadesCertificatesMismatch"));
        }
        return vector;
    }

    public boolean isValidSignatureObject() {
        return this.r;
    }

    public void setValidSignatureObject(boolean bl) {
        this.r = bl;
    }

    public String getExceptionMessage() {
        return this.k;
    }

    public Throwable getException() {
        return this.n;
    }

    public void setException(Throwable throwable, String string) {
        this.n = throwable;
        this.k = string;
    }

    public boolean isTested() {
        return this.h;
    }

    public void setTested(boolean bl) {
        this.h = bl;
    }

    public boolean isContentAppended() {
        return this.e;
    }

    public void setContentAppended(boolean bl) {
        this.e = bl;
    }

    public void setTSValid(boolean bl) {
        this.p = bl;
    }

    public boolean isTSValid() {
        return this.p;
    }

    public void setTSValidCertificate(boolean bl) {
        this.l = bl;
    }

    public boolean isTSValidCertificate() {
        return this.l;
    }

    public void setValidKeyUsage(boolean bl) {
        this.m = bl;
    }

    public boolean isValidKeyUsage() {
        return this.m;
    }

    public void setTSTrustedChain(boolean bl) {
        this.g = bl;
    }

    public boolean isTSTrustedChain() {
        return this.g;
    }

    public void setValidPadesCertificate(boolean bl) {
        this.f = bl;
    }

    public boolean isValidPadesCertificate() {
        return this.f;
    }

    private class _b
    implements Icon {
        private double c;

        public _b(double d2) {
            this.c = d2;
        }

        @Override
        public int getIconHeight() {
            return (int)(38.0 * this.c);
        }

        @Override
        public int getIconWidth() {
            return (int)(38.0 * this.c);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.scale(this.c, this.c);
            SignatureValidity.this.drawSmallIcon(graphics2D);
            graphics2D.setTransform(affineTransform);
        }
    }
}

