/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf.javascript;

import com.qoppa.pdf.b.y;
import com.qoppa.pdf.b.z;
import com.qoppa.pdf.javascript.App;
import com.qoppa.pdf.javascript.Doc;
import com.qoppa.pdf.javascript.Event;
import com.qoppa.pdf.javascript.Field;
import com.qoppa.pdf.javascript.QJSUtil;
import com.qoppa.pdf.javascript.Util;
import java.awt.Color;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.NativeRegExp;

public class QJavaScript {
    public static String IDS_GT_AND_LT = z.b.b("JsGreaterThanAndLessThan");
    public static String IDS_LESS_THAN = z.b.b("JsLessThan");
    public static String IDS_GREATER_THAN = z.b.b("JsGreaterThan");
    public static String IDS_PM = z.b.b("JsPm");
    public static String IDS_AM = z.b.b("JsAm");
    public static String IDS_MONTH_INFO = z.b.b("JsMonthInfo");
    public static String IDS_INVALID_VALUE = z.b.b("JsInvalidValue");
    public static String IDS_INVALID_DATE = z.b.b("JsInvalidDate");
    public static String IDS_INVALID_MONTH = z.b.b("JsInvalidMonth");
    public static Pattern AFDigitsRegExp = Pattern.compile("\\d+");
    public static Pattern AFPMRegExp = Pattern.compile(IDS_PM, 2);
    public static Pattern AFAMRegExp = Pattern.compile(IDS_AM, 2);
    public static Pattern AFTimeLongRegExp = Pattern.compile("\\d{1,2}:\\d{1,2}:\\d{1,2}");
    public static Pattern AFTimeShortRegExp = Pattern.compile("\\d{1,2}:\\d{1,2}");
    public static Pattern[] AFMonthsRegExp = QJavaScript.createAFMonthsRegExp();
    public static Pattern[] AFNumberCommaSepCommitRegExp = QJavaScript.createAFNumberCommaSepCommitRegExp();
    public static Pattern[] AFNumberCommaSepEntryRegExp = QJavaScript.createAFNumberCommaSepEntryRegExp();
    public static Pattern[] AFNumberDotSepCommitRegExp = QJavaScript.createAFNumberDotSepCommitRegExp();
    public static Pattern[] AFNumberDotSepEntryRegExp = QJavaScript.createAFNumberDotSepEntryRegExp();
    public static Pattern[] AFZipEntryRegExp = QJavaScript.createAFZipEntryRegExp();
    public static Pattern[] AFZipCommitRegExp = QJavaScript.createAFZipCommitRegExp();
    public static Pattern[] AFZip4EntryRegExp = QJavaScript.createAFZip4EntryRegExp();
    public static Pattern[] AFZip4CommitRegExp = QJavaScript.createAFZip4CommitRegExp();
    public static Pattern[] AFPhoneEntryRegExp = QJavaScript.createAFPhoneEntryRegExp();
    public static Pattern[] AFPhoneCommitRegExp = QJavaScript.createAFPhoneCommitRegExp();
    public static Pattern[] AFSSNEntryRegExp = QJavaScript.createAFSSNEntryRegExp();
    public static Pattern[] AFSSNCommitRegExp = QJavaScript.createAFSSNCommitRegExp();

    public static void AFNumber_Format(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Event event;
        Double d2;
        int n2 = -1;
        if (objectArray.length > 0) {
            n2 = Double.valueOf(objectArray[0].toString()).intValue();
        }
        int n3 = -1;
        if (objectArray.length > 1) {
            n3 = Double.valueOf(objectArray[1].toString()).intValue();
        }
        int n4 = -1;
        if (objectArray.length > 2) {
            n4 = Double.valueOf(objectArray[2].toString()).intValue();
        }
        String string = null;
        if (objectArray.length > 4) {
            string = objectArray[4].toString();
        }
        boolean bl = false;
        if (objectArray.length > 5) {
            bl = new Boolean(objectArray[5].toString());
        }
        if ((d2 = QJavaScript.AFMakeNumber((event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"))).jsGet_value())) == null) {
            event.jsSet_value("");
            return;
        }
        int n5 = d2 < 0.0 ? -1 : 1;
        Field field = (Field)((Object)event.jsGet_target());
        String string2 = "";
        if (n4 == 1 || n4 == 3) {
            if (n5 > 0) {
                field.jsSet_textColor(Color.black);
            } else {
                field.jsSet_textColor(Color.red);
            }
        }
        Object[] objectArray2 = new Object[]{"%," + n3 + "." + n2 + "f", QJSUtil.toString(d2)};
        String string3 = new String(Util.jsFunction_printf(context, scriptable, objectArray2, function));
        if ((n4 != 0 || bl) && string3.charAt(0) == '-') {
            string3 = string3.substring(1);
        }
        if (n5 < 0 && bl && n4 == 0) {
            string2 = "-";
        }
        if ((n4 == 2 || n4 == 3) && n5 < 0) {
            string2 = String.valueOf(string2) + "(";
        }
        if (bl) {
            string2 = String.valueOf(string2) + string;
        }
        string2 = String.valueOf(string2) + string3;
        if (!bl) {
            string2 = String.valueOf(string2) + string;
        }
        if ((n4 == 2 || n4 == 3) && n5 < 0) {
            string2 = String.valueOf(string2) + ")";
        }
        event.jsSet_value(string2);
    }

    public static Object AFExtractNums(String string) {
        Vector<String> vector = new Vector<String>();
        if (string != null && string.length() > 0 && (string.charAt(0) == '.' || string.charAt(0) == ',')) {
            string = "0" + string;
        }
        Matcher matcher = AFDigitsRegExp.matcher(string);
        while (matcher.find()) {
            vector.add(matcher.group());
        }
        if (vector.size() >= 1) {
            String[] stringArray = new String[vector.size()];
            return vector.toArray(stringArray);
        }
        return null;
    }

    public static void AFSpecial_Format(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        Object object = event.jsGet_value();
        String string = "";
        if (object == null) {
            return;
        }
        int n2 = -1;
        if (objectArray.length > 0) {
            n2 = Double.valueOf(objectArray[0].toString()).intValue();
        }
        switch (n2) {
            case 0: {
                string = "99999";
                break;
            }
            case 1: {
                string = "99999-9999";
                break;
            }
            case 2: {
                String string2 = Util.jsFunction_printx("9999999999", object.toString());
                if (string2.length() >= 10) {
                    string = "(999) 999-9999";
                    break;
                }
                string = "999-9999";
                break;
            }
            case 3: {
                string = "999-99-9999";
            }
        }
        event.jsSet_value(Util.jsFunction_printx(string, object.toString()));
    }

    public static void AFPercent_Format(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        if (event.jsGet_value() == null || event.jsGet_value().equals("")) {
            event.jsSet_value("");
            return;
        }
        int n2 = -1;
        if (objectArray.length > 0) {
            n2 = Double.valueOf(objectArray[0].toString()).intValue();
        }
        int n3 = -1;
        if (objectArray.length > 1) {
            n3 = Double.valueOf(objectArray[1].toString()).intValue();
        }
        String string = "" + (double)Float.valueOf(event.jsGet_value().toString()).floatValue() * 100.0;
        String string2 = "%," + n3 + "." + n2 + "f";
        if (string.equals("")) {
            event.jsSet_value(string);
            return;
        }
        Object[] objectArray2 = new Object[]{string2, string};
        string = Util.jsFunction_printf(context, scriptable, objectArray2, function);
        event.jsSet_value(String.valueOf(string) + "%");
    }

    public static Object AFParseTime(String string, Object object) {
        Date date;
        if (object instanceof Date) {
            date = (Date)object;
        } else {
            Context.enter();
            date = (Date)Context.jsToJava((Object)object, Date.class);
        }
        if (string == null) {
            return date;
        }
        String[] stringArray = (String[])QJavaScript.AFExtractNums(string);
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length < 2 || stringArray.length > 3) {
            return null;
        }
        boolean bl = AFPMRegExp.matcher(string).find();
        boolean bl2 = AFAMRegExp.matcher(string).find();
        int n2 = Double.valueOf(stringArray[0]).intValue();
        if (bl) {
            if (n2 < 12) {
                n2 += 12;
            }
        } else if (bl2 && n2 >= 12) {
            n2 -= 12;
        }
        int n3 = Double.valueOf(stringArray[1]).intValue();
        int n4 = stringArray.length == 3 ? Double.valueOf(stringArray[2]).intValue() : 0;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        QJavaScript.setCalendarHours(calendar, n2, n3, n4);
        return calendar.getTime();
    }

    public static String AFStringReplace(String string, String string2, String string3) {
        return string.replaceAll(string2, string3);
    }

    public static void AFTime_Format(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Date date;
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        if (event.jsGet_value() == null) {
            return;
        }
        int n2 = -1;
        if (objectArray.length > 0) {
            n2 = Double.valueOf(objectArray[0].toString()).intValue();
        }
        if ((date = (Date)QJavaScript.AFParseTime((String)event.jsGet_value(), null)) == null) {
            event.jsSet_value("");
            return;
        }
        String[] stringArray = new String[]{"HH:MM", "h:MM tt", "HH:MM:ss", "h:MM:ss tt"};
        Object[] objectArray2 = new Object[]{stringArray[n2], date};
        event.jsSet_value(Util.jsFunction_printd(context, scriptable, objectArray2, function));
    }

    public static void AFTime_FormatEx(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Object object;
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        if (event.jsGet_value() == null) {
            return;
        }
        String string = "";
        if (objectArray.length > 0) {
            string = objectArray[0].toString();
        }
        if ((object = QJavaScript.AFParseTime(event.jsGet_value().toString(), null)) == null) {
            event.jsSet_value("");
            return;
        }
        Object[] objectArray2 = new Object[]{string, object};
        event.jsSet_value(Util.jsFunction_printd(context, scriptable, objectArray2, function));
    }

    public static void AFDate_Format(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        int n2 = -1;
        if (objectArray.length > 0) {
            n2 = Double.valueOf(objectArray[0].toString()).intValue();
        }
        String[] stringArray = new String[]{"m/d", "m/d/yy", "mm/dd/yy", "mm/yy", "d-mmm", "d-mmm-yy", "dd-mmm-yy", "yy-mm-dd", "mmm-yy", "mmmm-yy", "mmm d, yyyy", "mmmm d, yyyy", "m/d/yy h:MM tt", "m/d/yy HH:MM"};
        if (n2 > -1 && n2 < stringArray.length) {
            Object[] objectArray2 = new Object[]{stringArray[n2]};
            QJavaScript.AFDate_FormatEx(context, scriptable, objectArray2, function);
        }
    }

    public static void AFDate_FormatEx(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Date date;
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        if (event.jsGet_value() == null) {
            return;
        }
        String string = "";
        if (objectArray.length > 0) {
            string = objectArray[0].toString();
        }
        if ((date = (Date)QJavaScript.AFParseDateEx(event.jsGet_value().toString(), string)) == null) {
            event.jsSet_value("");
            return;
        }
        Object[] objectArray2 = new Object[]{string, date};
        event.jsSet_value(Util.jsFunction_printd(context, scriptable, objectArray2, function));
    }

    public static Object AFParseDateEx(String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(QJavaScript.convertDateFormat(string2));
        simpleDateFormat.setLenient(false);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private static String convertDateFormat(String string) {
        String string2 = string.replace("M", "b");
        string2 = string2.replace("m", "M");
        string2 = string2.replace("b", "m");
        string2 = string2.replace("t", "a");
        return string2;
    }

    public static Integer AFParseDateYCount(String string) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            switch (string.charAt(n3)) {
                case '\\': {
                    ++n3;
                    break;
                }
                case 'y': {
                    ++n2;
                }
            }
            ++n3;
        }
        return new Integer(n2);
    }

    public static String AFParseDateOrder(String string) {
        String string2 = "";
        int n2 = 0;
        while (n2 < string.length()) {
            switch (string.charAt(n2)) {
                case '\\': {
                    ++n2;
                    break;
                }
                case 'm': {
                    if (string2.indexOf("m") != -1) break;
                    string2 = String.valueOf(string2) + "m";
                    break;
                }
                case 'd': {
                    if (string2.indexOf("d") != -1) break;
                    string2 = String.valueOf(string2) + "d";
                    break;
                }
                case 'y': {
                    if (string2.indexOf(121) != -1) break;
                    string2 = String.valueOf(string2) + 'y';
                }
            }
            ++n2;
        }
        if (string2.indexOf(109) == -1) {
            string2 = String.valueOf(string2) + 'm';
        }
        if (string2.indexOf(100) == -1) {
            string2 = String.valueOf(string2) + 'd';
        }
        if (string2.indexOf("y") == -1) {
            string2 = String.valueOf(string2) + "y";
        }
        return string2;
    }

    public static Object AFParseDateWithPDF(String string, Integer n2) {
        String[] stringArray = new String[]{"m/d", "m/d/yy", "mm/dd/yy", "mm/yy", "d-mmm", "d-mmm-yy", "dd-mmm-yy", "yy-mm-dd", "mmm-yy", "mmmm-yy", "mmm d, yyyy", "mmmm d, yyyy", "m/d/yy h:MM tt", "m/d/yy HH:MM"};
        return QJavaScript.AFParseDateEx(string, stringArray[n2]);
    }

    public static String[] AFExtractRegExp(Object object, String string) {
        Pattern pattern = (Pattern)object;
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            String[] stringArray = new String[]{String.valueOf(string.substring(0, matcher.start())) + string.substring(matcher.end()), matcher.group()};
            return stringArray;
        }
        return null;
    }

    public static Integer AFDateHorizon(Integer n2) {
        Integer n3 = n2;
        if (n2 < 100 && n2 >= 50) {
            n3 = new Integer(n2 + 1900);
        } else if (n2 >= 0 && n2 < 50) {
            n3 = new Integer(n2 + 2000);
        }
        return n3;
    }

    public static Object AFDateFromYMD(Integer n2, Integer n3, Integer n4) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n2);
        calendar.set(2, n3);
        calendar.set(5, n4);
        return calendar.getTime();
    }

    public static Integer AFGetMonthIndex(String string) {
        Pattern pattern = Pattern.compile(String.valueOf(string) + "\\[(\\d++)\\]", 2);
        Matcher matcher = pattern.matcher(IDS_MONTH_INFO);
        if (string != null && !string.equals("") && matcher.find()) {
            String string2 = matcher.group();
            return new Integer(string2.substring(string2.indexOf(91) + 1, string2.length() - 1));
        }
        return new Integer(0);
    }

    public static Integer AFMatchMonth(String string) {
        int n2 = 0;
        while (n2 < AFMonthsRegExp.length) {
            Matcher matcher = AFMonthsRegExp[n2].matcher(string);
            if (matcher.find()) {
                return QJavaScript.AFGetMonthIndex(matcher.group());
            }
            ++n2;
        }
        return new Integer(0);
    }

    public static void AFSimple_Calculate(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        String string = "";
        if (objectArray.length > 0) {
            string = objectArray[0].toString();
        }
        Object object = null;
        if (objectArray.length > 1) {
            object = objectArray[1];
        }
        int n2 = 0;
        Double d2 = QJavaScript.AFSimpleInit(string);
        Object[] objectArray2 = QJavaScript.AFMakeArrayFromList(object);
        int n3 = 0;
        while (n3 < objectArray2.length) {
            Doc doc = (Doc)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"doc"));
            Field field = (Field)((Object)doc.jsFunction_getField(objectArray2[n3].toString()));
            Field[] fieldArray = field.jsFunction_getArray();
            int n4 = 0;
            while (n4 < fieldArray.length) {
                Double d3 = QJavaScript.AFMakeNumber(fieldArray[n4].jsGet_value());
                if (n3 == 0 && n4 == 0 && (string.equals("MIN") || string.equals("MAX"))) {
                    d2 = d3;
                }
                d2 = QJavaScript.AFSimple(string, d2, d3);
                ++n2;
                ++n4;
            }
            ++n3;
        }
        if (string.equals("AVG") && n2 > 0) {
            d2 = new Double(d2 / (double)n2);
        }
        event.jsSet_value(d2);
    }

    public static Double AFSimpleInit(String string) {
        if (string.equals("PRD")) {
            return new Double(1.0);
        }
        return new Double(0.0);
    }

    public static Object[] AFMakeArrayFromList(Object object) {
        if (object instanceof String) {
            Pattern pattern = Pattern.compile(",[ ]?");
            return pattern.split(object.toString());
        }
        if (object instanceof NativeArray) {
            return ((NativeArray)object).toArray();
        }
        return (String[])object;
    }

    public static Double AFMakeNumber(Object object) {
        String[] stringArray;
        if (object != null && !(object instanceof Undefined) && (stringArray = (String[])QJavaScript.AFExtractNums(QJSUtil.toString(object))) != null && stringArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(stringArray[0]);
            if (stringArray.length == 2) {
                stringBuffer.append(".");
                stringBuffer.append(stringArray[1]);
            }
            if (object.toString().indexOf("-.") >= 0) {
                stringBuffer.insert(0, "0.");
            }
            if (object.toString().indexOf("-") >= 0) {
                stringBuffer.insert(0, "-");
            }
            return Double.valueOf(stringBuffer.toString());
        }
        return null;
    }

    public static Double AFSimple(String string, Double d2, Double d3) {
        if (d2 == null) {
            d2 = new Double(0.0);
        }
        if (d3 == null) {
            d3 = new Double(0.0);
        }
        Double d4 = d2;
        if (string.equals("AVG") || string.equals("SUM")) {
            d4 = BigDecimal.valueOf(d2).add(BigDecimal.valueOf(d3)).doubleValue();
        } else if (string.equals("PRD")) {
            d4 = BigDecimal.valueOf(d2).multiply(BigDecimal.valueOf(d3)).doubleValue();
        } else if (string.equals("MIN")) {
            d4 = new Double(Math.min(d2, d3));
        } else if (string.equals("MAX")) {
            d4 = new Double(Math.max(d2, d3));
        }
        return d4;
    }

    public static Object AFMergeChange(Object object) {
        Event event = (Event)((Object)object);
        Object object2 = event.jsGet_value();
        if (event.jsGet_willCommit().booleanValue()) {
            return object2;
        }
        String string = object2 != null && event.jsGet_selStart() != null && event.jsGet_selStart() >= 0 ? object2.toString().substring(0, event.jsGet_selStart()) : "";
        String string2 = object2 != null && event.jsGet_selEnd() != null && event.jsGet_selEnd() >= 0 && event.jsGet_selEnd() <= object2.toString().length() ? object2.toString().substring(event.jsGet_selEnd(), object2.toString().length()) : "";
        return String.valueOf(string) + event.jsGet_change() + string2;
    }

    public static void AFRange_Validate(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws App.JSAlertException {
        Object[] objectArray2;
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        String string = "";
        if (event.jsGet_value().equals("")) {
            return;
        }
        Boolean bl = null;
        if (objectArray.length > 0) {
            bl = Boolean.valueOf(objectArray[0].toString());
        }
        Double d2 = null;
        if (objectArray.length > 1) {
            d2 = Double.valueOf(objectArray[1].toString());
        }
        Boolean bl2 = null;
        if (objectArray.length > 2) {
            bl2 = Boolean.valueOf(objectArray[2].toString());
        }
        Double d3 = null;
        if (objectArray.length > 3) {
            d3 = Double.valueOf(objectArray[3].toString());
        }
        String string2 = event.jsGet_value().toString().replace(',', '.');
        if (bl != null && bl2 != null && bl.booleanValue() && bl2.booleanValue()) {
            if (Double.parseDouble(string2) < d2 || Double.parseDouble(string2) > d3) {
                objectArray2 = new Object[]{IDS_GT_AND_LT, d2, d3};
                string = Util.jsFunction_printf(context, scriptable, objectArray2, function);
            }
        } else if (bl != null && bl.booleanValue()) {
            if (Double.parseDouble(string2) < d2) {
                objectArray2 = new Object[]{IDS_GREATER_THAN, d2};
                string = Util.jsFunction_printf(context, scriptable, objectArray2, function);
            }
        } else if (bl2 != null && bl2.booleanValue() && Double.parseDouble(string2) > d3) {
            objectArray2 = new Object[]{IDS_LESS_THAN, d3};
            string = Util.jsFunction_printf(context, scriptable, objectArray2, function);
        }
        if (string != "") {
            if (!event.jsGet_silenceErrors().booleanValue()) {
                objectArray2 = new Object[]{string, new Integer(1), new Integer(0), z.b.b("Warning")};
                App.jsFunction_alert(context, scriptable, objectArray2, function);
            }
            event.jsSet_rc(Boolean.FALSE);
        }
    }

    public static void AFNumber_Keystroke(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws App.JSAlertException {
        Object object;
        Pattern[] patternArray;
        Pattern[] patternArray2;
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        Object object2 = QJavaScript.AFMergeChange((Object)event);
        if (object2 == null) {
            return;
        }
        int n2 = -1;
        if (objectArray.length > 1) {
            n2 = Double.valueOf(objectArray[1].toString()).intValue();
        }
        if (n2 > 1) {
            patternArray2 = AFNumberCommaSepCommitRegExp;
            patternArray = AFNumberCommaSepEntryRegExp;
        } else {
            patternArray2 = AFNumberDotSepCommitRegExp;
            patternArray = AFNumberDotSepEntryRegExp;
        }
        if (!QJavaScript.AFExactMatch(event.jsGet_willCommit() != false ? patternArray2 : patternArray, object2.toString()).booleanValue()) {
            if (event.jsGet_willCommit().booleanValue() && !event.jsGet_silenceErrors().booleanValue()) {
                object = IDS_INVALID_VALUE;
                if (event.jsGet_target() != null) {
                    object = String.valueOf(object) + " [ " + ((Field)((Object)event.jsGet_target())).jsGet_name() + " ]";
                }
                Object[] objectArray2 = new Object[]{object, new Integer(1), new Integer(0), z.b.b("Warning")};
                App.jsFunction_alert(context, scriptable, objectArray2, function);
            } else {
                object = new Object[]{new Integer(0)};
                App.jsFunction_beep(context, scriptable, object, function);
            }
            event.jsSet_rc(Boolean.FALSE);
        }
        if (event.jsGet_willCommit().booleanValue() && n2 > 1) {
            object = event.jsGet_value().toString();
            object = object.replaceAll(",", ".");
            event.jsSet_value(object);
        }
    }

    public static Boolean AFExactMatch(Object object, String string) {
        if (string == null || string.length() == 0) {
            return Boolean.TRUE;
        }
        Object[] objectArray = object instanceof Pattern || object instanceof NativeRegExp ? new Object[]{object} : (object instanceof NativeArray ? ((NativeArray)object).toArray() : (Object[])object);
        int n2 = 0;
        while (n2 < objectArray.length) {
            Matcher matcher = objectArray[n2] instanceof NativeRegExp ? QJavaScript.getPattern((NativeRegExp)objectArray[n2]).matcher(string) : ((Pattern)objectArray[n2]).matcher(string);
            if (matcher.find() && matcher.group().equals(string)) {
                return Boolean.TRUE;
            }
            ++n2;
        }
        return Boolean.FALSE;
    }

    public static void AFSpecial_Keystroke(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws App.JSAlertException {
        Pattern[] patternArray;
        Pattern[] patternArray2;
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        Object object = QJavaScript.AFMergeChange((Object)event);
        if (object == null) {
            return;
        }
        int n2 = -1;
        if (objectArray.length <= 0) {
            return;
        }
        n2 = Double.valueOf(objectArray[0].toString()).intValue();
        switch (n2) {
            case 0: {
                patternArray2 = AFZipCommitRegExp;
                patternArray = AFZipEntryRegExp;
                break;
            }
            case 1: {
                patternArray2 = AFZip4CommitRegExp;
                patternArray = AFZip4EntryRegExp;
                break;
            }
            case 2: {
                patternArray2 = AFPhoneCommitRegExp;
                patternArray = AFPhoneEntryRegExp;
                break;
            }
            case 3: {
                patternArray2 = AFSSNCommitRegExp;
                patternArray = AFSSNEntryRegExp;
                break;
            }
            default: {
                return;
            }
        }
        if (!QJavaScript.AFExactMatch(event.jsGet_willCommit() != false ? patternArray2 : patternArray, object.toString()).booleanValue()) {
            if (event.jsGet_willCommit().booleanValue() && !event.jsGet_silenceErrors().booleanValue()) {
                Object[] objectArray2 = new Object[]{String.valueOf(IDS_INVALID_VALUE) + " [ " + ((Field)((Object)event.jsGet_target())).jsGet_name() + " ]", new Integer(1), new Integer(0), z.b.b("Warning")};
                App.jsFunction_alert(context, scriptable, objectArray2, function);
            } else {
                Object[] objectArray3 = new Object[]{new Integer(0)};
                App.jsFunction_beep(context, scriptable, objectArray3, function);
            }
            event.jsSet_rc(Boolean.FALSE);
        }
    }

    public static void AFSpecial_KeystrokeEx(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws App.JSAlertException {
        Object object;
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        String string = "";
        if (objectArray.length > 0) {
            string = objectArray[0].toString();
        }
        if (y.f(object = QJavaScript.AFMergeChange((Object)event)) || string.length() == 0) {
            return;
        }
        String string2 = String.valueOf(IDS_INVALID_VALUE) + " = \"" + string + "\"";
        if (event.jsGet_willCommit().booleanValue()) {
            if (QJavaScript.indexOfNextEssential(string, object.toString().length()) != -1) {
                if (!event.jsGet_silenceErrors().booleanValue()) {
                    Object[] objectArray2 = new Object[]{string2, new Integer(1), new Integer(0), z.b.b("Warning")};
                    App.jsFunction_alert(context, scriptable, objectArray2, function);
                }
                event.jsSet_rc(Boolean.FALSE);
                return;
            }
            event.jsSet_value(event.jsGet_value() + string.substring(object.toString().length(), string.length()));
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = event.jsGet_selStart();
        while (n3 < object.toString().length()) {
            char c2 = object.toString().charAt(n3);
            boolean bl = false;
            if (string.length() > n2) {
                bl = QJavaScript.maskSatisfied(c2, string.charAt(n2));
            }
            if (!bl) {
                Object[] objectArray3;
                int n6 = QJavaScript.indexOfNextEssential(string, n2);
                int n7 = event.jsGet_selStart() + event.jsGet_change().length() + n4;
                if (n2 < string.length() && !QJavaScript.isReservedMaskChar(string.charAt(n2)) && n6 != -1 && QJavaScript.maskSatisfied(c2, string.charAt(n6)) && n3 + n4 >= n5 && n3 + n4 <= n7) {
                    objectArray3 = string.substring(n2, n6);
                    event.jsSet_change(String.valueOf(event.jsGet_change().substring(0, n3 + n4 - n5)) + (String)objectArray3 + event.jsGet_change().substring(n3 + n4 - n5));
                    n4 += objectArray3.length();
                    n2 = n6;
                } else {
                    if (!event.jsGet_silenceErrors().booleanValue()) {
                        objectArray3 = new Object[]{string2, new Integer(1), new Integer(0), z.b.b("Warning")};
                        App.jsFunction_alert(context, scriptable, objectArray3, function);
                    }
                    event.jsSet_rc(Boolean.FALSE);
                    return;
                }
            }
            ++n3;
            ++n2;
        }
    }

    public static Object[] AFBuildRegExps(Object object) {
        Object[] objectArray;
        if (object != null && object instanceof String[]) {
            objectArray = (String[])object;
        } else if (object instanceof NativeArray) {
            objectArray = new String[((NativeArray)object).size()];
            ((NativeArray)object).toArray(objectArray);
        } else {
            return new String[0];
        }
        Object[] objectArray2 = new Pattern[objectArray.length];
        int n2 = 0;
        while (n2 < objectArray.length) {
            Pattern.compile((String)objectArray[n2], 2);
            ++n2;
        }
        return objectArray2;
    }

    public static Object AFExtractTime(String string) {
        String string2 = "";
        Object[] objectArray = QJavaScript.AFExtractRegExp(AFPMRegExp, string);
        if (objectArray != null) {
            string2 = objectArray[1];
            string = objectArray[0];
        }
        if ((objectArray = QJavaScript.AFExtractRegExp(AFAMRegExp, string)) != null) {
            string = objectArray[0];
        }
        if ((objectArray = QJavaScript.AFExtractRegExp(AFTimeLongRegExp, string)) != null) {
            objectArray[1] = String.valueOf(objectArray[1]) + string2;
            return new NativeArray(objectArray);
        }
        objectArray = QJavaScript.AFExtractRegExp(AFTimeShortRegExp, string);
        if (objectArray != null) {
            objectArray[1] = String.valueOf(objectArray[1]) + string2;
            return new NativeArray(objectArray);
        }
        return null;
    }

    public static String AFGetMonthString(Integer n2) {
        Pattern pattern = Pattern.compile("\\p{L}+\\[" + n2 + "\\]");
        Matcher matcher = pattern.matcher(IDS_MONTH_INFO);
        if (matcher.find()) {
            String string = matcher.group();
            return string.substring(0, string.indexOf(91));
        }
        return IDS_INVALID_MONTH;
    }

    public static void AFPercent_Keystroke(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws App.JSAlertException {
        Object object = null;
        if (objectArray.length > 0) {
            object = objectArray[0];
        }
        Object object2 = null;
        if (objectArray.length > 1) {
            object2 = objectArray[1];
        }
        Object[] objectArray2 = new Object[]{object, object2, new Integer(0), new Integer(0), "", Boolean.TRUE};
        QJavaScript.AFNumber_Keystroke(context, scriptable, objectArray2, function);
    }

    public static void AFDate_Keystroke(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws App.JSAlertException {
        int n2 = -1;
        if (objectArray.length > 0) {
            n2 = Double.valueOf(objectArray[0].toString()).intValue();
        }
        String[] stringArray = new String[]{"m/d", "m/d/yy", "mm/dd/yy", "mm/yy", "d-mmm", "d-mmm-yy", "dd-mmm-yy", "yy-mm-dd", "mmm-yy", "mmmm-yy", "mmm d, yyyy", "mmmm d, yyyy", "m/d/yy h:MM tt", "m/d/yy HH:MM"};
        Object[] objectArray2 = new Object[]{stringArray[n2]};
        QJavaScript.AFDate_KeystrokeEx(context, scriptable, objectArray2, function);
    }

    public static void AFDate_KeystrokeEx(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws App.JSAlertException {
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        if (event.jsGet_value().equals("")) {
            return;
        }
        String string = "";
        if (objectArray.length > 0) {
            string = objectArray[0].toString();
        }
        if (event.jsGet_willCommit().booleanValue() && QJavaScript.AFParseDateEx(QJavaScript.AFMergeChange((Object)event).toString(), string) == null) {
            if (event.jsGet_willCommit().booleanValue() && !event.jsGet_silenceErrors().booleanValue()) {
                String string2 = "";
                if ((Field)((Object)event.jsGet_target()) != null) {
                    string2 = ((Field)((Object)event.jsGet_target())).jsGet_name();
                }
                Object[] objectArray2 = new Object[]{IDS_INVALID_DATE, string2, string};
                String string3 = Util.jsFunction_printf(context, scriptable, objectArray2, function);
                Object[] objectArray3 = new Object[]{string3, new Integer(1), new Integer(0), z.b.b("Warning")};
                App.jsFunction_alert(context, scriptable, objectArray3, function);
            } else {
                Object[] objectArray4 = new Object[]{new Integer(0)};
                App.jsFunction_beep(context, scriptable, objectArray4, function);
            }
            event.jsSet_rc(Boolean.FALSE);
        }
    }

    public static void AFTime_Keystroke(Context context, Scriptable scriptable, Object[] objectArray, Function function) throws App.JSAlertException {
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        if (event.jsGet_value().equals("")) {
            return;
        }
        if (event.jsGet_willCommit().booleanValue() && QJavaScript.AFParseTime(event.jsGet_value().toString(), null) == null) {
            if (event.jsGet_willCommit().booleanValue() && !event.jsGet_silenceErrors().booleanValue()) {
                String string = IDS_INVALID_VALUE;
                if (event.jsGet_target() != null) {
                    string = String.valueOf(string) + " [ " + ((Field)((Object)event.jsGet_target())).jsGet_name() + " ]";
                }
                Object[] objectArray2 = new Object[]{string, new Integer(1), new Integer(0), z.b.b("Warning")};
                App.jsFunction_alert(context, scriptable, objectArray2, function);
            } else {
                Object[] objectArray3 = new Object[]{new Integer(0)};
                App.jsFunction_beep(context, scriptable, objectArray3, function);
            }
            event.jsSet_rc(Boolean.FALSE);
        }
    }

    public static void AFSignatureLock(Doc doc, String string, Object object, Boolean bl) {
        Field field;
        int n2;
        Object[] objectArray = QJavaScript.AFMakeArrayFromList(object);
        if (!string.equals("THESE")) {
            n2 = 0;
            while (n2 < doc.jsGet_numFields()) {
                field = (Field)((Object)doc.jsFunction_getField(doc.jsFunction_getNthFieldName(new Integer(n2))));
                field.jsSet_readonly(bl);
                ++n2;
            }
        }
        if (string.equals("EXCEPT")) {
            bl = bl == false;
        }
        if (string.equals("THESE") || string.equals("EXCEPT") && !bl.booleanValue()) {
            n2 = 0;
            while (n2 < objectArray.length) {
                field = (Field)((Object)doc.jsFunction_getField(objectArray[n2].toString()));
                Field[] fieldArray = field.jsFunction_getArray();
                int n3 = 0;
                while (n3 < fieldArray.length) {
                    fieldArray[n3].jsSet_readonly(bl);
                    ++n3;
                }
                ++n2;
            }
        }
    }

    public static void AFSignature_Format(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        Event event = (Event)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"event"));
        String string = "";
        if (objectArray.length > 0) {
            string = objectArray[0].toString();
        }
        Object object = null;
        if (objectArray.length > 1) {
            object = objectArray[1];
        }
        Boolean bl = !event.jsGet_value().toString().equals("");
        Doc doc = (Doc)((Object)ScriptableObject.getProperty((Scriptable)scriptable, (String)"doc"));
        QJavaScript.AFSignatureLock(doc, string, object, bl);
    }

    private static void setCalendarHours(Calendar calendar, int n2, int n3, int n4) {
        calendar.set(11, n2);
        calendar.set(12, n3);
        calendar.set(13, n4);
    }

    private static Pattern[] createAFMonthsRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("January", 2), Pattern.compile("February", 2), Pattern.compile("March", 2), Pattern.compile("April", 2), Pattern.compile("May", 2), Pattern.compile("June", 2), Pattern.compile("July", 2), Pattern.compile("August", 2), Pattern.compile("September", 2), Pattern.compile("October", 2), Pattern.compile("November", 2), Pattern.compile("December", 2), Pattern.compile("Sept", 2), Pattern.compile("Jan", 2), Pattern.compile("Feb", 2), Pattern.compile("Mar", 2), Pattern.compile("Apr", 2), Pattern.compile("Jun", 2), Pattern.compile("Jul", 2), Pattern.compile("Aug", 2), Pattern.compile("Sep", 2), Pattern.compile("Oct", 2), Pattern.compile("Nov", 2), Pattern.compile("Dec", 2), Pattern.compile("(?:)", 2)};
        return patternArray;
    }

    private static Pattern[] createAFNumberCommaSepCommitRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("[+-]?\\d+([.,]\\d+)?"), Pattern.compile("[+-]?[.,]\\d+"), Pattern.compile("[+-]?\\d+[.,]")};
        return patternArray;
    }

    private static Pattern[] createAFNumberDotSepCommitRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("[+-]?\\d+(\\.\\d+)?"), Pattern.compile("[+-]?\\.\\d+"), Pattern.compile("[+-]?\\d+\\.")};
        return patternArray;
    }

    private static Pattern[] createAFNumberCommaSepEntryRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("[+-]?\\d*,?\\d*")};
        return patternArray;
    }

    private static Pattern[] createAFNumberDotSepEntryRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("[+-]?\\d*\\.?\\d*")};
        return patternArray;
    }

    private static Pattern[] createAFZipEntryRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("\\d{0,5}")};
        return patternArray;
    }

    private static Pattern[] createAFZipCommitRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("\\d{5}")};
        return patternArray;
    }

    private static Pattern[] createAFZip4EntryRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("\\d{0,5}(\\.|[- ])?\\d{0,4}")};
        return patternArray;
    }

    private static Pattern[] createAFZip4CommitRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("\\d{5}(\\.|[- ])?\\d{4}")};
        return patternArray;
    }

    private static Pattern[] createAFPhoneEntryRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("\\d{0,3}(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}"), Pattern.compile("\\(\\d{0,3}"), Pattern.compile("\\(\\d{0,3}\\)(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}"), Pattern.compile("\\(\\d{0,3}(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}"), Pattern.compile("\\d{0,3}\\)(\\.|[- ])?\\d{0,3}(\\.|[- ])?\\d{0,4}"), Pattern.compile("011(\\.|[- \\d])*")};
        return patternArray;
    }

    private static Pattern[] createAFPhoneCommitRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("\\d{3}(\\.|[- ])?\\d{4}"), Pattern.compile("\\d{3}(\\.|[- ])?\\d{3}(\\.|[- ])?\\d{4}"), Pattern.compile("\\(\\d{3}\\)(\\.|[- ])?\\d{3}(\\.|[- ])?\\d{4}"), Pattern.compile("011(\\.|[- \\d])*")};
        return patternArray;
    }

    private static Pattern[] createAFSSNEntryRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("\\d{0,3}(\\.|[- ])?\\d{0,2}(\\.|[- ])?\\d{0,4}")};
        return patternArray;
    }

    private static Pattern[] createAFSSNCommitRegExp() {
        Pattern[] patternArray = new Pattern[]{Pattern.compile("\\d{3}(\\.|[- ])?\\d{2}(\\.|[- ])?\\d{4}")};
        return patternArray;
    }

    private static Pattern getPattern(NativeRegExp nativeRegExp) {
        String[] stringArray = nativeRegExp.toString().split("/");
        String string = stringArray[1];
        int n2 = 0;
        if (stringArray.length > 2) {
            if (stringArray[2].indexOf("i") >= 0) {
                n2 += 2;
            }
            if (stringArray[2].indexOf("m") >= 0) {
                n2 += 8;
            }
        }
        return Pattern.compile(string, n2);
    }

    private static boolean maskSatisfied(char c2, char c3) {
        switch (c3) {
            case '9': {
                return QJavaScript.isNumber(c2);
            }
            case 'A': {
                return QJavaScript.isAlphabetic(c2);
            }
            case 'O': {
                return QJavaScript.isAlphaNumeric(c2);
            }
            case 'X': {
                return true;
            }
        }
        return c2 == c3;
    }

    private static boolean isNumber(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static boolean isAlphabetic(char c2) {
        return c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z';
    }

    private static boolean isAlphaNumeric(char c2) {
        return QJavaScript.isNumber(c2) || QJavaScript.isAlphabetic(c2);
    }

    private static int indexOfNextEssential(String string, int n2) {
        int n3 = n2;
        while (n3 < string.length()) {
            if (QJavaScript.isReservedMaskChar(string.charAt(n3))) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static boolean isReservedMaskChar(char c2) {
        return c2 == '9' || c2 == 'X' || c2 == 'A' || c2 == 'O';
    }

    private static boolean validDate(String string, String string2, String string3) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d/M/y");
        simpleDateFormat.setLenient(false);
        try {
            simpleDateFormat.parse(String.valueOf(string) + "/" + string2 + "/" + string3);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }
}

