/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf.permissions;

import com.qoppa.pdf.permissions.DocMDPPermissions;
import com.qoppa.pdf.permissions.IPDFPermissions;
import com.qoppa.pdf.permissions.PasswordPermissions;
import com.qoppa.pdf.permissions.Restrictions;
import com.qoppa.pdf.permissions.SignaturePermissions;
import com.qoppa.pdf.permissions.UsageRightsPermissions;

public class AllPDFPermissions {
    private PasswordPermissions c;
    private DocMDPPermissions b;
    private UsageRightsPermissions e;
    private SignaturePermissions d;

    public AllPDFPermissions(PasswordPermissions passwordPermissions, DocMDPPermissions docMDPPermissions, UsageRightsPermissions usageRightsPermissions, SignaturePermissions signaturePermissions) {
        this.c = passwordPermissions;
        this.b = docMDPPermissions;
        this.e = usageRightsPermissions;
        this.d = signaturePermissions;
    }

    public boolean isAssembleDocumentAllowed(boolean bl) {
        return !this.getAssembleDocumentRestrictions(bl).isRestricted();
    }

    public boolean isChangeDocumentAllowed(boolean bl) {
        return !this.getChangeDocumentRestrictions(bl).isRestricted();
    }

    public boolean isCreateModifyFieldsAllowed(boolean bl) {
        return this.isChangeDocumentAllowed(bl) && this.isModifyAnnotsAllowed(bl);
    }

    public boolean isExtractTextGraphicsAllowed(boolean bl) {
        return !this.getExtractTextGraphicsRestrictions(bl).isRestricted();
    }

    public boolean isExtractTextGraphicsForAccessibilityAllowed(boolean bl) {
        return !this.getExtractTextGraphicsForAccessibilityRestrictions(bl).isRestricted();
    }

    public boolean isFillFormFieldsAllowed(boolean bl) {
        return !this.getFillFormFieldsRestrictions(bl).isRestricted();
    }

    public boolean isModifyAnnotsAllowed(boolean bl) {
        return !this.getModifyAnnotsRestrictions(bl).isRestricted();
    }

    public boolean isPrintAllowed(boolean bl) {
        return !this.getPrintRestrictions(bl).isRestricted();
    }

    public boolean isPrintHighResAllowed(boolean bl) {
        return !this.getPrintHighResRestrictions(bl).isRestricted();
    }

    public Restrictions getAssembleDocumentRestrictions(boolean bl) {
        boolean bl2 = this.d(this.c) || bl && this.c.ownerPasswordEntered();
        return new Restrictions(!bl2, !this.d(this.b), !this.d(this.e), !this.d(this.d));
    }

    public Restrictions getChangeDocumentRestrictions(boolean bl) {
        boolean bl2 = this.i(this.c) || bl && this.c.ownerPasswordEntered();
        return new Restrictions(!bl2, !this.i(this.b), !this.i(this.e), !this.i(this.d));
    }

    public Restrictions getExtractTextGraphicsRestrictions(boolean bl) {
        boolean bl2 = this.g(this.c) || bl && this.c.ownerPasswordEntered();
        return new Restrictions(!bl2, !this.g(this.b), !this.g(this.e), !this.g(this.d));
    }

    public Restrictions getExtractTextGraphicsForAccessibilityRestrictions(boolean bl) {
        boolean bl2 = this.f(this.c) || bl && this.c.ownerPasswordEntered();
        return new Restrictions(!bl2, !this.f(this.b), !this.f(this.e), !this.f(this.d));
    }

    public Restrictions getFillFormFieldsRestrictions(boolean bl) {
        boolean bl2 = this.c(this.c) || bl && this.c.ownerPasswordEntered();
        return new Restrictions(!bl2, !this.c(this.b), !this.c(this.e), !this.c(this.d));
    }

    public Restrictions getModifyAnnotsRestrictions(boolean bl) {
        boolean bl2 = this.b(this.c) || bl && this.c.ownerPasswordEntered();
        return new Restrictions(!bl2, !this.b(this.b), !this.b(this.e), !this.b(this.d));
    }

    public Restrictions getPrintRestrictions(boolean bl) {
        boolean bl2 = this.e(this.c) || bl && this.c.ownerPasswordEntered();
        return new Restrictions(!bl2, !this.e(this.b), !this.e(this.e), !this.e(this.d));
    }

    public Restrictions getPrintHighResRestrictions(boolean bl) {
        boolean bl2 = this.h(this.c) || bl && this.c.ownerPasswordEntered();
        return new Restrictions(!bl2, !this.h(this.b), !this.h(this.e), !this.h(this.d));
    }

    private boolean d(IPDFPermissions iPDFPermissions) {
        return iPDFPermissions == null || iPDFPermissions.isAssembleDocumentAllowed();
    }

    private boolean i(IPDFPermissions iPDFPermissions) {
        return iPDFPermissions == null || iPDFPermissions.isChangeDocumentAllowed();
    }

    private boolean g(IPDFPermissions iPDFPermissions) {
        return iPDFPermissions == null || iPDFPermissions.isExtractTextGraphicsAllowed();
    }

    private boolean f(IPDFPermissions iPDFPermissions) {
        return iPDFPermissions == null || iPDFPermissions.isExtractTextGraphicsForAccessibilityAllowed();
    }

    private boolean c(IPDFPermissions iPDFPermissions) {
        return iPDFPermissions == null || iPDFPermissions.isFillFormFieldsAllowed();
    }

    private boolean b(IPDFPermissions iPDFPermissions) {
        return iPDFPermissions == null || iPDFPermissions.isModifyAnnotsAllowed();
    }

    private boolean e(IPDFPermissions iPDFPermissions) {
        return iPDFPermissions == null || iPDFPermissions.isPrintAllowed();
    }

    private boolean h(IPDFPermissions iPDFPermissions) {
        return iPDFPermissions == null || iPDFPermissions.isPrintHighResAllowed();
    }

    public PasswordPermissions getPasswordPermissions() {
        return this.c;
    }

    public DocMDPPermissions getDocMDPPermissions() {
        return this.b;
    }

    public UsageRightsPermissions getUsageRightsPermissions() {
        return this.e;
    }

    public SignaturePermissions getSignaturePermissions() {
        return this.d;
    }
}

