/*
 * Decompiled with CFR 0.152.
 */
package com.qoppa.pdf.source;

import com.qoppa.pdf.PDFException;
import com.qoppa.pdf.d.i;
import com.qoppa.pdf.source.PDFContent;
import com.qoppa.pdf.source.PDFSource;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public class MBBPDFSource
implements PDFSource {
    private File p;
    private PDFContent q;

    public MBBPDFSource(File file) throws PDFException {
        if (file == null) {
            throw new PDFException("File is null.");
        }
        this.p = file;
        if (!this.p.exists()) {
            throw new PDFException("File does not exist: " + file.getName());
        }
    }

    public MBBPDFSource(String string) throws PDFException {
        if (string == null) {
            throw new PDFException("File name is null.");
        }
        this.p = new File(string);
        if (!this.p.exists()) {
            throw new PDFException("File does not exist: " + string);
        }
    }

    @Override
    public String getName() {
        return this.p.getName();
    }

    @Override
    public String getPath() {
        try {
            return this.p.getCanonicalPath();
        }
        catch (IOException iOException) {
            return this.p.getAbsolutePath();
        }
    }

    @Override
    public boolean equals(PDFSource pDFSource) {
        if (pDFSource instanceof MBBPDFSource) {
            return ((MBBPDFSource)pDFSource).p.equals(this.p);
        }
        return false;
    }

    public File getFile() {
        return this.p;
    }

    @Override
    public PDFContent getContent() throws IOException {
        if (this.q == null) {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.p, "r");
            this.q = new i(randomAccessFile.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, randomAccessFile.length()));
            randomAccessFile.close();
        }
        return this.q;
    }
}

