/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.light.impl;

import com.pi4j.component.light.DimmableLightBase;
import com.pi4j.component.light.LightLevelChangeEvent;
import com.pi4j.component.light.LightStateChangeEvent;
import com.pi4j.io.gpio.GpioPinPwmOutput;

public class GpioDimmableLightComponent
extends DimmableLightBase {
    GpioPinPwmOutput pin = null;
    int min = 0;
    int max = 0;

    public GpioDimmableLightComponent(GpioPinPwmOutput pin, int min, int max) {
        this.pin = pin;
        this.min = min;
        this.max = max;
    }

    @Override
    public int getMinLevel() {
        return this.min;
    }

    @Override
    public int getMaxLevel() {
        return this.max;
    }

    @Override
    public int getLevel() {
        return this.pin.getPwm();
    }

    @Override
    public void setLevel(int level) {
        boolean isOnBeforeChange = this.isOn();
        this.pin.setPwm(level);
        boolean isOnAfterChange = this.isOn();
        this.notifyListeners(new LightLevelChangeEvent(this, level));
        if (isOnBeforeChange != isOnAfterChange) {
            this.notifyListeners(new LightStateChangeEvent(this, isOnAfterChange));
        }
    }
}

