/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.servo.impl;

import com.pi4j.component.servo.ServoDriver;
import com.pi4j.component.servo.impl.MaestroServoProvider;
import com.pi4j.io.gpio.Pin;

public class MaestroServoDriver
implements ServoDriver {
    public static final int MIN_PULSE_WIDTH = 800;
    public static final int MAX_PULSE_WIDTH = 2200;
    protected Pin servoPin;
    protected MaestroServoProvider provider;

    public MaestroServoDriver(MaestroServoProvider provider, Pin servoPin) {
        this.provider = provider;
        this.servoPin = servoPin;
    }

    @Override
    public int getServoPulseWidth() {
        return this.provider.getServoPosition(this.servoPin.getAddress());
    }

    @Override
    public void setServoPulseWidth(int width) {
        this.provider.setServoPosition(this.servoPin.getAddress(), width);
    }

    @Override
    public int getServoPulseResolution() {
        return 100;
    }

    public void setSpeed(int value) {
        this.provider.setSpeed(this.servoPin.getAddress(), value);
    }

    public void setAcceleration(int value) {
        this.provider.setAcceleration(this.servoPin.getAddress(), value);
    }

    public boolean isMoving() {
        return this.provider.isMoving();
    }

    public int getMinValue() {
        return 3200;
    }

    public int getMaxValue() {
        return 8800;
    }

    @Override
    public Pin getPin() {
        return this.servoPin;
    }
}

