/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.servo.impl;

import com.pi4j.component.servo.ServoDriver;
import com.pi4j.component.servo.ServoProvider;
import com.pi4j.component.servo.impl.RPIServoBlasterServoDriver;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.RaspiPin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RPIServoBlasterProvider
implements ServoProvider {
    public static final String PIN_P1_3 = "P1-3";
    public static final String PIN_P1_5 = "P1-5";
    public static final String PIN_P1_7 = "P1-7";
    public static final String PIN_P1_11 = "P1-11";
    public static final String PIN_P1_12 = "P1-12";
    public static final String PIN_P1_13 = "P1-13";
    public static final String PIN_P1_15 = "P1-15";
    public static final String PIN_P1_16 = "P1-16";
    public static final String PIN_P1_18 = "P1-18";
    public static final String PIN_P1_19 = "P1-19";
    public static final String PIN_P1_21 = "P1-21";
    public static final String PIN_P1_22 = "P1-22";
    public static final String PIN_P1_23 = "P1-23";
    public static final String PIN_P1_24 = "P1-24";
    public static final String PIN_P1_25 = "P1-25";
    public static final String PIN_P1_26 = "P1-26";
    public static final String PIN_P1_27 = "P1-27";
    public static final String PIN_P1_28 = "P1-28";
    public static final String PIN_P1_29 = "P1-29";
    public static final String PIN_P1_31 = "P1-31";
    public static final String PIN_P1_32 = "P1-32";
    public static final String PIN_P1_33 = "P1-33";
    public static final String PIN_P1_35 = "P1-35";
    public static final String PIN_P1_36 = "P1-36";
    public static final String PIN_P1_37 = "P1-37";
    public static final String PIN_P1_38 = "P1-38";
    public static final String PIN_P1_40 = "P1-40";
    public static final String PIN_P5_3 = "P5-3";
    public static final String PIN_P5_4 = "P5-4";
    public static final String PIN_P5_5 = "P5-5";
    public static final String PIN_P5_6 = "P5-6";
    public static Map<Pin, String> PIN_MAP = new HashMap<Pin, String>();
    public static Map<String, Pin> REVERSE_PIN_MAP = new HashMap<String, Pin>();
    public static final String SERVO_BLASTER_DEV = "/dev/servoblaster";
    public static final String SERVO_BLASTER_DEV_CFG = "/dev/servoblaster-cfg";
    protected File servoBlasterDev;
    protected File servoBlasterDevCfg;
    protected Writer writer;
    protected Map<Pin, RPIServoBlasterServoDriver> allocatedDrivers = new HashMap<Pin, RPIServoBlasterServoDriver>();

    static void definePin(Pin pin, String s) {
        PIN_MAP.put(pin, s);
        REVERSE_PIN_MAP.put(s, pin);
    }

    public RPIServoBlasterProvider() throws IOException {
        this.servoBlasterDev = new File(SERVO_BLASTER_DEV);
        if (!this.servoBlasterDev.exists()) {
            throw new FileNotFoundException("File /dev/servoblaster is not present. Please check https://github.com/richardghirst/PiBits/tree/master/ServoBlaster for details.");
        }
        this.servoBlasterDevCfg = new File(SERVO_BLASTER_DEV_CFG);
        if (!this.servoBlasterDevCfg.exists()) {
            throw new FileNotFoundException("File /dev/servoblaster-cfg is not present. Please check https://github.com/richardghirst/PiBits/tree/master/ServoBlaster for details.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Pin> getDefinedServoPins() throws IOException {
        ArrayList<Pin> servoPins = new ArrayList<Pin>();
        FileReader in = new FileReader(this.servoBlasterDevCfg);
        try {
            String p1pins = null;
            String p5pins = null;
            boolean mappingStarted = false;
            BufferedReader reader = new BufferedReader(in);
            String line = reader.readLine();
            while (line != null) {
                block22: {
                    if (mappingStarted) {
                        int i = (line = line.trim()).indexOf(" on ");
                        if (i > 0) {
                            try {
                                int index = Integer.parseInt(line.substring(0, i));
                                String pin = line.substring(i + 4).trim();
                                i = pin.indexOf(32);
                                pin = pin.substring(0, i);
                                Pin gpio = REVERSE_PIN_MAP.get(pin);
                                if (gpio != null) {
                                    if (index == servoPins.size()) {
                                        servoPins.add(gpio);
                                    } else if (index > servoPins.size()) {
                                        while (servoPins.size() < index) {
                                            servoPins.add(null);
                                        }
                                        servoPins.add(gpio);
                                    } else {
                                        servoPins.set(index, gpio);
                                    }
                                    break block22;
                                }
                                System.err.println("Unrecognised pin " + pin);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else {
                        if (line.startsWith("p1pins=")) {
                            p1pins = line.substring(7);
                        }
                        if (line.startsWith("p5pins=")) {
                            p5pins = line.substring(7);
                        }
                        if (line.trim().equals("Servo mapping:")) {
                            mappingStarted = true;
                        }
                    }
                }
                line = reader.readLine();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return servoPins;
    }

    @Override
    public synchronized ServoDriver getServoDriver(Pin servoPin) throws IOException {
        List<Pin> servoPins = this.getDefinedServoPins();
        int index = servoPins.indexOf(servoPin);
        if (index < 0) {
            throw new IllegalArgumentException("Servo driver cannot drive pin " + servoPin);
        }
        RPIServoBlasterServoDriver driver = this.allocatedDrivers.get(servoPin);
        if (driver == null) {
            driver = new RPIServoBlasterServoDriver(servoPin, index, PIN_MAP.get(servoPin), this);
            this.ensureWriterIsCreated();
        }
        return driver;
    }

    protected synchronized void ensureWriterIsCreated() throws IOException {
        if (this.writer == null) {
            this.writer = new FileWriter(this.servoBlasterDev);
        }
    }

    protected synchronized void updateServo(String pinName, int value) {
        StringBuilder b = new StringBuilder();
        b.append(pinName).append('=').append(Integer.toString(value)).append('\n');
        try {
            this.writer.write(b.toString());
            this.writer.flush();
        }
        catch (IOException e) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            this.ensureWriterIsCreated();
            this.writer.write(b.toString());
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to /dev/servoblaster device", e);
        }
    }

    static {
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_08, PIN_P1_3);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_09, PIN_P1_5);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_07, PIN_P1_7);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_00, PIN_P1_11);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_01, PIN_P1_12);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_02, PIN_P1_13);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_03, PIN_P1_15);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_04, PIN_P1_16);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_05, PIN_P1_18);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_12, PIN_P1_19);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_13, PIN_P1_21);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_06, PIN_P1_22);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_14, PIN_P1_23);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_10, PIN_P1_24);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_11, PIN_P1_26);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_17, PIN_P5_3);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_18, PIN_P5_4);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_19, PIN_P5_5);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_20, PIN_P5_6);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_30, PIN_P1_27);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_31, PIN_P1_28);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_21, PIN_P1_29);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_22, PIN_P1_31);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_26, PIN_P1_32);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_23, PIN_P1_33);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_24, PIN_P1_35);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_27, PIN_P1_36);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_25, PIN_P1_37);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_28, PIN_P1_38);
        RPIServoBlasterProvider.definePin(RaspiPin.GPIO_29, PIN_P1_40);
    }
}

