/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.device;

import com.pi4j.device.DeviceBase;
import com.pi4j.device.DeviceListener;
import com.pi4j.device.ObserveableDevice;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ObserveableDeviceBase
extends DeviceBase
implements ObserveableDevice {
    protected final List<DeviceListener> listeners = new ArrayList<DeviceListener>();

    protected synchronized void addListener(DeviceListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        Collections.addAll(this.listeners, listener);
    }

    protected synchronized void removeListener(DeviceListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        for (DeviceListener lsnr : listener) {
            this.listeners.remove(lsnr);
        }
    }

    @Override
    public synchronized void removeAllListeners() {
        ArrayList<DeviceListener> listeners_copy = new ArrayList<DeviceListener>(this.listeners);
        for (int index = listeners_copy.size() - 1; index >= 0; --index) {
            DeviceListener listener = (DeviceListener)listeners_copy.get(index);
            this.removeListener(listener);
        }
    }
}

