/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa;

import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.GaugeBuilder;
import java.util.Random;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.stage.Stage;

public class Test
extends Application {
    private static final Random RND = new Random();
    private static int noOfNodes = 0;
    private Gauge gauge;
    private long lastTimerCall;
    private AnimationTimer timer;

    public void init() {
        this.gauge = ((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)((GaugeBuilder)GaugeBuilder.create().skinType(Gauge.SkinType.LINEAR)).orientation(Orientation.VERTICAL)).title("Input")).returnToZero(false)).animated(true)).animationDuration(25L)).smoothing(true)).prefHeight(200.0)).barColor(Color.CORNFLOWERBLUE)).build();
        this.gauge.currentValueProperty().addListener(o -> {
            double currentValue = this.gauge.getCurrentValue();
            if (currentValue > 3.0) {
                this.gauge.setBarColor(Color.rgb((int)200, (int)80, (int)0));
            } else if (currentValue < -3.0) {
                this.gauge.setBarColor(Color.rgb((int)0, (int)80, (int)200));
            } else {
                this.gauge.setBarColor(Color.rgb((int)0, (int)200, (int)0));
            }
        });
        this.lastTimerCall = System.nanoTime();
        this.timer = new AnimationTimer(){

            public void handle(long now) {
                if (now > Test.this.lastTimerCall + 1000000000L) {
                    double value = RND.nextDouble() * 100.0;
                    System.out.println(value);
                    Test.this.gauge.setValue(value);
                    Test.this.lastTimerCall = now;
                }
            }
        };
    }

    public void start(Stage stage) {
        StackPane pane = new StackPane(new Node[]{this.gauge});
        pane.setPadding(new Insets(10.0));
        Scene scene = new Scene((Parent)pane);
        stage.setTitle("Test");
        stage.setScene(scene);
        stage.show();
        Test.calcNoOfNodes((Node)pane);
        System.out.println(noOfNodes + " Nodes in SceneGraph");
        this.timer.start();
    }

    public void stop() {
        System.exit(0);
    }

    private static void calcNoOfNodes(Node node) {
        if (node instanceof Parent && ((Parent)node).getChildrenUnmodifiable().size() != 0) {
            ObservableList tempChildren = ((Parent)node).getChildrenUnmodifiable();
            noOfNodes += tempChildren.size();
            for (Node n : tempChildren) {
                Test.calcNoOfNodes(n);
            }
        }
    }

    public static void main(String[] args) {
        Test.launch((String[])args);
    }
}

