/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ChangeListener;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;

public class ChargeSkin
extends GaugeSkinBase {
    protected static final double PREFERRED_WIDTH = 306.0;
    protected static final double PREFERRED_HEIGHT = 66.0;
    protected static final double MINIMUM_WIDTH = 153.0;
    protected static final double MINIMUM_HEIGHT = 33.0;
    protected static final double MAXIMUM_WIDTH = 918.0;
    protected static final double MAXIMUM_HEIGHT = 198.0;
    private static double aspectRatio = 0.21568627450980393;
    private Region[] bars;
    private Background[] barBackgrounds;
    private Border barBorder;
    private double width;
    private double height;
    private HBox pane;
    private Paint backgroundPaint = Color.TRANSPARENT;
    private Paint borderPaint = Color.TRANSPARENT;
    private double borderWidth = 0.0;
    private InvalidationListener currentValueListener;
    private ChangeListener<Number> paneWidthListener;

    public ChargeSkin(Gauge gauge) {
        super(gauge);
        this.bars = new Region[12];
        this.barBackgrounds = new Background[24];
        this.currentValueListener = o -> this.handleEvents("VALUE");
        this.paneWidthListener = (o, ov, nv) -> {
            if (ov.intValue() == 0 && nv.intValue() > 0) {
                Platform.runLater(() -> this.resize());
            }
        };
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(306.0, 66.0);
            }
        }
        for (int i = 0; i < 12; ++i) {
            Region bar = new Region();
            bar.setPrefSize(20.0, (double)(20 + i * 4));
            this.bars[i] = bar;
        }
        this.pane = new HBox((Node[])this.bars);
        this.pane.setSpacing(5.9999990400000005);
        this.pane.setAlignment(Pos.BOTTOM_CENTER);
        this.pane.setFillHeight(false);
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.backgroundPaint, new CornerRadii(1024.0), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.borderPaint, BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.borderWidth))}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
        this.pane.widthProperty().addListener(this.paneWidthListener);
    }

    public void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (Double.compare(this.bars[0].getLayoutBounds().getWidth(), 0.0) == 0) {
            this.resize();
        }
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VALUE".equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        this.pane.widthProperty().removeListener(this.paneWidthListener);
        super.dispose();
    }

    @Override
    protected void resize() {
        this.width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        this.height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom();
        if (aspectRatio * this.width > this.height) {
            this.width = 1.0 / (aspectRatio / this.height);
        } else if (1.0 / (aspectRatio / this.height) > this.width) {
            this.height = aspectRatio * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.setPrefSize(this.width, this.height);
            this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
            this.pane.setSpacing(this.width * 0.01960784);
            double barWidth = 0.0;
            for (int i = 0; i < 12; ++i) {
                this.bars[i].setPrefSize(0.3030303 * this.height, 0.3030303 * this.height + (double)i * 0.06060606 * this.height);
                Bounds bounds = this.bars[i].getLayoutBounds();
                barWidth = bounds.getWidth();
                if (barWidth == 0.0) {
                    return;
                }
                BarColor barColor = i < 2 ? BarColor.RED : (i < 9 ? BarColor.ORANGE : BarColor.GREEN);
                this.barBackgrounds[i] = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(1024.0), Insets.EMPTY), new BackgroundFill((Paint)new LinearGradient(0.0, bounds.getMinY(), 0.0, bounds.getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, barColor.COLOR_FROM), new Stop(1.0, barColor.COLOR_TO)}), new CornerRadii(1024.0), new Insets(0.15 * barWidth))});
                this.barBackgrounds[i + 12] = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, new CornerRadii(1024.0), Insets.EMPTY), new BackgroundFill((Paint)new LinearGradient(0.0, bounds.getMinY(), 0.0, bounds.getMaxY(), false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, BarColor.GRAY.COLOR_FROM), new Stop(1.0, BarColor.GRAY.COLOR_TO)}), new CornerRadii(1024.0), new Insets(0.15 * barWidth))});
            }
            this.barBorder = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.rgb((int)102, (int)102, (int)102), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(0.05 * barWidth))});
        }
        this.redraw();
    }

    @Override
    protected void redraw() {
        int chargedBars = (int)(this.gauge.getCurrentValue() * 13.0);
        for (int i = 0; i < 12; ++i) {
            this.bars[i].setBackground(i < chargedBars ? this.barBackgrounds[i] : this.barBackgrounds[i + 12]);
            this.bars[i].setBorder(this.barBorder);
        }
    }

    private static enum BarColor {
        GRAY(Color.rgb((int)243, (int)243, (int)243), Color.rgb((int)143, (int)143, (int)143)),
        RED(Color.rgb((int)243, (int)0, (int)6), Color.rgb((int)143, (int)0, (int)9)),
        ORANGE(Color.rgb((int)253, (int)148, (int)21), Color.rgb((int)253, (int)97, (int)8)),
        GREEN(Color.rgb((int)110, (int)190, (int)5), Color.rgb((int)50, (int)177, (int)7));

        public final Color COLOR_FROM;
        public final Color COLOR_TO;

        private BarColor(Color COLOR_FROM, Color COLOR_TO) {
            this.COLOR_FROM = COLOR_FROM;
            this.COLOR_TO = COLOR_TO;
        }
    }
}

