/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.LcdDesign;
import eu.hansolo.medusa.LcdFont;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.InnerShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;

public class LcdSkin
extends GaugeSkinBase {
    protected static final double PREFERRED_WIDTH = 220.0;
    protected static final double PREFERRED_HEIGHT = 100.0;
    protected static final double MINIMUM_WIDTH = 5.0;
    protected static final double MINIMUM_HEIGHT = 5.0;
    protected static final double MAXIMUM_WIDTH = 1024.0;
    protected static final double MAXIMUM_HEIGHT = 1024.0;
    private static final Color DARK_NOISE_COLOR = Color.rgb((int)100, (int)100, (int)100, (double)0.1);
    private static final Color BRIGHT_NOISE_COLOR = Color.rgb((int)200, (int)200, (int)200, (double)0.05);
    private static final DropShadow FOREGROUND_SHADOW = new DropShadow();
    private static double aspectRatio = 0.45454545;
    private static Text oneSegment = new Text("8");
    private static Text dotSegment = new Text(".");
    private double width = 220.0;
    private double height = 100.0;
    private Pane pane;
    private Paint lcdPaint;
    private Paint lcdFramePaint;
    private ImageView crystalOverlay;
    private Image crystalImage;
    private Rectangle crystalClip;
    private InnerShadow mainInnerShadow0;
    private InnerShadow mainInnerShadow1;
    private Path threshold;
    private Path average;
    private Text valueText;
    private Text backgroundText;
    private Text unitText;
    private Text title;
    private Text lowerRightText;
    private Text upperLeftText;
    private Text upperRightText;
    private Text lowerCenterText;
    private double valueOffsetLeft = 0.0;
    private double valueOffsetRight = 0.0;
    private double digitalFontSizeFactor = 1.0;
    private Font valueFont;
    private Font unitFont;
    private Font titleFont;
    private Font smallFont;
    private double oneSegmentWidth;
    private double dotSegmentWidth;
    private double widthOfDecimals;
    private double availableWidth;
    private int noOfSegments;
    private StringBuilder backgroundTextBuilder = new StringBuilder();
    private Group shadowGroup;
    private String valueFormatString;
    private String otherFormatString;
    private Locale locale;
    private List<Section> sections;
    private Map<Section, Color[]> sectionColorMap;
    private InvalidationListener currentValueListener;

    public LcdSkin(Gauge gauge) {
        super(gauge);
        this.valueFormatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.otherFormatString = "%." + Integer.toString(gauge.getTickLabelDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.sectionColorMap = new HashMap<Section, Color[]>(this.sections.size());
        this.currentValueListener = o -> this.handleEvents("REDRAW");
        this.updateSectionColors();
        FOREGROUND_SHADOW.setOffsetX(0.0);
        FOREGROUND_SHADOW.setOffsetY(1.0);
        FOREGROUND_SHADOW.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.5));
        FOREGROUND_SHADOW.setBlurType(BlurType.TWO_PASS_BOX);
        FOREGROUND_SHADOW.setRadius(2.0);
        this.initGraphics();
        this.registerListeners();
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(220.0, 100.0);
            }
        }
        this.mainInnerShadow0 = new InnerShadow();
        this.mainInnerShadow0.setOffsetX(0.0);
        this.mainInnerShadow0.setOffsetY(0.0);
        this.mainInnerShadow0.setRadius(6.25);
        this.mainInnerShadow0.setColor(Color.rgb((int)255, (int)255, (int)255, (double)0.5));
        this.mainInnerShadow0.setBlurType(BlurType.TWO_PASS_BOX);
        this.mainInnerShadow1 = new InnerShadow();
        this.mainInnerShadow1.setOffsetX(0.0);
        this.mainInnerShadow1.setOffsetY(1.0);
        this.mainInnerShadow1.setRadius(4.166667);
        this.mainInnerShadow1.setColor(Color.rgb((int)0, (int)0, (int)0, (double)0.65));
        this.mainInnerShadow1.setBlurType(BlurType.TWO_PASS_BOX);
        this.mainInnerShadow1.setInput((Effect)this.mainInnerShadow0);
        this.crystalClip = new Rectangle(0.0, 0.0, this.width, this.height);
        this.crystalClip.setArcWidth(5.0);
        this.crystalClip.setArcHeight(5.0);
        this.crystalImage = Helper.createNoiseImage(220.0, 100.0, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0);
        this.crystalOverlay = new ImageView(this.crystalImage);
        this.crystalOverlay.setClip((Node)this.crystalClip);
        boolean crystalEnabled = this.gauge.isLcdCrystalEnabled();
        Helper.enableNode((Node)this.crystalOverlay, crystalEnabled);
        this.threshold = new Path();
        this.threshold.setStroke(null);
        Helper.enableNode((Node)this.threshold, this.gauge.isThresholdVisible());
        this.average = new Path();
        this.average.setStroke(null);
        Helper.enableNode((Node)this.average, this.gauge.isAverageVisible());
        this.backgroundText = new Text(String.format(this.locale, this.valueFormatString, this.gauge.getCurrentValue()));
        this.backgroundText.setFill((Paint)this.gauge.getLcdDesign().lcdBackgroundColor);
        this.backgroundText.setOpacity(LcdFont.LCD == this.gauge.getLcdFont() || LcdFont.ELEKTRA == this.gauge.getLcdFont() ? 1.0 : 0.0);
        this.valueText = new Text(String.format(this.locale, this.valueFormatString, this.gauge.getCurrentValue()));
        this.valueText.setFill((Paint)this.gauge.getLcdDesign().lcdForegroundColor);
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setFill((Paint)this.gauge.getLcdDesign().lcdForegroundColor);
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.title = new Text(this.gauge.getTitle());
        this.title.setFill((Paint)this.gauge.getLcdDesign().lcdForegroundColor);
        Helper.enableNode((Node)this.title, !this.gauge.getTitle().isEmpty());
        this.lowerRightText = new Text(this.gauge.getSubTitle());
        this.lowerRightText.setFill((Paint)this.gauge.getLcdDesign().lcdForegroundColor);
        Helper.enableNode((Node)this.lowerRightText, !this.gauge.getSubTitle().isEmpty());
        this.upperLeftText = new Text(String.format(this.locale, this.otherFormatString, this.gauge.getMinMeasuredValue()));
        this.upperLeftText.setFill((Paint)this.gauge.getLcdDesign().lcdForegroundColor);
        Helper.enableNode((Node)this.upperLeftText, this.gauge.isMinMeasuredValueVisible());
        this.upperRightText = new Text(String.format(this.locale, this.otherFormatString, this.gauge.getMaxMeasuredValue()));
        this.upperRightText.setFill((Paint)this.gauge.getLcdDesign().lcdForegroundColor);
        Helper.enableNode((Node)this.upperRightText, this.gauge.isMaxMeasuredValueVisible());
        this.lowerCenterText = new Text(String.format(this.locale, this.otherFormatString, this.gauge.getOldValue()));
        this.lowerCenterText.setFill((Paint)this.gauge.getLcdDesign().lcdForegroundColor);
        Helper.enableNode((Node)this.lowerCenterText, this.gauge.isOldValueVisible());
        this.shadowGroup = new Group();
        this.shadowGroup.setEffect((Effect)(this.gauge.isShadowsEnabled() ? FOREGROUND_SHADOW : null));
        this.shadowGroup.getChildren().setAll((Object[])new Node[]{this.threshold, this.average, this.valueText, this.unitText, this.title, this.lowerRightText, this.upperLeftText, this.upperRightText, this.lowerCenterText});
        this.pane = new Pane(new Node[]{this.crystalOverlay, this.backgroundText, this.shadowGroup});
        this.pane.setEffect((Effect)(this.gauge.isShadowsEnabled() ? this.mainInnerShadow1 : null));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        if ("REDRAW".equals(EVENT_TYPE)) {
            this.pane.setEffect((Effect)(this.gauge.isShadowsEnabled() ? this.mainInnerShadow1 : null));
            this.shadowGroup.setEffect((Effect)(this.gauge.isShadowsEnabled() ? FOREGROUND_SHADOW : null));
            this.updateLcdDesign(this.height);
            this.redraw();
        } else if ("RESIZE".equals(EVENT_TYPE)) {
            aspectRatio = this.gauge.getPrefHeight() / this.gauge.getPrefWidth();
            this.resize();
            this.redraw();
        } else if ("LCD".equals(EVENT_TYPE)) {
            this.updateLcdDesign(this.height);
        } else if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.crystalOverlay, this.gauge.isLcdCrystalEnabled());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
            Helper.enableNode((Node)this.upperLeftText, this.gauge.isMinMeasuredValueVisible());
            Helper.enableNode((Node)this.upperRightText, this.gauge.isMaxMeasuredValueVisible());
            Helper.enableNode((Node)this.lowerRightText, !this.gauge.getSubTitle().isEmpty());
            Helper.enableNode((Node)this.lowerCenterText, this.gauge.isOldValueVisible());
            Helper.enableNode((Node)this.average, this.gauge.isAverageVisible());
            Helper.enableNode((Node)this.threshold, this.gauge.isThresholdVisible());
            this.resize();
            this.redraw();
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.gauge.getSections();
            this.updateSectionColors();
            this.resize();
            this.redraw();
        }
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private boolean isNoOfDigitsInvalid() {
        double AVAILABLE_WIDTH = this.width - 2.0 - this.valueOffsetLeft - this.valueOffsetRight;
        double NEEDED_WIDTH = this.valueText.getLayoutBounds().getWidth();
        return Double.compare(AVAILABLE_WIDTH, NEEDED_WIDTH) < 0;
    }

    private void updateLcdDesign(double HEIGHT) {
        LcdDesign lcdDesign = this.gauge.getLcdDesign();
        Color[] lcdColors = lcdDesign.getColors();
        if (LcdDesign.SECTIONS == lcdDesign) {
            double currentValue = this.gauge.getCurrentValue();
            int listSize = this.sections.size();
            for (int i = 0; i < listSize; ++i) {
                Section section = this.sections.get(i);
                if (!section.contains(currentValue)) continue;
                lcdColors = this.sectionColorMap.get(section);
                break;
            }
        }
        this.lcdPaint = new LinearGradient(0.0, 1.0, 0.0, HEIGHT - 1.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, lcdColors[0]), new Stop(0.03, lcdColors[1]), new Stop(0.5, lcdColors[2]), new Stop(0.5, lcdColors[3]), new Stop(1.0, lcdColors[4])});
        if (lcdDesign.name().startsWith("FLAT")) {
            this.lcdFramePaint = this.gauge.getBorderPaint();
            this.lcdPaint = this.gauge.getBackgroundPaint();
            Color lcdForegroundColor = (Color)this.gauge.getForegroundPaint();
            this.backgroundText.setFill((Paint)Color.color((double)lcdForegroundColor.getRed(), (double)lcdForegroundColor.getGreen(), (double)lcdForegroundColor.getBlue(), (double)0.1));
            this.valueText.setFill((Paint)lcdForegroundColor);
            this.upperLeftText.setFill((Paint)lcdForegroundColor);
            this.title.setFill((Paint)lcdForegroundColor);
            this.upperRightText.setFill((Paint)lcdForegroundColor);
            this.unitText.setFill((Paint)lcdForegroundColor);
            this.lowerRightText.setFill((Paint)lcdForegroundColor);
            this.lowerCenterText.setFill((Paint)lcdForegroundColor);
            this.threshold.setFill((Paint)lcdForegroundColor);
            this.average.setFill((Paint)lcdForegroundColor);
        } else {
            this.lcdFramePaint = new LinearGradient(0.0, 0.02083333 * this.height, 0.0, HEIGHT - 0.02083333 * HEIGHT, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, Color.rgb((int)26, (int)26, (int)26)), new Stop(0.015, Color.rgb((int)77, (int)77, (int)77)), new Stop(0.985, Color.rgb((int)77, (int)77, (int)77)), new Stop(1.0, Color.rgb((int)221, (int)221, (int)221))});
            this.lcdPaint = new LinearGradient(0.0, 1.0, 0.0, HEIGHT - 1.0, false, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.0, lcdColors[0]), new Stop(0.03, lcdColors[1]), new Stop(0.5, lcdColors[2]), new Stop(0.5, lcdColors[3]), new Stop(1.0, lcdColors[4])});
            this.backgroundText.setFill((Paint)lcdDesign.lcdBackgroundColor);
            this.valueText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.upperLeftText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.title.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.upperRightText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.unitText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.lowerRightText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.lowerCenterText.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.threshold.setFill((Paint)lcdDesign.lcdForegroundColor);
            this.average.setFill((Paint)lcdDesign.lcdForegroundColor);
        }
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.lcdPaint, new CornerRadii(0.10416667 * HEIGHT), Insets.EMPTY)}));
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.lcdFramePaint, BorderStrokeStyle.SOLID, new CornerRadii(0.05 * HEIGHT), new BorderWidths(0.02083333 * HEIGHT))}));
    }

    private void updateSectionColors() {
        int listSize = this.sections.size();
        this.sectionColorMap.clear();
        for (int i = 0; i < listSize; ++i) {
            Color sectionColor = this.sections.get(i).getColor();
            Color lcdForegroundColor = Helper.isMonochrome(sectionColor) ? (Helper.isDark(sectionColor) ? Color.WHITE : Color.BLACK) : Color.hsb((double)sectionColor.getHue(), (double)sectionColor.getSaturation(), (double)(sectionColor.getBrightness() * 0.3));
            Color lcdBackgroundColor = Color.color((double)sectionColor.getRed(), (double)sectionColor.getGreen(), (double)sectionColor.getBlue(), (double)0.1);
            this.sectionColorMap.put(this.sections.get(i), this.getSectionColors(lcdBackgroundColor, lcdForegroundColor));
        }
    }

    private Color[] getSectionColors(Color LCD_BACKGROUND_COLOR, Color LCD_FOREGROUND_COLOR) {
        double hue = LCD_BACKGROUND_COLOR.getHue();
        double sat = LCD_BACKGROUND_COLOR.getSaturation();
        Color[] colors = Helper.isMonochrome(LCD_BACKGROUND_COLOR) ? new Color[]{Color.hsb((double)hue, (double)0.0, (double)0.69), Color.hsb((double)hue, (double)0.0, (double)1.0), Color.hsb((double)hue, (double)0.0, (double)0.76), Color.hsb((double)hue, (double)0.0, (double)0.76), Color.hsb((double)hue, (double)sat, (double)0.69), Helper.isDark(LCD_BACKGROUND_COLOR) ? Color.WHITE : Color.BLACK, Helper.isDark(LCD_BACKGROUND_COLOR) ? Color.rgb((int)255, (int)255, (int)255, (double)0.1) : Color.rgb((int)0, (int)0, (int)0, (double)0.1)} : new Color[]{Color.hsb((double)hue, (double)sat, (double)0.69), Color.hsb((double)hue, (double)sat, (double)1.0), Color.hsb((double)hue, (double)sat, (double)0.76), Color.hsb((double)hue, (double)sat, (double)0.76), Color.hsb((double)hue, (double)sat, (double)0.69), LCD_FOREGROUND_COLOR, Color.color((double)LCD_BACKGROUND_COLOR.getRed(), (double)LCD_BACKGROUND_COLOR.getGreen(), (double)LCD_BACKGROUND_COLOR.getBlue(), (double)0.1)};
        return colors;
    }

    private void updateFonts() {
        this.digitalFontSizeFactor = 1.0;
        switch (this.gauge.getLcdFont()) {
            case LCD: {
                this.valueFont = Fonts.digital(0.6 * this.height);
                this.digitalFontSizeFactor = 1.4;
                break;
            }
            case DIGITAL: {
                this.valueFont = Fonts.digitalReadout(0.5833333333 * this.height);
                break;
            }
            case DIGITAL_BOLD: {
                this.valueFont = Fonts.digitalReadoutBold(0.5833333333 * this.height);
                break;
            }
            case ELEKTRA: {
                this.valueFont = Fonts.elektra(0.62 * this.height);
                break;
            }
            default: {
                this.valueFont = Fonts.robotoMedium(0.5 * this.height);
            }
        }
        this.backgroundText.setFont(this.valueFont);
        this.backgroundText.setOpacity(LcdFont.LCD == this.gauge.getLcdFont() || LcdFont.DIGITAL == this.gauge.getLcdFont() || LcdFont.DIGITAL_BOLD == this.gauge.getLcdFont() || LcdFont.ELEKTRA == this.gauge.getLcdFont() ? 1.0 : 0.0);
        this.valueText.setFont(this.valueFont);
        this.unitFont = Fonts.latoBold(0.26 * this.height);
        this.titleFont = Fonts.latoBold(0.1666666667 * this.height);
        this.smallFont = Fonts.latoBold(0.1666666667 * this.height);
    }

    private void updateBackgroundText() {
        int i;
        this.backgroundText.setCache(false);
        this.backgroundText.setTextOrigin(VPos.BASELINE);
        this.backgroundText.setTextAlignment(TextAlignment.RIGHT);
        oneSegment.setFont(this.valueFont);
        dotSegment.setText(".");
        if (LcdFont.LCD == this.gauge.getLcdFont()) {
            oneSegment.setText("8");
        } else if (LcdFont.DIGITAL == this.gauge.getLcdFont()) {
            oneSegment.setText("_");
        } else if (LcdFont.DIGITAL_BOLD == this.gauge.getLcdFont()) {
            oneSegment.setText("_");
        } else if (LcdFont.ELEKTRA == this.gauge.getLcdFont()) {
            oneSegment.setText("_");
        }
        this.oneSegmentWidth = oneSegment.getLayoutBounds().getWidth();
        this.dotSegmentWidth = dotSegment.getLayoutBounds().getWidth();
        this.widthOfDecimals = 0 == this.gauge.getDecimals() ? 0.0 : (double)this.gauge.getDecimals() * this.oneSegmentWidth + (LcdFont.LCD == this.gauge.getLcdFont() ? this.oneSegmentWidth : this.dotSegmentWidth);
        this.availableWidth = this.width - 0.0151515152 * this.width - 0.0416666667 * this.height - 2.0 - this.valueOffsetRight - this.widthOfDecimals;
        this.noOfSegments = (int)Math.floor(this.availableWidth / this.oneSegmentWidth);
        this.backgroundTextBuilder.setLength(0);
        for (i = 0; i < this.gauge.getDecimals(); ++i) {
            this.backgroundTextBuilder.append(oneSegment.getText());
        }
        if (this.gauge.getDecimals() != 0) {
            this.backgroundTextBuilder.insert(0, ".");
        }
        for (i = 0; i < this.noOfSegments; ++i) {
            this.backgroundTextBuilder.insert(0, oneSegment.getText());
        }
        this.backgroundText.setText(this.backgroundTextBuilder.toString());
        this.backgroundText.setCache(true);
        this.backgroundText.setCacheHint(CacheHint.SCALE);
    }

    @Override
    protected void resize() {
        this.width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        this.height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom();
        if (aspectRatio * this.width > this.height) {
            this.width = 1.0 / (aspectRatio / this.height);
        } else if (1.0 / (aspectRatio / this.height) > this.width) {
            this.height = aspectRatio * this.width;
        }
        if (this.width > 0.0 && this.height > 0.0) {
            this.pane.setMaxSize(this.width, this.height);
            this.pane.relocate((this.gauge.getWidth() - this.width) * 0.5, (this.gauge.getHeight() - this.height) * 0.5);
            this.updateLcdDesign(this.height);
            this.mainInnerShadow0.setRadius(0.0625 * this.height);
            this.mainInnerShadow1.setRadius(0.04166667 * this.height);
            if (this.crystalOverlay.isVisible()) {
                double frameWidth = 0.02083333 * this.height;
                double imgWidth = this.width - 2.0 * frameWidth;
                double imgHeight = this.height - 2.0 * frameWidth;
                this.crystalClip.setWidth(imgWidth);
                this.crystalClip.setHeight(imgHeight);
                this.crystalOverlay.setImage(Helper.createNoiseImage(this.width, this.height, DARK_NOISE_COLOR, BRIGHT_NOISE_COLOR, 8.0));
                this.crystalOverlay.setCache(true);
                this.crystalOverlay.relocate(frameWidth, frameWidth);
            }
            double tSize = 0.2 * this.height;
            this.threshold.getElements().clear();
            this.threshold.getElements().add((Object)new MoveTo(0.41666667 * tSize, 0.75 * tSize));
            this.threshold.getElements().add((Object)new LineTo(0.583333333333333 * tSize, 0.75 * tSize));
            this.threshold.getElements().add((Object)new LineTo(0.583333333333333 * tSize, 0.916666666666667 * tSize));
            this.threshold.getElements().add((Object)new LineTo(0.416666666666667 * tSize, 0.916666666666667 * tSize));
            this.threshold.getElements().add((Object)new LineTo(0.416666666666667 * tSize, 0.75 * tSize));
            this.threshold.getElements().add((Object)new ClosePath());
            this.threshold.getElements().add((Object)new MoveTo(0.416666666666667 * tSize, 0.333333333333333 * tSize));
            this.threshold.getElements().add((Object)new LineTo(0.583333333333333 * tSize, 0.333333333333333 * tSize));
            this.threshold.getElements().add((Object)new LineTo(0.583333333333333 * tSize, 0.666666666666667 * tSize));
            this.threshold.getElements().add((Object)new LineTo(0.416666666666667 * tSize, 0.666666666666667 * tSize));
            this.threshold.getElements().add((Object)new LineTo(0.416666666666667 * tSize, 0.333333333333333 * tSize));
            this.threshold.getElements().add((Object)new ClosePath());
            this.threshold.getElements().add((Object)new MoveTo(tSize, tSize));
            this.threshold.getElements().add((Object)new LineTo(0.5 * tSize, 0.0));
            this.threshold.getElements().add((Object)new LineTo(0.0, tSize));
            this.threshold.getElements().add((Object)new LineTo(tSize, tSize));
            this.threshold.getElements().add((Object)new ClosePath());
            this.threshold.relocate(0.027961994662429348 * this.width, 0.75 * this.height);
            double aSize = 0.12 * this.height;
            this.average.getElements().clear();
            this.average.getElements().add((Object)new MoveTo(0.5 * aSize, 0.0));
            this.average.getElements().add((Object)new CubicCurveTo(0.22727272727272727 * aSize, 0.0, 0.022727272727272728 * aSize, 0.22727272727272727 * aSize, 0.022727272727272728 * aSize, 0.5 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.022727272727272728 * aSize, 0.6136363636363636 * aSize, 0.045454545454545456 * aSize, 0.7045454545454546 * aSize, 0.11363636363636363 * aSize, 0.7954545454545454 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.11363636363636363 * aSize, 0.7954545454545454 * aSize, 0.0, 0.8863636363636364 * aSize, 0.0, 0.8863636363636364 * aSize));
            this.average.getElements().add((Object)new LineTo(0.09090909090909091 * aSize, 0.9772727272727273 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.09090909090909091 * aSize, 0.9772727272727273 * aSize, 0.18181818181818182 * aSize, 0.8863636363636364 * aSize, 0.18181818181818182 * aSize, 0.8863636363636364 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.2727272727272727 * aSize, 0.9545454545454546 * aSize, 0.38636363636363635 * aSize, aSize, 0.5 * aSize, aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.7727272727272727 * aSize, aSize, 0.9772727272727273 * aSize, 0.7727272727272727 * aSize, 0.9772727272727273 * aSize, 0.5 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.9772727272727273 * aSize, 0.38636363636363635 * aSize, 0.9545454545454546 * aSize, 0.29545454545454547 * aSize, 0.8863636363636364 * aSize, 0.20454545454545456 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.8863636363636364 * aSize, 0.20454545454545456 * aSize, aSize, 0.09090909090909091 * aSize, aSize, 0.09090909090909091 * aSize));
            this.average.getElements().add((Object)new LineTo(0.9090909090909091 * aSize, 0.0));
            this.average.getElements().add((Object)new CubicCurveTo(0.9090909090909091 * aSize, 0.0, 0.7954545454545454 * aSize, 0.09090909090909091 * aSize, 0.7954545454545454 * aSize, 0.09090909090909091 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.7045454545454546 * aSize, 0.045454545454545456 * aSize, 0.6136363636363636 * aSize, 0.0, 0.5 * aSize, 0.0));
            this.average.getElements().add((Object)new ClosePath());
            this.average.getElements().add((Object)new MoveTo(0.7954545454545454 * aSize, 0.29545454545454547 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.8181818181818182 * aSize, 0.36363636363636365 * aSize, 0.8409090909090909 * aSize, 0.4318181818181818 * aSize, 0.8409090909090909 * aSize, 0.5 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.8409090909090909 * aSize, 0.7045454545454546 * aSize, 0.7045454545454546 * aSize, 0.8863636363636364 * aSize, 0.5 * aSize, 0.8863636363636364 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.4090909090909091 * aSize, 0.8863636363636364 * aSize, 0.3409090909090909 * aSize, 0.8636363636363636 * aSize, 0.2727272727272727 * aSize, 0.7954545454545454 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.2727272727272727 * aSize, 0.7954545454545454 * aSize, 0.7954545454545454 * aSize, 0.29545454545454547 * aSize, 0.7954545454545454 * aSize, 0.29545454545454547 * aSize));
            this.average.getElements().add((Object)new ClosePath());
            this.average.getElements().add((Object)new MoveTo(0.5 * aSize, 0.11363636363636363 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.5909090909090909 * aSize, 0.11363636363636363 * aSize, 0.6590909090909091 * aSize, 0.13636363636363635 * aSize, 0.7045454545454546 * aSize, 0.18181818181818182 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.7045454545454546 * aSize, 0.18181818181818182 * aSize, 0.20454545454545456 * aSize, 0.6818181818181818 * aSize, 0.20454545454545456 * aSize, 0.6818181818181818 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.18181818181818182 * aSize, 0.6363636363636364 * aSize, 0.1590909090909091 * aSize, 0.5681818181818182 * aSize, 0.1590909090909091 * aSize, 0.5 * aSize));
            this.average.getElements().add((Object)new CubicCurveTo(0.1590909090909091 * aSize, 0.29545454545454547 * aSize, 0.29545454545454547 * aSize, 0.11363636363636363 * aSize, 0.5 * aSize, 0.11363636363636363 * aSize));
            this.average.getElements().add((Object)new ClosePath());
            this.average.relocate(0.32 * this.width, 0.82 * this.height);
            this.updateFonts();
            this.unitText.setFont(this.unitFont);
            this.unitText.setTextOrigin(VPos.BASELINE);
            this.unitText.setTextAlignment(TextAlignment.RIGHT);
            this.unitText.setText(this.gauge.getUnit());
            if (this.unitText.visibleProperty().isBound()) {
                this.unitText.visibleProperty().unbind();
            }
            this.valueOffsetLeft = this.height * 0.04;
            if (this.gauge.getUnit().isEmpty()) {
                this.valueOffsetRight = this.height * 0.0833333333;
                this.valueText.setX(this.width - this.valueText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            } else {
                this.unitText.setX(this.width - this.unitText.getLayoutBounds().getWidth() - this.height * 0.04);
                this.unitText.setY(this.height - this.valueText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
                this.valueOffsetRight = this.unitText.getLayoutBounds().getWidth() + this.height * 0.0833333333;
                this.valueText.setX(this.width - 2.0 - this.valueText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            }
            this.valueText.setY(this.height - this.valueText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.updateBackgroundText();
            if (this.gauge.getUnit().isEmpty()) {
                this.backgroundText.setX(this.width - this.backgroundText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            } else {
                this.backgroundText.setX(this.width - 2.0 - this.backgroundText.getLayoutBounds().getWidth() - this.valueOffsetRight);
            }
            this.backgroundText.setY(this.height - this.backgroundText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
            this.title.setFont(this.titleFont);
            this.title.setTextOrigin(VPos.BASELINE);
            this.title.setTextAlignment(TextAlignment.CENTER);
            this.title.setText(this.gauge.getTitle());
            this.title.setX((this.width - this.title.getLayoutBounds().getWidth()) * 0.5);
            this.title.setY(this.height * 0.18);
            this.lowerRightText.setFont(this.smallFont);
            this.lowerRightText.setTextOrigin(VPos.BASELINE);
            this.lowerRightText.setTextAlignment(TextAlignment.RIGHT);
            this.lowerRightText.setText(this.gauge.getSubTitle());
            this.lowerRightText.setX(this.pane.getLayoutBounds().getMinX() + (this.pane.getLayoutBounds().getWidth() - this.lowerRightText.getLayoutBounds().getWidth()) * 0.5);
            this.lowerRightText.setY(this.height * 0.94);
            this.upperLeftText.setFont(this.smallFont);
            this.upperLeftText.setTextOrigin(VPos.BASELINE);
            this.upperLeftText.setTextAlignment(TextAlignment.RIGHT);
            this.upperLeftText.setX(this.pane.getLayoutBounds().getMinX() + 0.0416666667 * this.height);
            this.upperLeftText.setY(this.height * 0.18);
            this.upperRightText.setFont(this.smallFont);
            this.upperRightText.setTextOrigin(VPos.BASELINE);
            this.upperRightText.setTextAlignment(TextAlignment.RIGHT);
            this.upperRightText.setY(this.height * 0.18);
            this.lowerCenterText.setFont(this.smallFont);
            this.lowerCenterText.setTextOrigin(VPos.BASELINE);
            this.lowerCenterText.setTextAlignment(TextAlignment.CENTER);
            this.lowerCenterText.setX((this.width - this.lowerCenterText.getLayoutBounds().getWidth()) * 0.5);
            this.lowerCenterText.setY(this.height * 0.94);
        }
    }

    @Override
    protected void redraw() {
        this.locale = this.gauge.getLocale();
        this.valueFormatString = "%." + Integer.toString(this.gauge.getDecimals()) + "f";
        this.otherFormatString = "%." + Integer.toString(this.gauge.getTickLabelDecimals()) + "f";
        if (this.gauge.isThresholdVisible()) {
            this.threshold.setVisible(Double.compare(this.gauge.getCurrentValue(), this.gauge.getThreshold()) >= 0);
        }
        this.valueText.setText(this.isNoOfDigitsInvalid() ? "-E-" : Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), this.gauge.getCurrentValue()));
        this.updateBackgroundText();
        if (this.gauge.getUnit().isEmpty()) {
            this.backgroundText.setX(this.width - this.backgroundText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        } else {
            this.backgroundText.setX(this.width - 2.0 - this.backgroundText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        }
        this.backgroundText.setY(this.height - this.backgroundText.getLayoutBounds().getHeight() * this.digitalFontSizeFactor * 0.5);
        if (this.gauge.getUnit().isEmpty()) {
            this.valueText.setX(this.width - this.valueText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        } else {
            this.valueText.setX(this.width - 2.0 - this.valueText.getLayoutBounds().getWidth() - this.valueOffsetRight);
        }
        this.title.setText(this.gauge.getTitle());
        this.title.setX((this.width - this.title.getLayoutBounds().getWidth()) * 0.5);
        this.upperLeftText.setText(String.format(this.locale, this.otherFormatString, this.gauge.getMinMeasuredValue()));
        if (this.upperLeftText.getX() + this.upperLeftText.getLayoutBounds().getWidth() > this.title.getX()) {
            this.upperLeftText.setText("...");
        }
        this.upperRightText.setText(String.format(this.locale, this.otherFormatString, this.gauge.getMaxMeasuredValue()));
        this.upperRightText.setX(this.width - this.upperRightText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        if (this.upperRightText.getX() < this.title.getX() + this.title.getLayoutBounds().getWidth()) {
            this.upperRightText.setText("...");
            this.upperRightText.setX(this.width - this.upperRightText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        }
        if (this.gauge.isAverageVisible()) {
            this.lowerCenterText.setText(String.format(this.locale, this.otherFormatString, this.gauge.getAverage()));
        } else {
            this.lowerCenterText.setText(String.format(this.locale, this.otherFormatString, this.gauge.getOldValue()));
        }
        this.lowerCenterText.setX((this.width - this.lowerCenterText.getLayoutBounds().getWidth()) * 0.5);
        this.lowerCenterText.setY(0.94 * this.height);
        this.average.relocate(this.lowerCenterText.getX() - 0.2 * this.height, 0.82 * this.height);
        this.lowerRightText.setText(this.gauge.getSubTitle());
        this.lowerRightText.setX(this.width - this.lowerRightText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        this.lowerRightText.setY(this.height * 0.94);
        if (this.lowerRightText.getX() < this.lowerCenterText.getX() + this.lowerCenterText.getLayoutBounds().getWidth()) {
            this.lowerRightText.setText("...");
            this.lowerRightText.setX(this.width - this.lowerRightText.getLayoutBounds().getWidth() - 0.0416666667 * this.height);
        }
    }
}

