/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Clock;
import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.skins.ClockSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Locale;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.ArcType;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.text.TextAlignment;

public class RoundLcdClockSkin
extends ClockSkinBase {
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm");
    private static final DateTimeFormatter AMPM_TIME_FORMATTER = DateTimeFormatter.ofPattern("hh:mm a");
    private double size;
    private double center;
    private DateTimeFormatter dateFormat;
    private Pane pane;
    private Canvas backgroundCanvas;
    private GraphicsContext backgroundCtx;
    private Canvas foregroundCanvas;
    private GraphicsContext foregroundCtx;
    private Canvas hoursCanvas;
    private GraphicsContext hoursCtx;
    private Canvas minutesCanvas;
    private GraphicsContext minutesCtx;
    private Canvas secondsCanvas;
    private GraphicsContext secondsCtx;
    private Color hourColor;
    private Color minuteColor;
    private Color fiveMinuteColor;
    private Color secondColor;
    private Color titleColor;
    private Color textColor;
    private Color dateColor;
    private Color alarmColor;

    public RoundLcdClockSkin(Clock clock) {
        super(clock);
        this.hourColor = clock.getHourColor();
        this.minuteColor = clock.getMinuteColor();
        this.fiveMinuteColor = this.minuteColor.darker();
        this.secondColor = clock.getSecondColor();
        this.titleColor = clock.getTitleColor();
        this.textColor = clock.getTextColor();
        this.dateColor = clock.getDateColor();
        this.alarmColor = clock.getAlarmColor();
        this.dateFormat = Helper.getDateFormat(clock.getLocale());
        this.initGraphics();
        this.registerListeners();
    }

    @Override
    protected void initGraphics() {
        if (Double.compare(this.clock.getPrefWidth(), 0.0) <= 0 || Double.compare(this.clock.getPrefHeight(), 0.0) <= 0 || Double.compare(this.clock.getWidth(), 0.0) <= 0 || Double.compare(this.clock.getHeight(), 0.0) <= 0) {
            if (this.clock.getPrefWidth() > 0.0 && this.clock.getPrefHeight() > 0.0) {
                this.clock.setPrefSize(this.clock.getPrefWidth(), this.clock.getPrefHeight());
            } else {
                this.clock.setPrefSize(250.0, 250.0);
            }
        }
        this.backgroundCanvas = new Canvas(250.0, 250.0);
        this.backgroundCtx = this.backgroundCanvas.getGraphicsContext2D();
        this.foregroundCanvas = new Canvas(250.0, 250.0);
        this.foregroundCtx = this.foregroundCanvas.getGraphicsContext2D();
        this.hoursCanvas = new Canvas(250.0, 250.0);
        this.hoursCtx = this.hoursCanvas.getGraphicsContext2D();
        this.minutesCanvas = new Canvas(250.0, 250.0);
        this.minutesCtx = this.minutesCanvas.getGraphicsContext2D();
        this.secondsCanvas = new Canvas(250.0, 250.0);
        this.secondsCtx = this.secondsCanvas.getGraphicsContext2D();
        this.pane = new Pane(new Node[]{this.backgroundCanvas, this.foregroundCanvas, this.hoursCanvas, this.minutesCanvas, this.secondsCanvas});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if (!"VISIBILITY".equals(EVENT_TYPE) && "SECTION".equals(EVENT_TYPE)) {
            this.redraw();
        }
    }

    private void drawForeground(ZonedDateTime TIME) {
        this.foregroundCtx.clearRect(0.0, 0.0, this.size, this.size);
        Locale locale = this.clock.getLocale();
        if (this.clock.isTextVisible()) {
            this.foregroundCtx.setFill((Paint)this.textColor);
            this.foregroundCtx.setTextBaseline(VPos.CENTER);
            this.foregroundCtx.setTextAlign(TextAlignment.CENTER);
            if (Locale.US == locale) {
                this.foregroundCtx.setFont(Fonts.digital(0.17 * this.size));
                this.foregroundCtx.fillText(AMPM_TIME_FORMATTER.format(TIME), this.center, this.center);
            } else {
                this.foregroundCtx.setFont(Fonts.digital(0.2 * this.size));
                this.foregroundCtx.fillText(TIME_FORMATTER.format(TIME), this.center, this.center);
            }
        }
        if (this.clock.isDateVisible()) {
            this.foregroundCtx.setFill((Paint)this.dateColor);
            this.foregroundCtx.setFont(Fonts.digital(0.09 * this.size));
            this.foregroundCtx.fillText(this.dateFormat.format(TIME), this.center, this.size * 0.65);
        }
        if (this.clock.isAlarmsEnabled() && this.clock.getAlarms().size() > 0) {
            this.foregroundCtx.setFill((Paint)this.alarmColor);
            this.drawAlarmIcon(this.foregroundCtx, this.foregroundCtx.getFill());
        }
    }

    private void drawHours(ZonedDateTime TIME) {
        int hourCounter = 1;
        int hour = TIME.getHour();
        double strokeWidth = this.size * 0.06;
        this.hoursCtx.setLineCap(StrokeLineCap.BUTT);
        this.hoursCtx.clearRect(0.0, 0.0, this.size, this.size);
        for (int i = 450; i >= 90; --i) {
            this.hoursCtx.save();
            if (i % 30 == 0) {
                this.hoursCtx.setStroke((Paint)this.hourColor);
                this.hoursCtx.setLineWidth(strokeWidth);
                if (hour == 0 || hour == 12) {
                    this.hoursCtx.strokeArc(strokeWidth * 0.5, strokeWidth * 0.5, this.size - strokeWidth, this.size - strokeWidth, (double)(i + 1 - 30), 28.0, ArcType.OPEN);
                } else if (hourCounter <= (TIME.get(ChronoField.AMPM_OF_DAY) == 1 ? hour - 12 : hour)) {
                    this.hoursCtx.strokeArc(strokeWidth * 0.5, strokeWidth * 0.5, this.size - strokeWidth, this.size - strokeWidth, (double)(i + 1 - 30), 28.0, ArcType.OPEN);
                    ++hourCounter;
                }
            }
            this.hoursCtx.restore();
        }
    }

    private void drawMinutes(ZonedDateTime TIME) {
        int minCounter = 1;
        double strokeWidth = this.size * 0.06;
        this.minutesCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.minutesCtx.setLineCap(StrokeLineCap.BUTT);
        for (int i = 450; i >= 90; --i) {
            this.minutesCtx.save();
            if (i % 6 == 0 && minCounter <= TIME.getMinute()) {
                this.minutesCtx.setStroke((Paint)(minCounter % 5 == 0 ? this.fiveMinuteColor : this.minuteColor));
                this.minutesCtx.setLineWidth(strokeWidth);
                this.minutesCtx.strokeArc(strokeWidth * 0.5 + strokeWidth * 1.1, strokeWidth * 0.5 + strokeWidth * 1.1, this.size - strokeWidth - strokeWidth * 2.2, this.size - strokeWidth - strokeWidth * 2.2, (double)(i + 1 - 6), 4.0, ArcType.OPEN);
                ++minCounter;
            }
            this.minutesCtx.restore();
        }
    }

    private void drawSeconds(ZonedDateTime TIME) {
        int secCounter = 1;
        double strokeWidth = this.size * 0.06;
        this.secondsCtx.setLineCap(StrokeLineCap.BUTT);
        this.secondsCtx.clearRect(0.0, 0.0, this.size, this.size);
        for (int i = 450; i >= 90; --i) {
            this.secondsCtx.save();
            if (i % 6 == 0 && secCounter <= TIME.getSecond() + 1) {
                this.secondsCtx.setStroke((Paint)this.secondColor);
                this.secondsCtx.setLineWidth(strokeWidth * 0.25);
                this.secondsCtx.strokeArc(strokeWidth * 0.5 + strokeWidth * 1.8, strokeWidth * 0.5 + strokeWidth * 1.8, this.size - strokeWidth - strokeWidth * 3.6, this.size - strokeWidth - strokeWidth * 3.6, (double)(i + 1 - 6), 4.0, ArcType.OPEN);
                ++secCounter;
            }
            this.secondsCtx.restore();
        }
    }

    private void drawBackground() {
        double strokeWidth = this.size * 0.06;
        this.backgroundCtx.setLineCap(StrokeLineCap.BUTT);
        this.backgroundCtx.clearRect(0.0, 0.0, this.size, this.size);
        this.backgroundCtx.setStroke((Paint)Color.rgb((int)0, (int)12, (int)6, (double)0.1));
        Color hColor = Helper.getTranslucentColorFrom(this.hourColor, 0.1);
        Color mColor = Helper.getTranslucentColorFrom(this.minuteColor, 0.1);
        Color sColor = Helper.getTranslucentColorFrom(this.secondColor, 0.1);
        for (int i = 0; i < 360; ++i) {
            this.backgroundCtx.save();
            if (i % 6 == 0) {
                this.backgroundCtx.setStroke((Paint)mColor);
                this.backgroundCtx.setLineWidth(strokeWidth);
                this.backgroundCtx.strokeArc(strokeWidth * 0.5 + strokeWidth * 1.1, strokeWidth * 0.5 + strokeWidth * 1.1, this.size - strokeWidth - strokeWidth * 2.2, this.size - strokeWidth - strokeWidth * 2.2, (double)(i + 1), 4.0, ArcType.OPEN);
                this.backgroundCtx.setStroke((Paint)sColor);
                this.backgroundCtx.setLineWidth(strokeWidth * 0.25);
                this.backgroundCtx.strokeArc(strokeWidth * 0.5 + strokeWidth * 1.8, strokeWidth * 0.5 + strokeWidth * 1.8, this.size - strokeWidth - strokeWidth * 3.6, this.size - strokeWidth - strokeWidth * 3.6, (double)(i + 1), 4.0, ArcType.OPEN);
            }
            if (i % 30 == 0) {
                this.backgroundCtx.setStroke((Paint)hColor);
                this.backgroundCtx.setLineWidth(strokeWidth);
                this.backgroundCtx.strokeArc(strokeWidth * 0.5, strokeWidth * 0.5, this.size - strokeWidth, this.size - strokeWidth, (double)(i + 1), 28.0, ArcType.OPEN);
            }
            this.backgroundCtx.restore();
        }
        if (this.clock.isTitleVisible()) {
            String title = this.clock.getTitle();
            int l = title.length();
            char[] bkgChrs = new char[l];
            Arrays.fill(bkgChrs, '8');
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.titleColor, 0.1));
            this.backgroundCtx.setFont(Fonts.digitalReadoutBold(0.09 * this.size));
            this.backgroundCtx.setTextBaseline(VPos.CENTER);
            this.backgroundCtx.setTextAlign(TextAlignment.CENTER);
            this.backgroundCtx.fillText(new String(bkgChrs), this.center, this.size * 0.35, this.size * 0.55);
            this.backgroundCtx.setFill((Paint)this.titleColor);
            this.backgroundCtx.fillText(title, this.center, this.size * 0.35, this.size * 0.55);
        }
        Locale locale = this.clock.getLocale();
        if (this.clock.isTextVisible()) {
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.textColor, 0.1));
            this.backgroundCtx.setTextBaseline(VPos.CENTER);
            this.backgroundCtx.setTextAlign(TextAlignment.CENTER);
            if (Locale.US == locale) {
                this.backgroundCtx.setFont(Fonts.digital(0.17 * this.size));
                this.backgroundCtx.fillText("88:88 88", this.center, this.center);
            } else {
                this.backgroundCtx.setFont(Fonts.digital(0.2 * this.size));
                this.backgroundCtx.fillText("88:88", this.center, this.center);
            }
        }
        if (this.clock.isDateVisible()) {
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.dateColor, 0.1));
            this.backgroundCtx.setFont(Fonts.digital(0.09 * this.size));
            if (Locale.US == locale) {
                this.backgroundCtx.fillText("88/88/8888", this.center, this.size * 0.65);
            } else if (Locale.CHINA == locale) {
                this.backgroundCtx.fillText("8888.88.88", this.center, this.size * 0.65);
            } else {
                this.backgroundCtx.fillText("88.88.8888", this.center, this.size * 0.65);
            }
        }
        if (this.clock.isAlarmsEnabled() && this.clock.getAlarms().size() > 0) {
            this.backgroundCtx.setFill((Paint)Helper.getTranslucentColorFrom(this.alarmColor, 0.1));
            this.drawAlarmIcon(this.backgroundCtx, this.backgroundCtx.getFill());
        }
    }

    private void drawAlarmIcon(GraphicsContext CTX, Paint COLOR) {
        double iconSize = 0.1 * this.size;
        CTX.save();
        CTX.translate((this.size - iconSize) * 0.5, this.size * 0.25);
        CTX.beginPath();
        CTX.moveTo(0.6875 * iconSize, 0.875 * iconSize);
        CTX.bezierCurveTo(0.625 * iconSize, 0.9375 * iconSize, 0.5625 * iconSize, iconSize, 0.5 * iconSize, iconSize);
        CTX.bezierCurveTo(0.4375 * iconSize, iconSize, 0.375 * iconSize, 0.9375 * iconSize, 0.375 * iconSize, 0.875 * iconSize);
        CTX.bezierCurveTo(0.375 * iconSize, 0.875 * iconSize, 0.6875 * iconSize, 0.875 * iconSize, 0.6875 * iconSize, 0.875 * iconSize);
        CTX.closePath();
        CTX.moveTo(iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.6875 * iconSize, 0.5625 * iconSize, 0.9375 * iconSize, 0.0, 0.5 * iconSize, 0.0);
        CTX.bezierCurveTo(0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0);
        CTX.bezierCurveTo(0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0, 0.5 * iconSize, 0.0);
        CTX.bezierCurveTo(0.125 * iconSize, 0.0, 0.375 * iconSize, 0.5625 * iconSize, 0.0, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.0, 0.8125 * iconSize, 0.0, 0.8125 * iconSize, 0.0625 * iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.0625 * iconSize, 0.8125 * iconSize, 0.5 * iconSize, 0.8125 * iconSize, 0.5 * iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(0.5 * iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize);
        CTX.bezierCurveTo(iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize, iconSize, 0.8125 * iconSize);
        CTX.closePath();
        CTX.setFill(COLOR);
        CTX.fill();
        CTX.restore();
    }

    @Override
    public void updateTime(ZonedDateTime TIME) {
        this.drawForeground(TIME);
        this.drawHours(TIME);
        this.drawMinutes(TIME);
        this.drawSeconds(TIME);
    }

    @Override
    public void updateAlarms() {
    }

    @Override
    protected void resize() {
        double height;
        double width = this.clock.getWidth() - this.clock.getInsets().getLeft() - this.clock.getInsets().getRight();
        this.size = width < (height = this.clock.getHeight() - this.clock.getInsets().getTop() - this.clock.getInsets().getBottom()) ? width : height;
        this.center = this.size * 0.5;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((this.clock.getWidth() - this.size) * 0.5, (this.clock.getHeight() - this.size) * 0.5);
            this.backgroundCanvas.setWidth(this.size);
            this.backgroundCanvas.setHeight(this.size);
            this.foregroundCanvas.setWidth(this.size);
            this.foregroundCanvas.setHeight(this.size);
            this.hoursCanvas.setWidth(this.size);
            this.hoursCanvas.setHeight(this.size);
            this.minutesCanvas.setWidth(this.size);
            this.minutesCanvas.setHeight(this.size);
            this.secondsCanvas.setWidth(this.size);
            this.secondsCanvas.setHeight(this.size);
            this.drawBackground();
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.clock.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(1024.0), new BorderWidths(this.clock.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.clock.getBackgroundPaint(), new CornerRadii(1024.0), Insets.EMPTY)}));
        ZonedDateTime time = this.clock.getTime();
        this.hourColor = this.clock.getHourColor();
        this.minuteColor = this.clock.getMinuteColor();
        this.fiveMinuteColor = this.minuteColor.darker();
        this.secondColor = this.clock.getSecondColor();
        this.titleColor = this.clock.getTitleColor();
        this.textColor = this.clock.getTextColor();
        this.dateColor = this.clock.getDateColor();
        this.alarmColor = this.clock.getAlarmColor();
        this.drawBackground();
        this.drawForeground(time);
        this.drawHours(time);
        this.drawMinutes(time);
        this.drawSeconds(time);
    }
}

