/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.medusa.skins;

import eu.hansolo.medusa.Fonts;
import eu.hansolo.medusa.Gauge;
import eu.hansolo.medusa.Section;
import eu.hansolo.medusa.skins.GaugeSkinBase;
import eu.hansolo.medusa.tools.Helper;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;

public class TileTextKpiSkin
extends GaugeSkinBase {
    private double size;
    private Region barBackground;
    private Rectangle barClip;
    private Rectangle bar;
    private Text titleText;
    private Text valueText;
    private Text unitText;
    private Text percentageText;
    private Text percentageUnitText;
    private Rectangle maxValueRect;
    private Text maxValueText;
    private Text maxValueUnitText;
    private Pane pane;
    private double minValue;
    private double maxValue;
    private double range;
    private double stepSize;
    private String formatString;
    private Locale locale;
    private List<Section> sections;
    private boolean sectionsVisible;
    private Color barColor;
    private InvalidationListener currentValueListener;

    public TileTextKpiSkin(Gauge gauge) {
        super(gauge);
        if (gauge.isAutoScale()) {
            gauge.calcAutoScale();
        }
        this.minValue = gauge.getMinValue();
        this.maxValue = gauge.getMaxValue();
        this.range = gauge.getRange();
        this.stepSize = 250.0 / this.range;
        this.formatString = "%." + Integer.toString(gauge.getDecimals()) + "f";
        this.locale = gauge.getLocale();
        this.sections = gauge.getSections();
        this.sectionsVisible = gauge.getSectionsVisible();
        this.barColor = gauge.getBarColor();
        this.currentValueListener = o -> this.setBar(gauge.getCurrentValue());
        this.initGraphics();
        this.registerListeners();
        this.setBar(gauge.getCurrentValue());
    }

    private void initGraphics() {
        if (Double.compare(this.gauge.getPrefWidth(), 0.0) <= 0 || Double.compare(this.gauge.getPrefHeight(), 0.0) <= 0 || Double.compare(this.gauge.getWidth(), 0.0) <= 0 || Double.compare(this.gauge.getHeight(), 0.0) <= 0) {
            if (this.gauge.getPrefWidth() > 0.0 && this.gauge.getPrefHeight() > 0.0) {
                this.gauge.setPrefSize(this.gauge.getPrefWidth(), this.gauge.getPrefHeight());
            } else {
                this.gauge.setPrefSize(250.0, 250.0);
            }
        }
        this.barBackground = new Region();
        this.barBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.gauge.getBarBackgroundColor(), new CornerRadii(0.0, 0.0, 0.025, 0.025, true), Insets.EMPTY)}));
        this.barClip = new Rectangle();
        this.bar = new Rectangle();
        this.bar.setFill((Paint)this.gauge.getBarColor());
        this.bar.setStroke(null);
        this.bar.setClip((Node)this.barClip);
        this.titleText = new Text();
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
        this.valueText = new Text();
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
        this.unitText = new Text(this.gauge.getUnit());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
        Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        this.percentageText = new Text();
        this.percentageText.setFill((Paint)this.gauge.getBarColor());
        this.percentageUnitText = new Text("%");
        this.percentageUnitText.setFill((Paint)this.gauge.getBarColor());
        this.maxValueRect = new Rectangle();
        this.maxValueRect.setFill((Paint)this.gauge.getThresholdColor());
        this.maxValueText = new Text(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMaxValue()));
        this.maxValueText.setFill(this.gauge.getBackgroundPaint());
        this.maxValueUnitText = new Text(this.gauge.getUnit());
        this.maxValueUnitText.setFill(this.gauge.getBackgroundPaint());
        this.pane = new Pane(new Node[]{this.barBackground, this.bar, this.titleText, this.valueText, this.unitText, this.percentageText, this.percentageUnitText, this.maxValueRect, this.maxValueText, this.maxValueUnitText});
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(6.25), new BorderWidths(this.gauge.getBorderWidth()))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(6.25), Insets.EMPTY)}));
        this.getChildren().setAll((Object[])new Node[]{this.pane});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.gauge.currentValueProperty().addListener(this.currentValueListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("RECALC".equals(EVENT_TYPE)) {
            this.minValue = this.gauge.getMinValue();
            this.maxValue = this.gauge.getMaxValue();
            this.range = this.gauge.getRange();
            this.stepSize = this.size / this.range;
            this.redraw();
        } else if ("VISIBLITY".equals(EVENT_TYPE)) {
            Helper.enableNode((Node)this.titleText, !this.gauge.getTitle().isEmpty());
            Helper.enableNode((Node)this.valueText, this.gauge.isValueVisible());
            Helper.enableNode((Node)this.unitText, !this.gauge.getUnit().isEmpty());
        } else if ("SECTION".equals(EVENT_TYPE)) {
            this.sections = this.gauge.getSections();
        }
    }

    private void setBar(double VALUE) {
        double targetValue = (Helper.clamp(this.minValue, this.maxValue, VALUE) - this.minValue) * this.stepSize;
        this.bar.setWidth(targetValue);
        this.valueText.setText(Helper.formatNumber(this.gauge.getLocale(), this.gauge.getFormatString(), this.gauge.getDecimals(), VALUE));
        this.percentageText.setText(String.format(this.locale, this.formatString, (VALUE - this.minValue) / this.range * 100.0));
        this.maxValueRect.setFill((Paint)(VALUE > this.maxValue ? this.barColor : this.gauge.getThresholdColor()));
        this.resizeDynamicText();
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            this.setBarColor(VALUE);
        }
    }

    private void setBarColor(double VALUE) {
        Color color = this.barColor;
        for (Section section : this.sections) {
            if (!section.contains(VALUE)) continue;
            color = section.getColor();
            break;
        }
        this.bar.setFill((Paint)color);
        this.percentageText.setFill((Paint)color);
        this.percentageUnitText.setFill((Paint)color);
    }

    @Override
    public void dispose() {
        this.gauge.currentValueProperty().removeListener(this.currentValueListener);
        super.dispose();
    }

    private void resizeDynamicText() {
        double maxWidth = this.unitText.isVisible() ? this.size * 0.725 : this.size * 0.9;
        double fontSize = 0.24 * this.size;
        this.valueText.setFont(Fonts.latoRegular(fontSize));
        if (this.valueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.valueText, maxWidth, fontSize);
        }
        if (this.unitText.isVisible()) {
            this.valueText.relocate(this.size * 0.925 - this.valueText.getLayoutBounds().getWidth() - this.unitText.getLayoutBounds().getWidth(), this.size * 0.15);
        } else {
            this.valueText.relocate(this.size * 0.95 - this.valueText.getLayoutBounds().getWidth(), this.size * 0.15);
        }
        this.percentageUnitText.relocate(this.percentageText.getLayoutBounds().getMaxX() + this.size * 0.075, this.size * 0.75);
    }

    private void resizeStaticText() {
        double maxWidth = this.size * 0.9;
        double fontSize = this.size * 0.06;
        this.titleText.setFont(Fonts.latoRegular(fontSize));
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        this.titleText.relocate(this.size * 0.05, this.size * 0.05);
        maxWidth = this.size * 0.15;
        this.unitText.setFont(Fonts.latoRegular(fontSize));
        if (this.unitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.unitText, maxWidth, fontSize);
        }
        this.unitText.relocate(this.size * 0.95 - this.unitText.getLayoutBounds().getWidth(), this.size * 0.3275);
        maxWidth = this.size * 0.45;
        fontSize = this.size * 0.18;
        this.percentageText.setFont(Fonts.latoRegular(fontSize));
        if (this.percentageText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageText, maxWidth, fontSize);
        }
        this.percentageText.relocate(this.size * 0.05, this.size * 0.695);
        maxWidth = this.size * 0.1;
        fontSize = this.size * 0.12;
        this.percentageUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.percentageUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.percentageUnitText, maxWidth, fontSize);
        }
        this.percentageUnitText.relocate(this.percentageText.getLayoutBounds().getMaxX() + this.size * 0.075, this.size * 0.75);
        maxWidth = this.size * 0.2;
        fontSize = this.size * 0.05;
        this.maxValueUnitText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueUnitText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueUnitText, maxWidth, fontSize);
        }
        this.maxValueUnitText.setX(this.size * 0.925 - this.maxValueUnitText.getLayoutBounds().getWidth());
        this.maxValueUnitText.setY(this.size * 0.855);
        maxWidth = this.size * 0.45;
        fontSize = this.size * 0.08;
        this.maxValueText.setFont(Fonts.latoRegular(fontSize));
        if (this.maxValueText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.maxValueText, maxWidth, fontSize);
        }
        if (this.unitText.isVisible()) {
            this.maxValueText.setX(this.size * 0.925 - (this.size * 0.01 + this.maxValueText.getLayoutBounds().getWidth() + this.maxValueUnitText.getLayoutBounds().getWidth()));
        } else {
            this.maxValueText.setX(this.size * 0.925 - this.maxValueText.getLayoutBounds().getWidth());
        }
        this.maxValueText.setY(this.size * 0.855);
    }

    @Override
    protected void resize() {
        double height;
        double width = this.gauge.getWidth() - this.gauge.getInsets().getLeft() - this.gauge.getInsets().getRight();
        this.size = width < (height = this.gauge.getHeight() - this.gauge.getInsets().getTop() - this.gauge.getInsets().getBottom()) ? width : height;
        this.stepSize = this.size / this.range;
        if (width > 0.0 && height > 0.0) {
            this.pane.setMaxSize(this.size, this.size);
            this.pane.relocate((width - this.size) * 0.5, (height - this.size) * 0.5);
            this.barBackground.setPrefSize(this.size, this.size * 0.035);
            this.barBackground.relocate(0.0, this.size * 0.965);
            this.barClip.setX(0.0);
            this.barClip.setY(this.size * 0.95);
            this.barClip.setWidth(this.size);
            this.barClip.setHeight(this.size * 0.05);
            this.barClip.setArcWidth(this.size * 0.025);
            this.barClip.setArcHeight(this.size * 0.025);
            this.bar.setX(0.0);
            this.bar.setY(this.size * 0.965);
            this.bar.setWidth(Helper.clamp(this.minValue, this.maxValue, this.gauge.getCurrentValue()) * this.stepSize);
            this.bar.setHeight(this.size * 0.035);
            this.resizeStaticText();
            this.resizeDynamicText();
            this.maxValueRect.setWidth(this.maxValueText.getLayoutBounds().getWidth() + this.maxValueUnitText.getLayoutBounds().getWidth() + this.size * 0.06);
            this.maxValueRect.setHeight(this.maxValueText.getLayoutBounds().getHeight() * 1.01);
            this.maxValueRect.setX(this.size * 0.95 - this.maxValueRect.getWidth());
            this.maxValueRect.setY(this.size * 0.7775);
            this.maxValueRect.setArcWidth(this.size * 0.025);
            this.maxValueRect.setArcHeight(this.size * 0.025);
        }
    }

    @Override
    protected void redraw() {
        this.pane.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.gauge.getBorderPaint(), BorderStrokeStyle.SOLID, new CornerRadii(this.size * 0.025), new BorderWidths(this.gauge.getBorderWidth() / 250.0 * this.size))}));
        this.pane.setBackground(new Background(new BackgroundFill[]{new BackgroundFill(this.gauge.getBackgroundPaint(), new CornerRadii(this.size * 0.025), Insets.EMPTY)}));
        this.locale = this.gauge.getLocale();
        this.formatString = "%." + Integer.toString(this.gauge.getDecimals()) + "f";
        this.titleText.setText(this.gauge.getTitle());
        this.percentageText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getValue() / this.range * 100.0));
        this.maxValueText.setText(String.format(this.locale, "%." + this.gauge.getTickLabelDecimals() + "f", this.gauge.getMaxValue()));
        this.maxValueUnitText.setText(this.gauge.getUnit());
        this.resizeStaticText();
        this.barBackground.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)this.gauge.getBarBackgroundColor().brighter().brighter(), new CornerRadii(0.0, 0.0, this.size * 0.025, this.size * 0.025, false), Insets.EMPTY)}));
        this.barColor = this.gauge.getBarColor();
        if (this.sectionsVisible && !this.sections.isEmpty()) {
            this.setBarColor(this.gauge.getValue());
        } else {
            this.bar.setFill((Paint)this.barColor);
        }
        this.titleText.setFill((Paint)this.gauge.getTitleColor());
        this.maxValueText.setFill(this.gauge.getBackgroundPaint());
        this.maxValueUnitText.setFill(this.gauge.getBackgroundPaint());
        this.valueText.setFill((Paint)this.gauge.getValueColor());
        this.unitText.setFill((Paint)this.gauge.getUnitColor());
    }
}

