/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.gpio.extension.ads;

import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.GpioProviderBase;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.event.PinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.PinEvent;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CDevice;
import com.pi4j.io.i2c.I2CFactory;
import java.io.IOException;
import java.util.List;

public abstract class ADS1x15GpioProvider
extends GpioProviderBase
implements GpioProvider {
    public static final String NAME = "com.pi4j.gpio.extension.ads.ADS1x15GpioProvider";
    public static final String DESCRIPTION = "ADS1x15 GPIO Provider";
    protected boolean i2cBusOwner = false;
    protected I2CBus bus;
    protected I2CDevice device;
    protected ADCMonitor monitor = null;
    protected Pin[] allPins = null;
    protected int conversionDelay = 0;
    protected short bitShift = 0;
    public static int MIN_MONITOR_INTERVAL = 1;
    public static int DEFAULT_MONITOR_INTERVAL = 100;
    protected static final int ADS1x15_REG_POINTER_MASK = 3;
    protected static final int ADS1x15_REG_POINTER_CONVERT = 0;
    protected static final int ADS1x15_REG_POINTER_CONFIG = 1;
    protected static final int ADS1x15_REG_POINTER_LOWTHRESH = 2;
    protected static final int ADS1x15_REG_POINTER_HITHRESH = 3;
    protected static final int ADS1x15_REG_CONFIG_OS_MASK = 32768;
    protected static final int ADS1x15_REG_CONFIG_OS_SINGLE = 32768;
    protected static final int ADS1x15_REG_CONFIG_OS_BUSY = 0;
    protected static final int ADS1x15_REG_CONFIG_OS_NOTBUSY = 32768;
    protected static final int ADS1x15_REG_CONFIG_MUX_MASK = 28672;
    protected static final int ADS1x15_REG_CONFIG_MUX_DIFF_0_1 = 0;
    protected static final int ADS1x15_REG_CONFIG_MUX_DIFF_0_3 = 4096;
    protected static final int ADS1x15_REG_CONFIG_MUX_DIFF_1_3 = 8192;
    protected static final int ADS1x15_REG_CONFIG_MUX_DIFF_2_3 = 12288;
    protected static final int ADS1x15_REG_CONFIG_MUX_SINGLE_0 = 16384;
    protected static final int ADS1x15_REG_CONFIG_MUX_SINGLE_1 = 20480;
    protected static final int ADS1x15_REG_CONFIG_MUX_SINGLE_2 = 24576;
    protected static final int ADS1x15_REG_CONFIG_MUX_SINGLE_3 = 28672;
    protected static final int ADS1x15_REG_CONFIG_PGA_MASK = 3584;
    protected static final int ADS1x15_REG_CONFIG_PGA_6_144V = 0;
    protected static final int ADS1x15_REG_CONFIG_PGA_4_096V = 512;
    protected static final int ADS1x15_REG_CONFIG_PGA_2_048V = 1024;
    protected static final int ADS1x15_REG_CONFIG_PGA_1_024V = 1536;
    protected static final int ADS1x15_REG_CONFIG_PGA_0_512V = 2048;
    protected static final int ADS1x15_REG_CONFIG_PGA_0_256V = 2560;
    protected static final int ADS1x15_REG_CONFIG_MODE_MASK = 256;
    protected static final int ADS1x15_REG_CONFIG_MODE_CONTIN = 0;
    protected static final int ADS1x15_REG_CONFIG_MODE_SINGLE = 256;
    protected static final int ADS1x15_REG_CONFIG_DR_MASK = 224;
    protected static final int ADS1x15_REG_CONFIG_DR_128SPS = 0;
    protected static final int ADS1x15_REG_CONFIG_DR_250SPS = 32;
    protected static final int ADS1x15_REG_CONFIG_DR_490SPS = 64;
    protected static final int ADS1x15_REG_CONFIG_DR_920SPS = 96;
    protected static final int ADS1x15_REG_CONFIG_DR_1600SPS = 128;
    protected static final int ADS1x15_REG_CONFIG_DR_2400SPS = 160;
    protected static final int ADS1x15_REG_CONFIG_DR_3300SPS = 192;
    protected static final int ADS1x15_REG_CONFIG_CMODE_MASK = 16;
    protected static final int ADS1x15_REG_CONFIG_CMODE_TRAD = 0;
    protected static final int ADS1x15_REG_CONFIG_CMODE_WINDOW = 16;
    protected static final int ADS1x15_REG_CONFIG_CPOL_MASK = 8;
    protected static final int ADS1x15_REG_CONFIG_CPOL_ACTVLOW = 0;
    protected static final int ADS1x15_REG_CONFIG_CPOL_ACTVHI = 8;
    protected static final int ADS1x15_REG_CONFIG_CLAT_MASK = 4;
    protected static final int ADS1x15_REG_CONFIG_CLAT_NONLAT = 0;
    protected static final int ADS1x15_REG_CONFIG_CLAT_LATCH = 4;
    protected static final int ADS1x15_REG_CONFIG_CQUE_MASK = 3;
    protected static final int ADS1x15_REG_CONFIG_CQUE_1CONV = 0;
    protected static final int ADS1x15_REG_CONFIG_CQUE_2CONV = 1;
    protected static final int ADS1x15_REG_CONFIG_CQUE_4CONV = 2;
    protected static final int ADS1x15_REG_CONFIG_CQUE_NONE = 3;
    protected ProgrammableGainAmplifierValue[] pga = new ProgrammableGainAmplifierValue[]{ProgrammableGainAmplifierValue.PGA_6_144V, ProgrammableGainAmplifierValue.PGA_6_144V, ProgrammableGainAmplifierValue.PGA_6_144V, ProgrammableGainAmplifierValue.PGA_6_144V};
    protected double[] threshold = new double[]{500.0, 500.0, 500.0, 500.0};
    protected double[] cachedValue = new double[]{0.0, 0.0, 0.0, 0.0};
    protected int monitorInterval = DEFAULT_MONITOR_INTERVAL;

    public ADS1x15GpioProvider(int busNumber, int address) throws I2CFactory.UnsupportedBusNumberException, IOException {
        this(I2CFactory.getInstance((int)busNumber), address);
        this.i2cBusOwner = true;
    }

    public ADS1x15GpioProvider(I2CBus bus, int address) throws IOException {
        this.bus = bus;
        this.device = bus.getDevice(address);
        this.monitor = new ADCMonitor(this.device);
        this.monitor.start();
    }

    public ProgrammableGainAmplifierValue getProgrammableGainAmplifier(Pin pin) {
        return this.pga[pin.getAddress()];
    }

    public ProgrammableGainAmplifierValue getProgrammableGainAmplifier(GpioPin pin) {
        return this.getProgrammableGainAmplifier(pin.getPin());
    }

    public void setProgrammableGainAmplifier(ProgrammableGainAmplifierValue pga, Pin ... pin) {
        for (Pin p : pin) {
            this.pga[p.getAddress()] = pga;
        }
    }

    public void setProgrammableGainAmplifier(ProgrammableGainAmplifierValue pga, GpioPin ... pin) {
        for (GpioPin p : pin) {
            this.pga[p.getPin().getAddress()] = pga;
        }
    }

    public double getEventThreshold(Pin pin) {
        return this.threshold[pin.getAddress()];
    }

    public double getEventThreshold(GpioPin pin) {
        return this.getEventThreshold(pin.getPin());
    }

    public void setEventThreshold(double threshold, Pin ... pin) {
        for (Pin p : pin) {
            this.threshold[p.getAddress()] = threshold;
        }
    }

    public void setEventThreshold(double threshold, GpioPin ... pin) {
        for (GpioPin p : pin) {
            this.setEventThreshold(threshold, p.getPin());
        }
    }

    public int getMonitorInterval() {
        return this.monitorInterval;
    }

    public void setMonitorInterval(int monitorInterval) {
        this.monitorInterval = monitorInterval;
        if (monitorInterval < MIN_MONITOR_INTERVAL) {
            monitorInterval = DEFAULT_MONITOR_INTERVAL;
        }
    }

    public abstract String getName();

    public double getImmediateValue(Pin pin) throws IOException {
        int config = 387;
        config |= this.pga[pin.getAddress()].getConfigValue();
        switch (pin.getAddress()) {
            case 0: {
                config |= 0x4000;
                break;
            }
            case 1: {
                config |= 0x5000;
                break;
            }
            case 2: {
                config |= 0x6000;
                break;
            }
            case 3: {
                config |= 0x7000;
            }
        }
        this.writeRegister(1, config |= 0x8000);
        try {
            if (this.conversionDelay > 0) {
                Thread.sleep(this.conversionDelay);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        int value = this.readRegister(0);
        this.getPinCache(pin).setAnalogValue((double)value);
        return value;
    }

    protected void writeRegister(int register, int value) throws IOException {
        byte[] packet = new byte[]{(byte)register, (byte)(value >> 8), (byte)(value & 0xFF)};
        this.device.write(packet, 0, 3);
    }

    protected int readRegister(int register) throws IOException {
        this.device.write((byte)register);
        byte[] buffer = new byte[2];
        int byteCount = 0;
        try {
            byteCount = this.device.read(buffer, 0, 2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (byteCount == 2) {
            short value = ADS1x15GpioProvider.getShort(buffer, 0);
            if (this.bitShift > 0) {
                value = (short)(value >> this.bitShift);
            }
            return value;
        }
        return 0;
    }

    protected static short getShort(byte[] arr, int off) {
        return (short)(arr[off] << 8 & 0xFF00 | arr[off + 1] & 0xFF);
    }

    protected static String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public void shutdown() {
        if (this.isShutdown()) {
            return;
        }
        super.shutdown();
        try {
            if (this.monitor != null) {
                this.monitor.shutdown();
                this.monitor = null;
            }
            if (this.i2cBusOwner) {
                this.bus.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private class ADCMonitor
    extends Thread {
        private I2CDevice device;
        private boolean shuttingDown = false;

        public ADCMonitor(I2CDevice device) {
            this.device = device;
        }

        public void shutdown() {
            this.shuttingDown = true;
        }

        @Override
        public void run() {
            while (!this.shuttingDown) {
                try {
                    byte[] buffer = new byte[1];
                    this.device.read(buffer, 0, 1);
                    if (ADS1x15GpioProvider.this.allPins != null && ADS1x15GpioProvider.this.allPins.length > 0) {
                        for (Pin pin : ADS1x15GpioProvider.this.allPins) {
                            try {
                                double oldValue = ADS1x15GpioProvider.this.cachedValue[pin.getAddress()];
                                double newValue = ADS1x15GpioProvider.this.getImmediateValue(pin);
                                if (Math.abs(oldValue - newValue) > ADS1x15GpioProvider.this.threshold[pin.getAddress()]) {
                                    ADS1x15GpioProvider.this.cachedValue[pin.getAddress()] = newValue;
                                    ADS1x15GpioProvider.this.getPinCache(pin).setAnalogValue(newValue);
                                    if (ADS1x15GpioProvider.this.getMode(pin) == PinMode.ANALOG_INPUT) {
                                        this.dispatchPinChangeEvent(pin.getAddress(), newValue);
                                    }
                                }
                                try {
                                    if (ADS1x15GpioProvider.this.conversionDelay <= 0) continue;
                                    Thread.sleep(ADS1x15GpioProvider.this.conversionDelay);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    Thread.currentThread();
                    Thread.sleep(ADS1x15GpioProvider.this.monitorInterval);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        private void dispatchPinChangeEvent(int pinAddress, double value) {
            for (Pin pin : ADS1x15GpioProvider.this.listeners.keySet()) {
                if (pin.getAddress() != pinAddress) continue;
                for (PinListener listener : (List)ADS1x15GpioProvider.this.listeners.get(pin)) {
                    listener.handlePinEvent((PinEvent)new PinAnalogValueChangeEvent((Object)this, pin, value));
                }
            }
        }
    }

    public static enum ProgrammableGainAmplifierValue {
        PGA_6_144V(6.144, 0),
        PGA_4_096V(4.096, 512),
        PGA_2_048V(2.048, 1024),
        PGA_1_024V(1.024, 1536),
        PGA_0_512V(0.512, 2048),
        PGA_0_256V(0.256, 2560);

        private double voltage = 6.144;
        private int configValue = 0;

        private ProgrammableGainAmplifierValue(double voltage, int configValue) {
            this.voltage = voltage;
            this.configValue = configValue;
        }

        public double getVoltage() {
            return this.voltage;
        }

        public int getConfigValue() {
            return this.configValue;
        }
    }
}

