/*
 * Decompiled with CFR 0.152.
 */
package Control;

import ControlSerial.CommFormat;
import Data.SystemData;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;

public class MainCommThread
extends Thread {
    int transmitNumber = 0;
    boolean threadSts = true;
    private boolean otherTxStart = false;

    public MainCommThread() {
        System.out.println("MainCommThread Create...");
    }

    public void threadExit() {
        this.threadSts = false;
    }

    @Override
    public void run() {
        System.out.println("MainCommThread Start...");
        new Thread(() -> {
            while (this.threadSts) {
                Platform.runLater(() -> {});
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SystemData systemData = SystemData.getInstance();
            }
        }).start();
        while (this.threadSts) {
            try {
                SystemData sysData = SystemData.getInstance();
                StringBuilder txStr = new StringBuilder("");
                sysData.comm.setTransmitNumber(this.transmitNumber);
                if (sysData.comm.getTxArrayLen() > 0 && sysData.comm.comPort) {
                    CommFormat fmt = sysData.comm.getTxArray(0);
                    txStr.append(fmt.makeString(this.transmitNumber));
                    sysData.comm.setTransmitFuncNumber(fmt.getFuncCode());
                    System.out.println(txStr);
                    this.otherTxStart = true;
                } else if (!sysData.commKind) {
                    sysData.comm.setTransmitFuncNumber(1);
                    txStr.append(String.format("<00010101%d,1234>", this.transmitNumber));
                } else {
                    sysData.comm.setTransmitFuncNumber(1);
                    txStr.append(String.format("<00020101%d,1234>", this.transmitNumber));
                }
                if (sysData.comm.comPort) {
                    sysData.comm.SerialClass.CommOut(txStr.toString());
                }
                if (!sysData.commKind) {
                    Thread.sleep(250L);
                } else {
                    Thread.sleep(200L);
                }
                if (sysData.comm.commCompare()) {
                    Platform.runLater(() -> sysData.mainScreen.onLabel());
                    sysData.comStatus = true;
                    ++this.transmitNumber;
                    if (this.transmitNumber > 9999) {
                        this.transmitNumber = 1;
                    }
                    if (!this.otherTxStart || sysData.comm.getTxArrayLen() <= 0) continue;
                    sysData.comm.removeTxArray(0);
                    this.otherTxStart = false;
                    continue;
                }
                sysData.comStatus = false;
                System.out.println("Board1 Comm Error Cnt=" + sysData.comm.getTransmitNumber() + " Func=" + sysData.comm.getTransmitFuncNumber());
                Platform.runLater(() -> sysData.mainScreen.offLabel());
                if (!sysData.comm.comPort) continue;
                sysData.comm.SerialClass.CommOut(txStr.toString());
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MainCommThread.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

