/*
 * Decompiled with CFR 0.152.
 */
package Control;

import Data.SystemData;
import Utility.SongUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class SWUpdateFXMLController
implements Initializable {
    private Stage myStage;
    private Scene myScene;
    SystemData sysData;
    @FXML
    private Button closeBtn;
    @FXML
    private Label title;
    @FXML
    private Label infoLabel1;
    @FXML
    private Label infoLabel2;
    @FXML
    private Button upDateBtn;
    @FXML
    private Button usbBtn;
    @FXML
    private Button rebootBtn;
    private static final boolean moveUse = true;
    private static double xOffset = 0.0;
    private static double yOffset = 0.0;
    @FXML
    private AnchorPane titleAnchorPane;

    public SWUpdateFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("SWUpdateFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == SWUpdateFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myStage = new Stage();
            this.myScene = new Scene(root);
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.sysData = SystemData.getInstance();
        }
        catch (IOException ex) {
            System.out.println("SWUpdateFXML Windows Load Error");
        }
    }

    @FXML
    void titleAnchorPanePressed(MouseEvent event) {
        xOffset = event.getSceneX();
        yOffset = event.getSceneY();
    }

    @FXML
    void titleAnchorPaneDragged(MouseEvent event) {
        this.myStage.setX(event.getScreenX() - xOffset);
        this.myStage.setY(event.getScreenY() - yOffset);
    }

    public void show() {
        this.myStage.showAndWait();
    }

    @FXML
    void closeBtnOnAction(ActionEvent event) {
        this.sysData.keyProcess(1);
        this.close();
    }

    @FXML
    void rebootBtnOnAction(ActionEvent event) {
        SongUtil.systemExec("sudo reboot");
    }

    @FXML
    void usbBtnOnAction(ActionEvent event) {
        this.sysData.keyProcess(1);
        try {
            this.fileCheck();
        }
        catch (IOException ex) {
            Logger.getLogger(SWUpdateFXMLController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void dirCopy() {
        File[] listOfFiles;
        File folder = new File("/media/usb0/resources");
        for (File file : listOfFiles = folder.listFiles()) {
            if (!file.isFile()) continue;
            String dest = "/home/pi/NetBeansProjects/Fermenter/" + file.getName();
            SongUtil.fileCopy(file.getPath(), dest);
        }
    }

    @FXML
    void upDateBtnOnAction(ActionEvent event) {
        try {
            if (this.fileCheck()) {
                SongUtil.fileCopy("/media/usb0/Fermenter.jar", "/home/pi/NetBeansProjects/Fermenter/dist/Fermenter.jar");
                this.infoLabel1.setText("\uc5c5\ub370\uc774\ud2b8\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                this.infoLabel1.setStyle("-fx-text-fill:orange");
                this.infoLabel2.setText("\uc2dc\uc2a4\ud15c\uc744 \uc7ac\uc2dc\uc791 \ud558\uc2ed\uc2dc\uc694..");
                this.infoLabel2.setStyle("-fx-text-fill:red");
                this.upDateBtn.setDisable(true);
                this.usbBtn.setDisable(true);
                this.rebootBtn.setDisable(false);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(SWUpdateFXMLController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void close() {
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean fileCheck() throws IOException {
        File file = new File("/media/usb0/usbconfirm_ziontech.zion");
        boolean isExists = file.exists();
        if (isExists) {
            this.infoLabel1.setText("USB\uac00 \uc5f0\uacb0\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.");
            this.infoLabel1.setStyle("-fx-text-fill:yellow");
            this.infoLabel2.setText("USB\ub97c \uc5f0\uacb0\ud558\uace0 Check\ubc84\ud2bc\uc73c\ub85c \ud655\uc778\ud6c4 Update\ubc84\ud2bc\uc744 \ub204\ub974\uc138\uc694.");
            this.upDateBtn.setDisable(true);
            return false;
        }
        file = new File("/media/usb0/Fermenter.jar");
        isExists = file.exists();
        if (isExists) {
            FileInputStream input = null;
            try {
                byte[] data = new byte[1024];
                input = new FileInputStream("/media/usb0/Fermenter.jar");
                input.read(data);
                input.close();
                this.infoLabel1.setText("USB\uc5d0 \uc5c5\ub370\uc774\ud2b8\ud560 \ud504\ub85c\uadf8\ub7a8\uc774 \uc788\uc2b5\ub2c8\ub2e4.");
                this.infoLabel1.setStyle("-fx-text-fill:yellow");
                this.infoLabel2.setText("UpDate \ubc84\ud2bc\uc744 \ub204\ub974\uba74 \uc5c5\ub370\uc774\ud2b8 \ub429\ub2c8\ub2e4.");
                this.upDateBtn.setDisable(false);
                boolean bl = true;
                return bl;
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(SWUpdateFXMLController.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SWUpdateFXMLController.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.infoLabel1.setText("USB\ub294 \uc5f0\uacb0\ub418\uc5b4\uc788\uc9c0\ub9cc SW\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        this.infoLabel2.setText("\uc5c5\uadf8\ub808\uc774\ub4dc \ud560\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        return false;
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.rebootBtn.setDisable(true);
        try {
            this.fileCheck();
        }
        catch (IOException ex) {
            Logger.getLogger(SWUpdateFXMLController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

