/*
 * Decompiled with CFR 0.152.
 */
package ControlSerial;

import ControlSerial.DataParsingEvent;
import jssc.SerialPort;
import jssc.SerialPortEvent;
import jssc.SerialPortEventListener;
import jssc.SerialPortException;
import jssc.SerialPortList;

public class JSSCSerial {
    boolean serialStatus = false;
    public SerialPort serialPort = null;
    StringBuffer serialBuf = new StringBuffer("");
    int start = -1;
    int end = -1;
    int receive_cnt = 0;
    boolean receive = false;
    private DataParsingEvent parsingEvent;

    public JSSCSerial(String port, DataParsingEvent evt) {
        this.parsingEvent = evt;
        this.serialConnect(port);
    }

    public JSSCSerial(String port) {
        this.serialConnect(port);
    }

    public void eventReg(DataParsingEvent evt) {
        this.parsingEvent = evt;
    }

    public boolean getStatus() {
        return this.serialStatus;
    }

    public SerialPort getSerialPort() {
        return this.serialPort;
    }

    public void serialConnect(String port) {
        this.serialStatus = false;
        this.serialPort = new SerialPort(port);
        try {
            this.serialPort.openPort();
            this.serialPort.setParams(115200, 8, 1, 0);
            this.serialPort.setFlowControlMode(0);
            this.serialPort.addEventListener((SerialPortEventListener)new PortReader(), 1);
            this.serialStatus = true;
        }
        catch (SerialPortException ex) {
            this.serialStatus = false;
            System.out.println("JSSC Serial Open Error");
        }
    }

    public void serialClose() {
        try {
            if (this.serialPort != null) {
                this.serialPort.removeEventListener();
                this.serialPort.closePort();
                this.serialPort = null;
                this.serialStatus = false;
            }
        }
        catch (SerialPortException ex) {
            System.out.println("Serial Close Error");
        }
    }

    public synchronized void CommOut(String str) {
        try {
            if (this.serialPort.isOpened()) {
                if (this.serialStatus) {
                    try {
                        this.serialPort.writeString(str);
                    }
                    catch (SerialPortException ex) {
                        System.out.println("Err Comm");
                    }
                }
            } else {
                this.serialStatus = false;
            }
        }
        catch (IllegalStateException ex) {
            System.out.println("CommOut Exception");
        }
    }

    public int commParsing(String rStr) {
        if (rStr.charAt(0) != '<') {
            System.out.println("commParsing::Start Code Error");
            return 0;
        }
        try {
            String saddr = rStr.substring(1, 5);
            String scommand = rStr.substring(5, 7);
            String slen = rStr.substring(7, 9);
            String sdata = rStr.substring(9, rStr.length() - 6);
            String scrc = rStr.substring(rStr.length() - 5, rStr.length() - 1);
            if (!scrc.equals("1234")) {
                System.out.println("commParsing::CRC Code Error");
                return 0;
            }
            int addr = Integer.parseInt(saddr);
            int command = Integer.parseInt(scommand);
            int len = Integer.parseInt(slen);
            if (addr < 1000 && addr > 9999) {
                System.out.println("commParsing::address Error");
                return 0;
            }
            if (command < 0 && command > 10) {
                System.out.println("commParsing::command Error");
                return 0;
            }
            if (len < 0 && len > 100) {
                System.out.println("commParsing::len Error");
                return 0;
            }
            if (this.parsingEvent != null) {
                this.parsingEvent.parsing(addr, command, len, sdata);
            } else {
                System.out.println("Parsing Event Null");
            }
        }
        catch (Exception e) {
            System.out.println("commParsing::Exception Occur");
        }
        return 1;
    }

    public static void main(String[] args) {
        String[] portNames = SerialPortList.getPortNames();
        if (portNames.length == 0) {
            System.out.println("Com Port Not Found");
            return;
        }
        System.out.println("Available com-ports:");
        for (String portName : portNames) {
            System.out.println(portName);
        }
    }

    private class PortReader
    implements SerialPortEventListener {
        StringBuffer serial_buf = new StringBuffer("");

        private PortReader() {
        }

        public void serialEvent(SerialPortEvent event) {
            if (event.isRXCHAR() && event.getEventValue() > 0) {
                try {
                    String receivedData = JSSCSerial.this.serialPort.readString(event.getEventValue());
                    try {
                        this.serial_buf.setLength(0);
                        int len = event.getEventValue();
                        this.serial_buf.append(receivedData);
                        for (int i = 0; i < len; ++i) {
                            if (this.serial_buf.charAt(i) == '<') {
                                JSSCSerial.this.start = i;
                                if (JSSCSerial.this.start < 0) continue;
                                JSSCSerial.this.receive = true;
                                JSSCSerial.this.serialBuf.setLength(0);
                                JSSCSerial.this.serialBuf.append(this.serial_buf, JSSCSerial.this.start, event.getEventValue());
                                JSSCSerial.this.start = -1;
                                continue;
                            }
                            if (this.serial_buf.charAt(i) != '>') continue;
                            JSSCSerial.this.end = i;
                            if (JSSCSerial.this.start != -1) continue;
                            JSSCSerial.this.serialBuf.setLength(0);
                            JSSCSerial.this.serialBuf.append(this.serial_buf, 0, JSSCSerial.this.end + 1);
                        }
                    }
                    catch (Exception e) {
                        System.out.println("JSSC->String Parsing Error");
                    }
                    if (JSSCSerial.this.receive) {
                        if (JSSCSerial.this.end >= 0) {
                            try {
                                if (JSSCSerial.this.start == -2) {
                                    JSSCSerial.this.serialBuf.append(this.serial_buf, 0, JSSCSerial.this.end + 1);
                                }
                                JSSCSerial.this.commParsing(JSSCSerial.this.serialBuf.toString());
                                JSSCSerial.this.start = -1;
                                JSSCSerial.this.end = -1;
                                JSSCSerial.this.receive = false;
                                JSSCSerial.this.serialBuf.setLength(0);
                                JSSCSerial.this.receive_cnt = 0;
                            }
                            catch (Exception e) {
                                JSSCSerial.this.start = -1;
                                JSSCSerial.this.end = -1;
                                JSSCSerial.this.receive = false;
                                JSSCSerial.this.serialBuf.setLength(0);
                                JSSCSerial.this.receive_cnt = 0;
                            }
                        } else {
                            if (JSSCSerial.this.start == -1) {
                                JSSCSerial.this.start = -2;
                            } else {
                                JSSCSerial.this.serialBuf.append(this.serial_buf);
                            }
                            if (JSSCSerial.this.serialBuf.length() > 1024) {
                                System.out.println("JSSC::Over Receive Comm Init==>");
                                JSSCSerial.this.start = -1;
                                JSSCSerial.this.end = -1;
                                JSSCSerial.this.receive = false;
                                JSSCSerial.this.serialBuf.setLength(0);
                                JSSCSerial.this.receive_cnt = 0;
                            }
                        }
                    }
                }
                catch (SerialPortException ex) {
                    System.out.println("Error in receiving response from port: " + (Object)((Object)ex));
                }
            }
        }
    }
}

