/*
 * Decompiled with CFR 0.152.
 */
package Data;

import Utility.SongUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ADataBase {
    private Connection conn = null;
    private ResultSet rs = null;
    private PreparedStatement pst = null;
    private boolean isOpen = false;
    private String dbFileName;

    public Connection getConnection() {
        return this.conn;
    }

    public PreparedStatement getPst() {
        return this.pst;
    }

    public void dBconnect(String filename) throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        String url = "jdbc:sqlite:" + filename;
        this.conn = DriverManager.getConnection(url);
        try {
            if (this.conn != null) {
                DatabaseMetaData meta = this.conn.getMetaData();
                System.out.println("DataBase The driver name is " + meta.getDriverName());
                this.dbFileName = filename;
                this.isOpen = true;
            }
        }
        catch (SQLException ex) {
            System.out.println("DataBase Open Error!");
        }
    }

    public void close() {
        try {
            if (this.isOpen) {
                this.conn.close();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(ADataBase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void dBTableCreate(String tableName, String item) {
        if (this.conn != null) {
            String sql = "CREATE TABLE IF NOT EXISTS " + tableName + " (" + item + ");";
            try {
                this.pst = this.conn.prepareStatement(sql);
                this.pst.execute();
            }
            catch (SQLException ex) {
                System.out.println("\t=====>dBTableCreate:" + tableName + " Exception occur");
            }
        }
    }

    public void dBTableCreate(String tableName) {
        if (this.conn != null) {
            String sql = "CREATE TABLE IF NOT EXISTS " + tableName + "(Date text, Temp text, Humi text, CO2 text, CO text,TVOC text, Dust10 text, Dust25 text, Dust01 text,HCHO text, NO2 text, O3 text,NH3 text,Light text ,Sound text, Motion text );";
            try {
                this.pst = this.conn.prepareStatement(sql);
                this.pst.execute();
                System.out.println("table Create OK");
            }
            catch (SQLException ex) {
                System.out.println("table Create Exception");
            }
        }
    }

    public void dBTableDelete(String dbName) {
        if (this.conn != null) {
            String sql = "DROP TABLE " + dbName + " ";
            try {
                this.pst = this.conn.prepareStatement(sql);
                this.pst.execute();
            }
            catch (SQLException ex) {
                System.out.println("\uc9c0\uc6cc\uc57c\ud560 \ud14c\uc774\ube14\uc774 \uc5c6\uc74c");
            }
        }
    }

    public void getDBTable() {
        try {
            DatabaseMetaData dbMetaData = this.conn.getMetaData();
            ResultSet catalogs = dbMetaData.getCatalogs();
            while (catalogs.next()) {
                String catalogName = catalogs.getString(3);
                System.out.println(catalogName);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(ADataBase.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void dBDataSave(String tablename, String data) {
        String item = "Date, Temp, Humi, CO2, CO, TVOC, Dust10, Dust25, Dust01, HCHO, NO2, O3, NH3, Light, Sound, Motion";
        if (this.conn != null) {
            StringBuilder value = new StringBuilder("values(");
            StringTokenizer st = new StringTokenizer(item, ",");
            int count = st.countTokens();
            for (int i = 0; i < count - 1; ++i) {
                String cell = "?,";
                value.append(cell);
            }
            String cell = "?);";
            value.append(cell);
            String sql = "INSERT INTO " + tablename + " (" + item + ") " + value;
            try {
                this.pst = this.conn.prepareStatement(sql);
            }
            catch (SQLException ex) {
                System.out.println("SQL Table dBDataSave Save Error 1");
            }
            StringTokenizer stData = new StringTokenizer(data, ",");
            int dataLen = stData.countTokens();
            String str = SongUtil.nowDateTimeToFormatString();
            try {
                this.pst.setString(1, str);
                for (int i = 2; i < dataLen; ++i) {
                    String st1 = stData.nextToken().trim();
                    this.pst.setString(i, st1);
                }
                this.pst.execute();
            }
            catch (SQLException ex) {
                Logger.getLogger(ADataBase.class.getName()).log(Level.SEVERE, null, ex);
                System.out.println("SQL Table dBDataSave Save Error 2");
            }
        }
    }

    public void dbDataDisplay(String tablename) {
        try {
            int cnt = 0;
            String sql = "select * from " + tablename;
            this.pst = this.conn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                ++cnt;
                System.out.println("Date=" + this.rs.getString("Date") + "Time=" + this.rs.getString("Time") + "pH=" + this.rs.getString("pH"));
            }
        }
        catch (SQLException ex) {
            System.out.println("DB Read Exception occur");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long tableDisplay(String tablename, String start, String end) {
        long cnt = 0L;
        try {
            String sql = "select * from " + tablename + " where Date >= '" + start + "' and Date <= '" + end + "'";
            this.pst = this.conn.prepareStatement(sql);
            this.rs = this.pst.executeQuery();
            while (this.rs.next()) {
                ++cnt;
                String data = this.rs.getString("Date");
                System.out.println(data);
            }
            if (cnt <= 0L) return cnt;
        }
        catch (SQLException ex) {
            System.out.println("tableDisplay Error");
        }
        return cnt;
    }

    void allClear(String tablename) {
        try {
            String sql = "delete from " + tablename;
            this.pst = this.conn.prepareStatement(sql);
            this.pst.execute();
        }
        catch (SQLException ex) {
            System.out.println("Table All Clear");
        }
    }
}

