/*
 * Decompiled with CFR 0.152.
 */
package Data;

import Control.MainCommThread;
import ControlSerial.SystemComm;
import Data.ADataBase;
import Data.SystemSensor;
import Utility.DS1302;
import Utility.Dial;
import Utility.FanControl;
import Utility.LcdPower;
import Utility.SongUtil;
import Utility.Voice;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.stage.Stage;
import main.MainScreenController;

public class SystemData {
    private static SystemData instance;
    public Voice sound;
    public DS1302 rtcClock;
    public FanControl fanControl;
    public LcdPower lcdControl;
    public Dial dial;
    public SystemSensor sensor;
    public SystemComm comm;
    public String osName;
    public Stage primaryStage = null;
    public int LCD_X = 1024;
    public int LCD_Y = 768;
    public int comportIndex = 0;
    public volatile int receiveFlag = 0;
    public MainCommThread mainCommThread;
    public MainScreenController mainScreen;
    public ADataBase dataBase = new ADataBase();
    public boolean commKind = false;
    public volatile boolean connect = false;
    public volatile boolean comStatus = false;
    public volatile int soundNumber = 1;
    public volatile boolean soundStart = false;
    public volatile StringBuilder fileName = new StringBuilder("DataLog.csv");
    public volatile int intervalTime = 10;
    public volatile int autoStart = 1;

    public static synchronized SystemData getInstance() {
        if (instance == null) {
            try {
                instance = new SystemData();
            }
            catch (ClassNotFoundException | SQLException ex) {
                Logger.getLogger(SystemData.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.out.println("\uc2dc\uc2a4\ud15c\uc804\uc5ed\uc774 \uc0dd\uc131\ub428.");
        }
        return instance;
    }

    private void systemInit() {
    }

    public void keyProcess(int sound_no) {
        if (this.osName.equals("Linux")) {
            this.soundStart = true;
            this.soundNumber = sound_no;
            this.lcdControl.touchPress();
            this.sound.play(1);
        }
    }

    public void dataSave() {
        try {
            FileOutputStream output = new FileOutputStream("data.txt");
            String data = this.fileName.toString() + "," + this.intervalTime + "," + this.autoStart;
            output.write(data.getBytes());
            output.close();
        }
        catch (FileNotFoundException ex) {
            System.out.println("dataSave Exception---1");
        }
        catch (IOException ex) {
            System.out.println("dataSave Exception---2");
        }
    }

    public void dataLoad() {
        File file = new File("data.txt");
        boolean isExists = file.exists();
        if (isExists) {
            try {
                byte[] data = new byte[4096];
                FileInputStream input = new FileInputStream("data.txt");
                input.read(data);
                input.close();
                String token = new String(data);
                StringTokenizer st = new StringTokenizer(token, ",");
                this.fileName.setLength(0);
                this.fileName.append(st.nextToken().trim());
                this.intervalTime = Integer.parseInt(st.nextToken().trim());
                this.autoStart = Integer.parseInt(st.nextToken().trim());
            }
            catch (IOException data) {
            }
            catch (Exception e) {
                System.out.println("dataLoad \uc2dc\uc5d0 \uc608\uc678\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc\uc800\uc7a5\ud569\ub2c8\ub2e4");
                this.dataSave();
            }
        } else {
            System.out.println("data.txt \ud30c\uc77c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc\uc800\uc7a5\ud569\ub2c8\ub2e4.");
            this.dataSave();
        }
    }

    private SystemData() throws ClassNotFoundException, SQLException {
        this.sensor = new SystemSensor();
        this.comm = new SystemComm();
        this.osName = SongUtil.osRead();
        this.dataBase.dBconnect("sensorData.db");
        this.dataLoad();
        this.systemInit();
        if (this.osName.equals("Linux")) {
            this.sound = Voice.getInstance();
            this.rtcClock = DS1302.getInstance();
            this.fanControl = FanControl.getInstance();
            this.lcdControl = LcdPower.getInstance();
            this.dial = Dial.getInstance();
        }
    }
}

