/*
 * Decompiled with CFR 0.152.
 */
package DialogBox;

import Utility.ToastMessage;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class ColorSelectFXMLController
implements Initializable {
    @FXML
    private ImageView icon;
    @FXML
    private Label title;
    @FXML
    private ImageView closeIcon;
    @FXML
    private AnchorPane topAnchorPane;
    @FXML
    private AnchorPane lanchor;
    @FXML
    private AnchorPane ranchor;
    @FXML
    private AnchorPane banchor;
    @FXML
    private AnchorPane centerAnchor;
    @FXML
    private AnchorPane colorAnchor;
    @FXML
    private Button applyBtn;
    String color = null;
    private static boolean moveUse = true;
    private static double xOffset = 0.0;
    private static double yOffset = 0.0;
    private Stage myStage;
    private Scene myScene;
    boolean threadStatus = true;

    public ColorSelectFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("ColorSelectFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == ColorSelectFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.initStyle(StageStyle.UNDECORATED);
            this.myStage.setScene(this.myScene);
        }
        catch (IOException ex) {
            System.out.println("ColorSelectFXML Windows Load Error");
        }
    }

    public void setTitleStyle(String style) {
        this.title.setStyle(style);
    }

    public void setIcon(String icon) {
        this.closeIcon.setImage(new Image(this.getClass().getResource("/resources/exit32_orange.png").toString()));
    }

    @FXML
    void topAnchorPanePressed(MouseEvent event) {
        if (moveUse) {
            xOffset = event.getSceneX();
            yOffset = event.getSceneY();
        }
    }

    @FXML
    void topAnchorPaneDragged(MouseEvent event) {
        if (moveUse) {
            this.myStage.setX(event.getScreenX() - xOffset);
            this.myStage.setY(event.getScreenY() - yOffset);
        }
    }

    @FXML
    void closeIconPressed(MouseEvent event) {
        this.closeIcon.setImage(new Image(this.getClass().getResource("/resources/exit32_orange.png").toString()));
    }

    @FXML
    void closeIconReleased(MouseEvent event) {
        this.closeIcon.setImage(new Image(this.getClass().getResource("/resources/exit32_blue.png").toString()));
    }

    @FXML
    void closeIconClicked(MouseEvent event) {
        this.close();
    }

    public String show() {
        this.myStage.showAndWait();
        if (this.color != null) {
            return this.color;
        }
        return "noColor";
    }

    void close() {
        this.threadExit();
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }

    public void setPosition(double x, double y) {
        this.myStage.setX(x);
        this.myStage.setY(y);
    }

    public void moveWindow(boolean sts) {
        moveUse = sts;
    }

    void threadExit() {
        this.threadStatus = false;
    }

    public void setTitle(String str) {
        this.title.setText(str);
    }

    public void changeBorderColor() {
        String style = "-fx-background-color: #d0d0d0";
        this.topAnchorPane.setStyle(style);
        this.banchor.setStyle(style);
        this.lanchor.setStyle(style);
        this.ranchor.setStyle(style);
    }

    void hiddenAction() {
        this.closeIcon.setImage(new Image(this.getClass().getResource("/resources/exit32_gray.png").toString()));
        this.topAnchorPane.setStyle("-fx-background-color: #b0b0b0");
        this.banchor.setStyle("-fx-background-color: #b0b0b0");
        this.lanchor.setStyle("-fx-background-color: #b0b0b0");
        this.ranchor.setStyle("-fx-background-color: #b0b0b0");
    }

    void restoreAction() {
        this.closeIcon.setImage(new Image(this.getClass().getResource("/resources/exit32_blue.png").toString()));
        this.changeBorderColor();
    }

    @FXML
    void applyBtnOnAction(ActionEvent event) {
        ToastMessage.out("\uc801\uc6a9\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
    }

    public void initialize(URL url, ResourceBundle rb) {
        final ColorPicker colorPicker = new ColorPicker();
        colorPicker.setValue((Object)Color.CORAL);
        colorPicker.setPrefWidth(300.0);
        colorPicker.setOnAction(new EventHandler(){

            public void handle(Event t) {
                String color2;
                System.out.println("Color = " + colorPicker.getValue());
                String color1 = ((Color)colorPicker.getValue()).toString();
                ColorSelectFXMLController.this.color = color2 = color1.replace("0x", "#");
                ColorSelectFXMLController.this.colorAnchor.setStyle("-fx-background-color:" + color2);
            }
        });
        this.centerAnchor.getChildren().addAll((Object[])new Node[]{colorPicker});
    }
}

