/*
 * Decompiled with CFR 0.152.
 */
package DialogBox;

import Data.SystemData;
import Data.SystemEnum;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ConfirmFXMLController
implements Initializable {
    @FXML
    private Label title;
    @FXML
    private Label infoText;
    @FXML
    private Button abortBtn;
    @FXML
    private Button okBtn;
    private Stage myStage;
    private Scene myScene;
    SystemEnum.ChannelStatus chSts = SystemEnum.ChannelStatus.CH1;
    boolean threadStatus = true;
    boolean retStatus = true;
    SystemData sysData = SystemData.getInstance();

    public ConfirmFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("ConfirmFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == ConfirmFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
        }
        catch (IOException ex) {
            System.out.println("ConfirmFXML Windows Load Error");
        }
    }

    @FXML
    void abortBtnOnAction(ActionEvent event) {
        this.retStatus = false;
        this.close();
    }

    @FXML
    void okBtnOnAction(ActionEvent event) {
        this.sysData.sound.play(1);
        this.retStatus = true;
        this.close();
    }

    public boolean show() {
        this.myStage.showAndWait();
        return this.retStatus;
    }

    public void setChanel(SystemEnum.ChannelStatus ch) {
        this.chSts = ch;
    }

    void close() {
        this.threadExit();
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }

    void threadExit() {
        this.threadStatus = false;
    }

    public void setInfo(String str) {
        this.infoText.setText(str);
    }

    public void setTitle(String str) {
        this.title.setText(str);
    }

    public void initialize(URL url, ResourceBundle rb) {
    }
}

