/*
 * Decompiled with CFR 0.152.
 */
package DialogBox;

import Data.SystemData;
import Data.SystemEnum;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class InfoFXMLController
implements Initializable {
    @FXML
    private ImageView closeIcon;
    @FXML
    private Label title;
    @FXML
    private Label infoText;
    @FXML
    private Label infoText1;
    @FXML
    private Button closeBtn;
    private Stage myStage;
    private Scene myScene;
    SystemEnum.ChannelStatus chSts = SystemEnum.ChannelStatus.CH1;
    boolean threadStatus = true;
    SystemData sysData = SystemData.getInstance();
    private static final boolean moveUse = true;
    private static double xOffset = 0.0;
    private static double yOffset = 0.0;
    @FXML
    private AnchorPane titleAnchorPane;

    public InfoFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("InfoFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == InfoFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.initStyle(StageStyle.UNDECORATED);
            this.myStage.setScene(this.myScene);
        }
        catch (IOException ex) {
            System.out.println("InfoFXML Windows Load Error");
        }
    }

    @FXML
    void titleAnchorPanePressed(MouseEvent event) {
        xOffset = event.getSceneX();
        yOffset = event.getSceneY();
    }

    @FXML
    void titleAnchorPaneDragged(MouseEvent event) {
        this.myStage.setX(event.getScreenX() - xOffset);
        this.myStage.setY(event.getScreenY() - yOffset);
    }

    @FXML
    void closeIconPressed(MouseEvent event) {
        this.sysData.sound.play(1);
        this.closeIcon.setImage(new Image(this.getClass().getResource("/resources/exit32_orange.png").toString()));
    }

    @FXML
    void closeIconReleased(MouseEvent event) {
        this.closeIcon.setImage(new Image(this.getClass().getResource("/resources/exit32_blue.png").toString()));
        this.close();
    }

    @FXML
    void closeBtnOnAction(ActionEvent event) {
        this.sysData.sound.play(1);
        this.close();
    }

    public void show() {
        this.myStage.showAndWait();
    }

    public void setChanel(SystemEnum.ChannelStatus ch) {
        this.chSts = ch;
    }

    void close() {
        this.threadExit();
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }

    void threadExit() {
        this.threadStatus = false;
    }

    public void setInfo(String str) {
        this.infoText.setText(str);
    }

    public void setInfo1(String str) {
        this.infoText1.setText(str);
    }

    public void setTitle(String str) {
        this.title.setText(str);
    }

    public void helpMain() {
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.helpMain();
    }
}

