/*
 * Decompiled with CFR 0.152.
 */
package DialogBox;

import Data.SystemData;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class KeyPadController3D
implements Initializable {
    private Stage myStage;
    private Scene myScene;
    SystemData sysData = SystemData.getInstance();
    private boolean firstInput = true;
    private static double xOffset = 0.0;
    private static double yOffset = 0.0;
    String titlename;
    StringBuffer inputText = new StringBuffer("");
    StringBuffer passwordText = new StringBuffer("");
    int dot_flag = 0;
    int minus_flag = 0;
    int input_cnt = 15;
    int dot_after_cnt = 0;
    double min_range_f = 0.0;
    double max_range_f = 1.0E9;
    boolean password = false;
    private String textValue;
    @FXML
    private AnchorPane anchor;
    @FXML
    private Text title;
    @FXML
    private ImageView clrBtn;
    @FXML
    private ImageView backBtn;
    @FXML
    private ImageView sevenBtn;
    @FXML
    private ImageView eightBtn;
    @FXML
    private ImageView nineBtn;
    @FXML
    private ImageView fourBtn;
    @FXML
    private ImageView fiveBtn;
    @FXML
    private ImageView sixBtn;
    @FXML
    private ImageView oneBtn;
    @FXML
    private ImageView twoBtn;
    @FXML
    private ImageView threeBtn;
    @FXML
    private ImageView minusBtn;
    @FXML
    private ImageView zeroBtn;
    @FXML
    private ImageView dotBtn;
    @FXML
    private ImageView entBtn;
    @FXML
    private TextField textInput;
    @FXML
    private ImageView closeIcon;
    @FXML
    private Text infoLabel;
    @FXML
    private Text rangeLabel;
    @FXML
    private AnchorPane titleAnchorPane;

    public KeyPadController3D(Stage parentStage) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("KeyPad3D.fxml"));
            loader.setControllerFactory(type -> {
                if (type == KeyPadController3D.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myStage = new Stage();
            this.myScene = new Scene(root);
            this.myStage.initOwner((Window)parentStage);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.initStyle(StageStyle.UNDECORATED);
        }
        catch (IOException ex) {
            System.out.println("Load Error");
        }
    }

    @FXML
    void titleAnchorPanePressed(MouseEvent event) {
        xOffset = event.getSceneX();
        yOffset = event.getSceneY();
    }

    @FXML
    void titleAnchorPaneDragged(MouseEvent event) {
        this.myStage.setX(event.getScreenX() - xOffset);
        this.myStage.setY(event.getScreenY() - yOffset);
    }

    public void setMin(double val) {
        this.min_range_f = val;
        this.displayRange();
    }

    public void setMax(double val) {
        this.max_range_f = val;
        this.displayRange();
    }

    public String show() {
        this.myStage.showAndWait();
        if (this.inputText.length() == 0) {
            return null;
        }
        return this.textValue;
    }

    public void setScene(Scene sdata) {
        this.myScene = sdata;
    }

    public void setStage(Stage sdata) {
        this.myStage = sdata;
    }

    public void windowMove() {
        this.myScene.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                xOffset = event.getSceneX();
                yOffset = event.getSceneY();
            }
        });
        this.myScene.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                KeyPadController3D.this.myStage.setX(event.getScreenX() - xOffset);
                KeyPadController3D.this.myStage.setY(event.getScreenY() - yOffset);
            }
        });
    }

    public void setData(String sdata) {
        this.textValue = sdata;
        this.inputText.append(sdata);
        this.textInput.setText(this.textValue);
    }

    public String getData() {
        return this.textValue;
    }

    public void setTitle(String txt) {
        this.title.setText(txt);
    }

    @FXML
    void clrClick(MouseEvent event) {
        this.keyProcess('c');
    }

    @FXML
    void backClick(MouseEvent event) {
        this.keyProcess('b');
    }

    @FXML
    void dotClick(MouseEvent event) {
        this.keyProcess('.');
    }

    @FXML
    void downClick(MouseEvent event) {
    }

    @FXML
    void eightClick(MouseEvent event) {
        this.keyProcess('8');
    }

    @FXML
    void entClick(MouseEvent event) {
        this.keyProcess('e');
    }

    @FXML
    void fiveClick(MouseEvent event) {
        this.keyProcess('5');
    }

    @FXML
    void fourClick(MouseEvent event) {
        this.keyProcess('4');
    }

    @FXML
    void minusClick(MouseEvent event) {
        this.keyProcess('-');
    }

    @FXML
    void sixClick(MouseEvent event) {
        this.keyProcess('6');
    }

    @FXML
    void threeClick(MouseEvent event) {
        this.keyProcess('3');
    }

    @FXML
    void twoClick(MouseEvent event) {
        this.keyProcess('2');
    }

    @FXML
    void upClick(MouseEvent event) {
    }

    @FXML
    void zeroClick(MouseEvent event) {
        this.keyProcess('0');
    }

    @FXML
    void oneClick(MouseEvent event) {
        this.keyProcess('1');
    }

    @FXML
    void sevenClick(MouseEvent event) {
        this.keyProcess('7');
    }

    @FXML
    void nineClick(MouseEvent event) {
        this.keyProcess('9');
    }

    private void keyProcess(char in) {
        this.sysData.keyProcess(1);
        if (in >= '0' && in <= '9' && this.inputText.length() < this.input_cnt) {
            if (this.firstInput) {
                this.inputText.setLength(0);
                this.firstInput = false;
            }
            this.passwordText.append("*");
            this.inputText.append(in);
            if (this.password) {
                this.textInput.setText(this.passwordText.toString());
            } else {
                this.textInput.setText(this.inputText.toString());
            }
            this.infoLabel.setText("");
            if (this.dot_flag == 1) {
                ++this.dot_after_cnt;
            }
            if (this.inputText.length() != 0) {
                double value = Double.parseDouble(this.inputText.toString());
                if (value > this.max_range_f) {
                    this.dot_flag = 0;
                    this.minus_flag = 0;
                    this.dot_after_cnt = 0;
                    this.textInput.setText("");
                    this.infoLabel.setText("The input value exceeded the range upper limit.");
                    this.inputText.setLength(0);
                    this.passwordText.setLength(0);
                }
                if (value < this.min_range_f) {
                    this.dot_flag = 0;
                    this.minus_flag = 0;
                    this.dot_after_cnt = 0;
                    this.textInput.setText("");
                    this.infoLabel.setText("The input value exceeds the lower limit of the range.");
                    this.inputText.setLength(0);
                    this.passwordText.setLength(0);
                }
            }
        } else if (in == '-') {
            if (this.inputText.length() == 0) {
                this.firstInput = false;
                this.infoLabel.setText("");
                this.inputText.append(in);
                this.passwordText.append(in);
                if (this.password) {
                    this.textInput.setText(this.passwordText.toString());
                } else {
                    this.textInput.setText(this.inputText.toString());
                }
                this.minus_flag = 1;
            }
        } else if (in == 'b') {
            if (this.inputText.length() > 0) {
                if (this.inputText.charAt(this.inputText.length() - 1) == '.') {
                    this.dot_flag = 0;
                    this.dot_after_cnt = 0;
                }
                if (this.inputText.length() > 0) {
                    if (this.password) {
                        this.passwordText.setLength(this.inputText.length() - 1);
                    }
                    this.inputText.setLength(this.inputText.length() - 1);
                }
                if (this.password) {
                    this.textInput.setText(this.passwordText.toString());
                } else {
                    this.textInput.setText(this.inputText.toString());
                }
                if (this.inputText.length() < this.input_cnt) {
                    this.infoLabel.setText("");
                }
            }
        } else if (in == '.' && this.dot_flag == 0) {
            if (this.password) {
                this.passwordText.append("*");
            } else {
                this.inputText.append(in);
            }
            this.dot_flag = 1;
            if (this.password) {
                this.textInput.setText(this.passwordText.toString());
            } else {
                this.textInput.setText(this.inputText.toString());
            }
        } else if (in == 'c') {
            this.dot_flag = 0;
            this.minus_flag = 0;
            this.dot_after_cnt = 0;
            this.inputText.setLength(0);
            this.passwordText.setLength(0);
            if (this.password) {
                this.textInput.setText(this.passwordText.toString());
            } else {
                this.textInput.setText(this.inputText.toString());
            }
        } else if (in == 'e') {
            this.textValue = this.inputText.toString();
            Window window = this.myScene.getWindow();
            if (window instanceof Stage) {
                ((Stage)window).close();
            }
        } else {
            this.infoLabel.setText("\ub354\uc774\uc0c1 \uc785\ub825\ud560\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
    }

    void close() {
        this.textValue = null;
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }

    @FXML
    void closeIconPressed(MouseEvent event) {
        this.sysData.keyProcess(1);
        this.closeIcon.setImage(new Image(this.getClass().getResource("/resources/exit32_orange.png").toString()));
    }

    @FXML
    void closeIconReleased(MouseEvent event) {
        this.closeIcon.setImage(new Image(this.getClass().getResource("/resources/exit32_blue.png").toString()));
        this.close();
    }

    @FXML
    void backPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KBACK_T.png").toString());
        this.backBtn.setImage(clrImage);
    }

    @FXML
    void backRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KBACK_N.png").toString());
        this.backBtn.setImage(clrImage);
    }

    @FXML
    void dotPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KDOT_T.png").toString());
        this.dotBtn.setImage(clrImage);
    }

    @FXML
    void dotRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KDOT_N.png").toString());
        this.dotBtn.setImage(clrImage);
    }

    @FXML
    void eightPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K8_T.png").toString());
        this.eightBtn.setImage(clrImage);
    }

    @FXML
    void eightRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K8_N.png").toString());
        this.eightBtn.setImage(clrImage);
    }

    @FXML
    void entPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KENT_T.png").toString());
        this.entBtn.setImage(clrImage);
    }

    @FXML
    void entRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KENT_N.png").toString());
        this.entBtn.setImage(clrImage);
    }

    @FXML
    void fivePress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K5_T.png").toString());
        this.fiveBtn.setImage(clrImage);
    }

    @FXML
    void fiveRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K5_N.png").toString());
        this.fiveBtn.setImage(clrImage);
    }

    @FXML
    void fourPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K4_T.png").toString());
        this.fourBtn.setImage(clrImage);
    }

    @FXML
    void fourRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K4_N.png").toString());
        this.fourBtn.setImage(clrImage);
    }

    @FXML
    void minusPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KMinus_T.png").toString());
        this.minusBtn.setImage(clrImage);
    }

    @FXML
    void minusRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KMinus_N.png").toString());
        this.minusBtn.setImage(clrImage);
    }

    @FXML
    void ninePress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K9_T.png").toString());
        this.nineBtn.setImage(clrImage);
    }

    @FXML
    void nineRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K9_N.png").toString());
        this.nineBtn.setImage(clrImage);
    }

    @FXML
    void onePress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K1_T.png").toString());
        this.oneBtn.setImage(clrImage);
    }

    @FXML
    void oneRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K1_N.png").toString());
        this.oneBtn.setImage(clrImage);
    }

    @FXML
    void sevenPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K7_T.png").toString());
        this.sevenBtn.setImage(clrImage);
    }

    @FXML
    void sevenRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K7_N.png").toString());
        this.sevenBtn.setImage(clrImage);
    }

    @FXML
    void sixPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K6_T.png").toString());
        this.sixBtn.setImage(clrImage);
    }

    @FXML
    void sixRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K6_N.png").toString());
        this.sixBtn.setImage(clrImage);
    }

    @FXML
    void threePress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K3_T.png").toString());
        this.threeBtn.setImage(clrImage);
    }

    @FXML
    void threeRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K3_N.png").toString());
        this.threeBtn.setImage(clrImage);
    }

    @FXML
    void twoPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K2_T.png").toString());
        this.twoBtn.setImage(clrImage);
    }

    @FXML
    void twoRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K2_N.png").toString());
        this.twoBtn.setImage(clrImage);
    }

    @FXML
    void zeroPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K0_T.png").toString());
        this.zeroBtn.setImage(clrImage);
    }

    @FXML
    void zeroRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/K0_N.png").toString());
        this.zeroBtn.setImage(clrImage);
    }

    @FXML
    void clrPress(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KCLR_T.png").toString());
        this.clrBtn.setImage(clrImage);
    }

    @FXML
    void clrRelease(MouseEvent event) {
        Image clrImage = new Image(this.getClass().getResource("/resources/KCLR_N.png").toString());
        this.clrBtn.setImage(clrImage);
    }

    void displayRange() {
        String val = String.format("%5.1f ~ %5.1f", this.min_range_f, this.max_range_f);
        this.rangeLabel.setText(val);
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.displayRange();
    }
}

