/*
 * Decompiled with CFR 0.152.
 */
package Utility;

public class BCD {
    public static byte[] DecimalToBCD(long num) {
        byte tmp;
        int i;
        int digits = 0;
        for (long temp = num; temp != 0L; temp /= 10L) {
            ++digits;
        }
        int byteLen = digits % 2 == 0 ? digits / 2 : (digits + 1) / 2;
        byte[] bcd = new byte[byteLen];
        for (i = 0; i < digits; ++i) {
            tmp = (byte)(num % 10L);
            if (i % 2 == 0) {
                bcd[i / 2] = tmp;
            } else {
                int n = i / 2;
                bcd[n] = (byte)(bcd[n] | (byte)(tmp << 4));
            }
            num /= 10L;
        }
        for (i = 0; i < byteLen / 2; ++i) {
            tmp = bcd[i];
            bcd[i] = bcd[byteLen - i - 1];
            bcd[byteLen - i - 1] = tmp;
        }
        return bcd;
    }

    public static long BCDToDecimal(byte[] bcd) {
        return Long.valueOf(BCD.BCDtoString(bcd));
    }

    public static String BCDtoString(byte bcd) {
        StringBuffer sb = new StringBuffer();
        byte high = (byte)(bcd & 0xF0);
        high = (byte)(high >>> 4);
        high = (byte)(high & 0xF);
        byte low = (byte)(bcd & 0xF);
        sb.append(high);
        sb.append(low);
        return sb.toString();
    }

    public static String BCDtoString(byte[] bcd) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bcd.length; ++i) {
            sb.append(BCD.BCDtoString(bcd[i]));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        byte[] data = BCD.DecimalToBCD(1234L);
        System.out.println(String.format("%02x %02x", data[0], data[1]));
        System.out.println("Testing DecimalToBCD:");
        BCD.testForValue(1L, "00000001");
        BCD.testForValue(11L, "00010001");
        BCD.testForValue(111L, "0000000100010001");
        BCD.testForValue(1111L, "0001000100010001");
        BCD.testForValue(11111L, "000000010001000100010001");
        BCD.testForValue(42L, "01000010");
        BCD.testForValue(112233L, "000100010010001000110011");
        BCD.testForValue(12345L, "000000010010001101000101");
        System.out.println("\nTesting two way conversion using DecimalToBCD and back using BCDToDecimal:");
        BCD.testForValue(1L);
        BCD.testForValue(11L);
        BCD.testForValue(111L);
        BCD.testForValue(1111L);
        BCD.testForValue(11111L);
        BCD.testForValue(12983283L);
        BCD.testForValue(9832098349L);
    }

    private static void testForValue(long val, String expected) {
        String binaryString = BCD.byteArrayToBinaryString(BCD.DecimalToBCD(val));
        System.out.print(String.format("Testing: %10d -> %30s %4s\n", val, binaryString, binaryString.equals(expected) ? "[OK]" : "[FAIL]"));
    }

    private static void testForValue(long val) {
        long newVal = BCD.BCDToDecimal(BCD.DecimalToBCD(val));
        System.out.print(String.format("Testing: %10d -> %30d %4s\n", val, newVal, newVal == val ? "[OK]" : "[FAIL]"));
    }

    private static String byteArrayToBinaryString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (byte i : bytes) {
            String byteInBinary = String.format("%8s", Integer.toBinaryString(i)).replace(' ', '0');
            sb.append(byteInBinary);
        }
        return sb.toString();
    }
}

