/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import Data.SystemData;
import Utility.BCD;
import Utility.SongUtil;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalMultipurpose;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DS1302 {
    private static DS1302 instance;
    final GpioController gpio;
    final GpioPinDigitalOutput rtcCs;
    final GpioPinDigitalOutput rtcClk;
    GpioPinDigitalMultipurpose rtcIo;
    SystemData sysData = SystemData.getInstance();
    final byte TESTYEAR = (byte)25;
    final byte TESTMONTH = 1;
    final byte TESTDATE = (byte)16;
    final byte TESTDAY = (byte)16;
    final byte TESTHOUR = (byte)16;
    final byte TESTMIN = (byte)16;
    final byte TESTSEC = 0;

    public static synchronized DS1302 getInstance() {
        if (instance == null) {
            instance = new DS1302();
        }
        return instance;
    }

    private DS1302() {
        this.gpio = GpioFactory.getInstance();
        this.rtcCs = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_03, "rtcCs", PinState.HIGH);
        this.rtcClk = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_00, "rtcClk", PinState.LOW);
        this.rtcIo = this.gpio.provisionDigitalMultipurposePin(RaspiPin.GPIO_02, PinMode.DIGITAL_OUTPUT);
        this.rtcCs.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.rtcClk.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.rtcIo.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
    }

    public void autoTimeSet() {
        if (SongUtil.checkEthernet()) {
            SongUtil.systemExec("sudo timedatectl set-ntp yes");
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy,MM,dd,HH,mm,ss");
            String formatDateTime = now.format(formatter);
            StringTokenizer st = new StringTokenizer(formatDateTime, ",");
            int year = Integer.valueOf(st.nextToken().trim()) - 2000;
            int month = Integer.valueOf(st.nextToken().trim());
            int day = Integer.valueOf(st.nextToken().trim());
            int hour = Integer.valueOf(st.nextToken().trim());
            int min = Integer.valueOf(st.nextToken().trim());
            int sec = Integer.valueOf(st.nextToken().trim());
            byte[] year1 = BCD.DecimalToBCD(year);
            byte[] month1 = BCD.DecimalToBCD(month);
            byte[] day1 = BCD.DecimalToBCD(day);
            byte[] hour1 = BCD.DecimalToBCD(hour);
            byte[] min1 = BCD.DecimalToBCD(min);
            byte[] sec1 = BCD.DecimalToBCD(sec);
            this.sysData.rtcClock.dS1302TimeSet(year1[0], month1[0], day1[0], hour1[0], min1[0], sec1[0]);
            System.out.println("LAN \uc774 \uc5f0\uacb0\ub418\uc5b4\uc788\uc5b4 \uc2dc\uac04\uc744 RTC\uc5d0 \uc124\uc815\ud568.");
        } else {
            SongUtil.systemExec("sudo timedatectl set-ntp no");
            byte[] time = this.rtcRead();
            System.out.println(String.format("RTC Read Time = 20%02x-%02x-%02x %02x:%02x:%02x", time[0], time[1], time[2], time[3], time[4], time[5]));
            String date = String.format("20%02x%02x%02x", time[0], time[1], time[2]);
            String dateSet = "sudo date +%Y%m%d -s " + date;
            String time1 = String.format("%02x:%02x:%02x", time[3], time[4], time[5]);
            String timeSet = "sudo date +%T -s " + time1;
            SongUtil.systemExec(dateSet);
            SongUtil.systemExec(timeSet);
            System.out.println("LAN \uc774 \uc5f0\uacb0\ub418\uc5b4\uc788\uc9c0\uc54a\uc544 \uc2dc\uac04\uc744 RTC\uc5d0\uc11c \uc77d\uc5b4\uc634.");
        }
    }

    public void gpioShutDown() {
        if (this.gpio != null) {
            this.gpio.shutdown();
        }
    }

    private void waitNano(long usec) {
        long nowTime;
        long firstTime = System.nanoTime();
        while ((nowTime = System.nanoTime()) < firstTime + usec) {
        }
    }

    private void dS1302DataPort_InMode() {
        this.rtcIo.setMode(PinMode.DIGITAL_INPUT);
    }

    private void dS1302DataPort_OutMode() {
        this.rtcIo.setMode(PinMode.DIGITAL_OUTPUT);
    }

    private void dS1302Clock() {
        this.rtcClk.high();
        this.waitNano(1000L);
        this.rtcClk.low();
        this.waitNano(1000L);
    }

    private void dS1302Data(int s) {
        if (s == 1) {
            this.rtcIo.high();
        } else {
            this.rtcIo.low();
        }
    }

    private void dS1302Start() {
        this.rtcCs.high();
        this.waitNano(1000L);
    }

    private void dS1302Stop() {
        this.rtcCs.low();
        this.waitNano(1000L);
    }

    private void dS1302OutByte(byte data) {
        if ((data & 1) == 1) {
            this.dS1302Data(1);
        } else {
            this.dS1302Data(0);
        }
        this.waitNano(1000L);
        this.dS1302Clock();
        for (int i = 1; i < 8; i = (int)((byte)(i + 1))) {
            byte temp = (byte)(data >> i);
            if ((temp & 1) == 1) {
                this.dS1302Data(1);
            } else {
                this.dS1302Data(0);
            }
            this.waitNano(1000L);
            this.dS1302Clock();
        }
    }

    private void dS1302WriteByte(byte command, byte data) {
        this.dS1302Start();
        this.dS1302OutByte((byte)(command & 0xFE));
        this.dS1302OutByte(data);
        this.dS1302Stop();
    }

    private byte dS1302InByte() {
        byte c = 0;
        this.dS1302DataPort_InMode();
        this.waitNano(1000L);
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            boolean sts = this.rtcIo.isHigh();
            if (sts) {
                switch (i) {
                    case 0: {
                        c = (byte)(c | 1);
                        break;
                    }
                    case 1: {
                        c = (byte)(c | 2);
                        break;
                    }
                    case 2: {
                        c = (byte)(c | 4);
                        break;
                    }
                    case 3: {
                        c = (byte)(c | 8);
                        break;
                    }
                    case 4: {
                        c = (byte)(c | 0x10);
                        break;
                    }
                    case 5: {
                        c = (byte)(c | 0x20);
                        break;
                    }
                    case 6: {
                        c = (byte)(c | 0x40);
                        break;
                    }
                    case 7: {
                        c = (byte)(c | 0x80);
                    }
                }
            }
            this.dS1302Clock();
        }
        this.dS1302DataPort_OutMode();
        this.waitNano(1000L);
        return c;
    }

    private byte dS1302ReadByte(byte command) {
        this.dS1302Start();
        this.dS1302OutByte((byte)(command | 1));
        byte i = this.dS1302InByte();
        this.dS1302Stop();
        return i;
    }

    private void dS1302Init() {
        this.dS1302WriteByte((byte)-114, (byte)0);
        this.dS1302WriteByte((byte)-112, (byte)-91);
        byte i = this.dS1302ReadByte((byte)-128);
        i = (byte)(i & 0x7F);
        this.dS1302WriteByte((byte)-128, i);
        i = this.dS1302ReadByte((byte)-124);
        i = (byte)(i & 0x7F);
        this.dS1302WriteByte((byte)-124, i);
    }

    private void dS1302InitSet() {
        this.dS1302Init();
        this.dS1302WriteByte((byte)-128, (byte)0);
        this.dS1302WriteByte((byte)-126, (byte)16);
        byte time = this.dS1302ReadByte((byte)-123);
        time = (byte)(time & 0x80 | 0x10);
        this.dS1302WriteByte((byte)-124, time);
        this.dS1302WriteByte((byte)-122, (byte)16);
        this.dS1302WriteByte((byte)-120, (byte)1);
        this.dS1302WriteByte((byte)-116, (byte)25);
        System.out.println(String.format("RTC Set OK:%02x/%02x/%02x %02x:%02x:%02x\n", (byte)25, (byte)1, (byte)16, (byte)16, (byte)16, (byte)0));
    }

    public void dS1302TimeSet(byte year, byte mon, byte day, byte hour, byte min, byte sec) {
        System.out.println("dS1302TimeSet Start...");
        this.dS1302Init();
        this.dS1302WriteByte((byte)-128, sec);
        this.dS1302WriteByte((byte)-126, min);
        byte time = this.dS1302ReadByte((byte)-123);
        time = (byte)(time & 0x80 | hour);
        this.dS1302WriteByte((byte)-124, time);
        this.dS1302WriteByte((byte)-122, day);
        this.dS1302WriteByte((byte)-120, mon);
        this.dS1302WriteByte((byte)-116, year);
        System.out.println(String.format("RTC Time Set OK:%02x/%02x/%02x %02x:%02x:%02x\n", year, mon, day, hour, min, sec));
    }

    public byte[] rtcRead() {
        this.dS1302Init();
        byte[] time = new byte[10];
        time[5] = (byte)(this.dS1302ReadByte((byte)-127) & 0x7F);
        time[4] = this.dS1302ReadByte((byte)-125);
        time[3] = (byte)(this.dS1302ReadByte((byte)-123) & 0x3F);
        time[2] = this.dS1302ReadByte((byte)-121);
        time[1] = this.dS1302ReadByte((byte)-119);
        time[0] = this.dS1302ReadByte((byte)-115);
        System.out.println(String.format("RTC Read:%02x/%02x/%02x %02x:%02x:%02x\n", time[0], time[1], time[2], time[3], time[4], time[5]));
        return time;
    }

    public void rtcTest() {
        this.dS1302Init();
        while (true) {
            byte sec = (byte)(this.dS1302ReadByte((byte)-127) & 0x7F);
            byte minute = this.dS1302ReadByte((byte)-125);
            byte hour = (byte)(this.dS1302ReadByte((byte)-123) & 0x3F);
            byte date = this.dS1302ReadByte((byte)-121);
            byte month = this.dS1302ReadByte((byte)-119);
            byte year = this.dS1302ReadByte((byte)-115);
            System.out.println(String.format("RTC:%02x-%02x-%02x %02x:%02x:%02x\n", 8192 + year, month, date, hour, minute, sec));
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ex) {
                Logger.getLogger(DS1302.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }
}

