/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.wiringpi.Gpio;

public class Dial {
    private static Dial instance;
    final GpioController gpio = GpioFactory.getInstance();
    private boolean initSet = false;
    GpioPinDigitalInput encA;
    GpioPinDigitalInput encB;
    private int dialValue = 0;

    public static synchronized Dial getInstance() {
        if (instance == null) {
            instance = new Dial();
        }
        return instance;
    }

    private Dial() {
        if (Gpio.wiringPiSetup() == -1) {
            System.out.println(" ==>> GPIO SETUP FAILED");
            this.initSet = false;
        } else {
            this.initSet = true;
            this.chipInit();
            System.out.println("pi Setup OK...");
        }
    }

    public boolean getSetInit() {
        return this.initSet;
    }

    private void chipInit() {
        this.encA = this.gpio.provisionDigitalInputPin(RaspiPin.GPIO_25, PinPullResistance.PULL_UP);
        this.encB = this.gpio.provisionDigitalInputPin(RaspiPin.GPIO_29, PinPullResistance.PULL_UP);
        this.encA.addListener(new GpioPinListener[]{new GpioPinListenerDigital(){

            public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
                System.out.println("PINA(25)=" + Dial.this.encA.getState() + " PINB(29)=" + Dial.this.encB.getState());
                PinState a = Dial.this.encA.getState();
                PinState b = Dial.this.encB.getState();
                if (a == b) {
                    Dial.this.dialValue++;
                } else {
                    Dial.this.dialValue--;
                }
                System.out.println("Dial = " + Dial.this.dialValue);
            }
        }});
    }

    public void start() {
        this.chipInit();
    }

    public void gpioShutDown() {
        if (this.gpio != null) {
            this.gpio.shutdown();
        }
    }
}

