/*
 * Decompiled with CFR 0.152.
 */
package Utility.EventBus;

import Utility.EventBus.EventBusListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventBusHandler {
    private static final int MAX_THREAD_POOL = 5;
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBusHandler.class);
    private static List<EventBusListener> listeners = new CopyOnWriteArrayList<EventBusListener>();

    private static synchronized List<EventBusListener> getListeners() {
        return listeners;
    }

    public static synchronized void addListener(EventBusListener eventListener) {
        if (EventBusHandler.getListeners().indexOf(eventListener) == -1) {
            listeners.add(eventListener);
        }
    }

    public static synchronized void removeListener(EventBusListener eventListener) {
        if (EventBusHandler.getListeners().indexOf(eventListener) != -1) {
            listeners.remove(eventListener);
        }
    }

    public static synchronized void callEvent(final Class<?> caller, final String id, final String event) {
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        LOGGER.info("[Event occur : <{}> by <{}>]", new Object[]{event, caller.getName()});
        for (final EventBusListener listener : listeners) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (listener.getClass().getName().equals(caller.getName())) {
                        LOGGER.info("[Event skip : <{}> by self <{}>]", new Object[]{event, caller.getName()});
                    } else {
                        LOGGER.info("[Event catch : <{}> by <{}>]", new Object[]{event, listener.getClass().getName()});
                        listener.onEvent(id, event);
                    }
                }
            });
        }
        executorService.shutdown();
    }
}

