/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import Utility.SongUtil;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import com.pi4j.util.CommandArgumentParser;
import com.pi4j.wiringpi.Gpio;

public class FanControl {
    private static FanControl instance;
    GpioController gpio = GpioFactory.getInstance();
    GpioPinPwmOutput pwm;
    boolean threadSts = true;

    public static synchronized FanControl getInstance() {
        if (instance == null) {
            instance = new FanControl();
        }
        return instance;
    }

    private FanControl() {
        Pin pin = CommandArgumentParser.getPin(RaspiPin.class, (Pin)RaspiPin.GPIO_26, (String[])new String[]{"test"});
        this.pwm = this.gpio.provisionPwmOutputPin(pin);
        this.pwm.setShutdownOptions(Boolean.valueOf(true), PinState.LOW);
        Gpio.pwmSetMode((int)0);
        Gpio.pwmSetRange((int)1000);
        Gpio.pwmSetClock((int)1);
        this.pwm.setPwm(0);
        new Thread(() -> {
            while (this.threadSts) {
                float cpuTemp = SongUtil.getCpuTemp();
                if (cpuTemp < 50.0f) {
                    this.pwm.setPwm(0);
                } else if (cpuTemp >= 50.0f && cpuTemp < 55.0f) {
                    this.pwm.setPwm(400);
                } else if (cpuTemp >= 55.0f && cpuTemp < 60.0f) {
                    this.pwm.setPwm(450);
                } else if (cpuTemp >= 60.0f && cpuTemp < 70.0f) {
                    this.pwm.setPwm(500);
                } else if (cpuTemp >= 70.0f) {
                    this.pwm.setPwm(800);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }).start();
    }

    public void threadExit() {
        this.threadSts = false;
    }

    public void gpioShutDown() {
        if (this.gpio != null) {
            this.gpio.shutdown();
        }
    }

    public void setPwm(int duty) {
        this.pwm.setPwm(duty);
    }
}

