/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import Data.SystemData;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.Window;

public class LcdPower {
    private static LcdPower instance;
    final GpioController gpio;
    final GpioPinDigitalOutput pwdn;
    final GpioPinDigitalOutput backLight;
    LocalDateTime firstDateTime;
    boolean threadSts = true;
    boolean saveModeStart = false;
    int saveTime = 0;
    boolean screenView = false;
    SystemData sysData = SystemData.getInstance();

    public static synchronized LcdPower getInstance() {
        if (instance == null) {
            instance = new LcdPower();
        }
        return instance;
    }

    private LcdPower() {
        this.gpio = GpioFactory.getInstance();
        this.pwdn = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_07, "pwdn", PinState.HIGH);
        this.backLight = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_23, "backLight", PinState.HIGH);
        this.pwdn.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.backLight.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
    }

    public void timeSet(int minute) {
        this.saveTime = minute;
    }

    private void screen() {
        System.out.println("Screen Saver View...");
        AnchorPane anchor = new AnchorPane();
        anchor.setStyle("-fx-background-color:black");
        SystemData sysData = SystemData.getInstance();
        Scene scene = new Scene((Parent)anchor, (double)sysData.LCD_X, (double)sysData.LCD_X);
        Stage myStage = new Stage();
        anchor.setOnMousePressed(e -> {
            sysData.keyProcess(1);
            System.out.println("Screen Saver Finish...");
            this.touchPress();
            this.screenView = false;
            Window window = scene.getWindow();
            if (window instanceof Stage) {
                ((Stage)window).close();
            }
        });
        myStage.setScene(scene);
        myStage.showAndWait();
    }

    public void saveModeStart(int min) {
        this.firstDateTime = LocalDateTime.now();
        this.saveModeStart = true;
        this.saveTime = min;
        new Thread(() -> {
            while (this.threadSts) {
                LocalDateTime nowDateTime;
                long minutes;
                if (this.saveModeStart && (minutes = ChronoUnit.MINUTES.between(this.firstDateTime, nowDateTime = LocalDateTime.now())) >= (long)this.saveTime) {
                    System.out.println("Diff minute = " + minutes + "SaveTime=" + this.saveTime);
                    Platform.runLater(() -> {
                        if (!this.screenView) {
                            this.screenView = true;
                            this.screen();
                            this.on();
                        }
                    });
                    this.on();
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }).start();
    }

    public void touchPress() {
        if (this.saveModeStart) {
            this.firstDateTime = LocalDateTime.now();
            this.on();
        }
    }

    public void saveModeStop() {
        this.saveModeStart = false;
        this.on();
    }

    public void threadExit() {
        this.threadSts = false;
    }

    public void gpioShutDown() {
        if (this.gpio != null) {
            this.gpio.shutdown();
        }
    }

    private void powerDownEnable() {
        this.pwdn.low();
    }

    private void powerDownDisable() {
        this.pwdn.high();
    }

    private void bakcLightEnable() {
        this.backLight.high();
    }

    private void bakcLightDisable() {
        this.backLight.low();
    }

    public void on() {
        this.powerDownDisable();
        this.bakcLightEnable();
    }

    public void off() {
        this.powerDownEnable();
        this.bakcLightDisable();
    }
}

