/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import Utility.OsCheck;
import com.pi4j.system.SystemInfo;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Enumeration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;

public class SongUtil {
    public static short commCRC(String str) {
        short crc = 0;
        for (int i = 0; i < str.length(); ++i) {
            short a = (short)str.charAt(i);
            crc = (short)(crc + a);
        }
        String str1 = String.format("%04x", crc);
        System.out.println("CRC= " + str1);
        return crc;
    }

    public static String nowDateTimeToFormatString() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return now.format(formatter);
    }

    public static String nowDateTimeToFormatString2() {
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy,MM,dd,HH,mm,ss");
        return now.format(formatter);
    }

    public static long getFreeMemory() {
        long free = 0L;
        try {
            free = SystemInfo.getMemoryFree();
            return free;
        }
        catch (IOException | InterruptedException | UnsupportedOperationException ex) {
            Logger.getLogger(SongUtil.class.getName()).log(Level.SEVERE, null, ex);
            return free;
        }
    }

    public static double getCpuUsage() {
        OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        double cpu = osBean.getProcessCpuLoad() * 100.0;
        return cpu;
    }

    public static long getCpuSerial() {
        long serial = 0L;
        try {
            serial = Integer.parseInt(SystemInfo.getSerial());
        }
        catch (IOException ex) {
            Logger.getLogger(SongUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SongUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedOperationException ex) {
            Logger.getLogger(SongUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return serial;
    }

    public static boolean checkEthernet() {
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            System.out.println("InternetConnection Exception1");
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface nic = interfaces.nextElement();
            try {
                if (!nic.getDisplayName().equals("eth0")) continue;
                return nic.isUp();
            }
            catch (SocketException e) {
                System.out.println("InternetConnection Exception2");
            }
        }
        return false;
    }

    public static void systemExec(String command) {
        try {
            Process p = Runtime.getRuntime().exec(command);
            p.waitFor();
            p.destroy();
        }
        catch (IOException | InterruptedException ex) {
            System.out.println("SongUtil.systemExec run Error occur");
        }
    }

    public static boolean isComm(String portName) {
        File file = new File(portName);
        boolean isExists = file.exists();
        return isExists;
    }

    public static double Equation(double zeromv, double spanmv, double zero, double span, double in_mv) {
        double ret_val = zero + (in_mv - zeromv) / (spanmv - zeromv) * (span - zero);
        return ret_val;
    }

    public static float getCpuTemp() {
        try {
            float temp = SystemInfo.getCpuTemperature();
            return temp;
        }
        catch (IOException ex) {
            Logger.getLogger(SongUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(SongUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NumberFormatException ex) {
            Logger.getLogger(SongUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedOperationException ex) {
            Logger.getLogger(SongUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return 0.0f;
    }

    public static String osRead() {
        String osName = null;
        OsCheck.OSType ostype = OsCheck.getOperatingSystemType();
        switch (ostype) {
            case Windows: {
                osName = "Windows";
                break;
            }
            case MacOS: {
                osName = "MacOS";
                break;
            }
            case Linux: {
                osName = "Linux";
                break;
            }
        }
        return osName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(String source, String target) {
        File sourceFile = new File(source);
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        AbstractInterruptibleChannel fcin = null;
        AbstractInterruptibleChannel fcout = null;
        try {
            inputStream = new FileInputStream(sourceFile);
            outputStream = new FileOutputStream(target);
            fcin = inputStream.getChannel();
            fcout = outputStream.getChannel();
            long size = ((FileChannel)fcin).size();
            ((FileChannel)fcin).transferTo(0L, size, (WritableByteChannel)((Object)fcout));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                fcout.close();
            }
            catch (IOException iOException) {}
            try {
                fcin.close();
            }
            catch (IOException iOException) {}
            try {
                outputStream.close();
            }
            catch (IOException iOException) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void getFileList(File folder) {
        File[] listOfFiles;
        for (File file : listOfFiles = folder.listFiles()) {
            if (!file.isFile()) continue;
            System.out.println(file.getName());
            System.out.println(file.getPath());
        }
    }

    public void fileListTest() {
        File folder = new File("/home/pi/NetBeansProjects/LegControl");
        SongUtil.getFileList(folder);
    }

    void dirCopy() {
        File[] listOfFiles;
        File folder = new File("/media/usb0/resources");
        for (File file : listOfFiles = folder.listFiles()) {
            if (!file.isFile()) continue;
            String dest = "/home/pi/NetBeansProjects/LegControl/" + file.getName();
            SongUtil.fileCopy(file.getPath(), dest);
        }
    }

    public static String convertFloatToString(float value) {
        return Integer.toHexString(Float.floatToIntBits(value));
    }

    public static float convertStringToFloat(String str) {
        Long i = Long.parseLong(str, 16);
        Float f = Float.valueOf(Float.intBitsToFloat(i.intValue()));
        return f.floatValue();
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b & 0xFF));
        }
        return sb.toString();
    }

    public static void hexaTest() {
        String hexString = "01020304FF11";
        byte[] ByteArray = SongUtil.hexStringToByteArray(hexString);
        String str = SongUtil.byteArrayToHexString(ByteArray);
        System.out.println(str + ByteArray[0] + ByteArray[1]);
    }

    public static void reverseArrayString(String[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            String temp = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = temp;
        }
    }

    public static void messageBox(String title, String header, String msg) {
        Alert alert = new Alert(Alert.AlertType.INFORMATION);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(msg);
        alert.showAndWait().ifPresent(rs -> {
            if (rs == ButtonType.OK) {
                System.out.println("Pressed OK.");
            }
        });
    }

    public static boolean confirmBox(String title, String header, String msg) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle(title);
        alert.setHeaderText(header);
        alert.setContentText(msg);
        Optional result = alert.showAndWait();
        return result.get() == ButtonType.OK;
    }

    public static void main(String[] args) {
    }
}

