/*
 * Decompiled with CFR 0.152.
 */
package Utility;

import Utility.SongUtil;
import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.RaspiPin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Voice {
    private static Voice instance;
    final GpioController gpio = GpioFactory.getInstance();
    final GpioPinDigitalOutput spiCs = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_14, "spiCs", PinState.HIGH);
    final GpioPinDigitalOutput spiClk = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_13, "spiClk", PinState.LOW);
    final GpioPinDigitalOutput spiDataOut = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_12, "spiDataOut", PinState.HIGH);
    final GpioPinDigitalOutput voiceRst = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_01, "voiceRst", PinState.HIGH);
    final GpioPinDigitalOutput mute = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_05, "mute", PinState.HIGH);
    final GpioPinDigitalOutput sndpwdn = this.gpio.provisionDigitalOutputPin(RaspiPin.GPIO_11, "sndpwdn", PinState.HIGH);

    public static synchronized Voice getInstance() {
        if (instance == null) {
            instance = new Voice();
        }
        return instance;
    }

    private Voice() {
        this.mute.low();
        this.sndpwdn.low();
        this.mute.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.sndpwdn.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.spiCs.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.spiClk.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.spiDataOut.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.voiceRst.setShutdownOptions(Boolean.valueOf(true), PinState.HIGH);
        this.voiceReset();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Voice.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.voice_Init();
    }

    public void soundPlay(String snd) {
        System.out.println("Sound Play Start...");
        SongUtil.systemExec("aplay " + snd);
        System.out.println("Sound Play End...");
    }

    public void gpioShutDown() {
        if (this.gpio != null) {
            this.gpio.shutdown();
        }
    }

    void voiceReset() {
        this.voiceRst.low();
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Voice.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.voiceRst.high();
    }

    void voice_SPI_CS(int s) {
        if (s == 1) {
            this.spiCs.high();
        } else {
            this.spiCs.low();
        }
    }

    void voice_SPI_Clk() {
        this.spiClk.high();
        this.waitNano(1000L);
        this.spiClk.low();
        this.waitNano(1000L);
    }

    void voice_SPI_Data(int s) {
        if (s == 1) {
            this.spiDataOut.high();
        } else {
            this.spiDataOut.low();
        }
    }

    void voice_SPI_Send(long data) {
        if ((data & 0x80L) == 128L) {
            this.voice_SPI_Data(1);
        } else {
            this.voice_SPI_Data(0);
        }
        this.voice_SPI_Clk();
        if ((data & 0x40L) == 64L) {
            this.voice_SPI_Data(1);
        } else {
            this.voice_SPI_Data(0);
        }
        this.voice_SPI_Clk();
        if ((data & 0x20L) == 32L) {
            this.voice_SPI_Data(1);
        } else {
            this.voice_SPI_Data(0);
        }
        this.voice_SPI_Clk();
        if ((data & 0x10L) == 16L) {
            this.voice_SPI_Data(1);
        } else {
            this.voice_SPI_Data(0);
        }
        this.voice_SPI_Clk();
        if ((data & 8L) == 8L) {
            this.voice_SPI_Data(1);
        } else {
            this.voice_SPI_Data(0);
        }
        this.voice_SPI_Clk();
        if ((data & 4L) == 4L) {
            this.voice_SPI_Data(1);
        } else {
            this.voice_SPI_Data(0);
        }
        this.voice_SPI_Clk();
        if ((data & 2L) == 2L) {
            this.voice_SPI_Data(1);
        } else {
            this.voice_SPI_Data(0);
        }
        this.voice_SPI_Clk();
        if ((data & 1L) == 1L) {
            this.voice_SPI_Data(1);
        } else {
            this.voice_SPI_Data(0);
        }
        this.voice_SPI_Clk();
    }

    void voiceDelay() {
        this.waitNano(100000L);
    }

    void voiceDelay500() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(Voice.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    void voice_Init() {
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(68L);
        this.voiceDelay500();
        this.voice_SPI_Send(21L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(75L);
        this.voiceDelay500();
        this.voice_SPI_Send(254L);
        this.voiceDelay500();
        this.voice_SPI_Send(225L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(79L);
        this.voiceDelay500();
        this.voice_SPI_Send(132L);
        this.voiceDelay500();
        this.voice_SPI_Send(255L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(86L);
        this.voiceDelay500();
        this.voice_SPI_Send(6L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(77L);
        this.voiceDelay500();
        this.voice_SPI_Send(127L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(78L);
        this.voiceDelay500();
        this.voice_SPI_Send(127L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(79L);
        this.voiceDelay500();
        this.voice_SPI_Send(8L);
        this.voiceDelay500();
        this.voice_SPI_Send(2L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(79L);
        this.voiceDelay500();
        this.voice_SPI_Send(217L);
        this.voiceDelay500();
        this.voice_SPI_Send(2L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(67L);
        this.voiceDelay500();
        this.voice_SPI_Send(5L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(72L);
        this.voiceDelay500();
        this.voice_SPI_Send(1L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
    }

    void voicePlay(int bank) {
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(80L);
        this.voiceDelay500();
        this.voice_SPI_Send(bank);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
    }

    public void voiceVolume(int vol) {
        if (vol > 128) {
            vol = 128;
        }
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(78L);
        this.voiceDelay500();
        this.voice_SPI_Send(vol);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
    }

    void SpeexVoiceStop() {
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(83L);
        this.voiceDelay500();
        this.voice_SPI_Send(1L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
    }

    public void voiceStop() {
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(88L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
    }

    void SPI_Flash_BypassInMode() {
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(70L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
    }

    void SPI_Flash_BypassExitMode() {
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(255L);
        this.voiceDelay500();
        this.voice_SPI_Send(255L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
        this.voiceDelay500();
    }

    void Write_Enable() {
        this.voice_SPI_CS(0);
        this.voice_SPI_Send(6L);
        this.voice_SPI_CS(1);
    }

    void Write_Disable() {
        this.voice_SPI_CS(0);
        this.voice_SPI_Send(4L);
        this.voice_SPI_CS(1);
    }

    void WriteStatus_Write(int data) {
        this.voice_SPI_CS(0);
        this.voice_SPI_Send(1L);
        this.voice_SPI_Send(data);
        this.voice_SPI_CS(1);
    }

    void Sector_Erase(long addr) {
        long address = 0L;
        this.Write_Enable();
        this.voice_SPI_CS(0);
        this.voice_SPI_Send(32L);
        address = addr >> 16 & 0xFFL;
        this.voice_SPI_Send(address);
        address = addr >> 8 & 0xFFL;
        this.voice_SPI_Send(address);
        address = addr & 0xFFL;
        this.voice_SPI_Send(address);
        this.voice_SPI_CS(1);
    }

    void Block_Erase(long addr) {
        long address = 0L;
        this.Write_Enable();
        this.voice_SPI_CS(0);
        this.voice_SPI_Send(82L);
        address = addr >> 16 & 0xFFL;
        this.voice_SPI_Send(address);
        address = addr >> 8 & 0xFFL;
        this.voice_SPI_Send(address);
        address = addr & 0xFFL;
        this.voice_SPI_Send(address);
        this.voice_SPI_CS(1);
    }

    void PageProgram(long addr, byte[] data) {
        long address = 0L;
        this.Write_Enable();
        this.voice_SPI_CS(0);
        this.voice_SPI_Send(2L);
        address = addr >> 16 & 0xFFL;
        this.voice_SPI_Send(address);
        address = addr >> 8 & 0xFFL;
        this.voice_SPI_Send(address);
        address = addr & 0xFFL;
        this.voice_SPI_Send(address);
        for (int i = 0; i < 256; ++i) {
            this.voice_SPI_Send(data[i]);
        }
        this.voice_SPI_CS(1);
    }

    void Chip_Erase() {
        this.Write_Enable();
        this.voice_SPI_CS(0);
        this.voice_SPI_Send(96L);
        this.voice_SPI_CS(1);
    }

    void ADPCMVoiceStop() {
        this.voice_SPI_CS(0);
        this.voiceDelay();
        this.voice_SPI_Send(83L);
        this.voiceDelay500();
        this.voice_SPI_Send(2L);
        this.voiceDelay500();
        this.voice_SPI_Send(0L);
        this.voiceDelay500();
        this.voice_SPI_CS(1);
    }

    public void waitNano(long usec) {
        long nowTime;
        long firstTime = System.nanoTime();
        while ((nowTime = System.nanoTime()) < firstTime + usec) {
        }
    }

    void VoiceFlashWrite(byte[] data, long filesize) throws InterruptedException {
        int j;
        int address = 32768;
        System.out.println("Voice Write Start...");
        this.SPI_Flash_BypassInMode();
        System.out.println("Voice Chip Erase Start...");
        this.Chip_Erase();
        Thread.sleep(12000L);
        System.out.println("Voice Chip Erase End...");
        System.out.println("Flash Writing Start");
        boolean lineNo = false;
        byte[] diskBuf = new byte[512];
        int addr = 32768;
        while ((long)addr < filesize) {
            int raddr = addr;
            for (j = 0; j < 256; ++j) {
                diskBuf[j] = data[raddr++];
            }
            this.PageProgram(addr, diskBuf);
            Thread.sleep(10L);
            addr += 256;
        }
        for (j = 0; j < 256; ++j) {
            diskBuf[j] = data[addr++];
        }
        this.PageProgram(addr, diskBuf);
        Thread.sleep(5L);
        System.out.println("End voice Write");
        this.SPI_Flash_BypassExitMode();
    }

    public void play(int no) {
        this.voicePlay(no);
    }

    public void writeRom() throws FileNotFoundException, IOException, InterruptedException {
        String fileName = "./wav.rom";
        File file = new File(fileName);
        boolean isExists = file.exists();
        if (isExists) {
            long size = file.length();
            System.out.println("File found Len = " + size);
            FileInputStream input = null;
            byte[] data = new byte[1000000];
            input = new FileInputStream(fileName);
            input.read(data);
            this.VoiceFlashWrite(data, size);
            input.close();
        } else {
            System.out.println("File not found");
        }
    }
}

