/*
 * Decompiled with CFR 0.152.
 */
package main;

import ControlSerial.CommFormat;
import Data.SystemData;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import main.CO2CalFXMLController;
import main.CoCalFXMLController;
import main.DustCalFXMLController;
import main.HchoCalFXMLController;
import main.InfoSFXMLController;
import main.LightCalFXMLController;
import main.MotionCalFXMLController;
import main.NH3CalFXMLController;
import main.NO2CalFXMLController;
import main.NoiseCalFXMLController;
import main.O3CalFXMLController;
import main.TVOCCalFXMLController;
import main.TempCalFXMLController;

public class CalFXMLController
implements EventBusListener,
Initializable {
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    CalFXMLController me;
    @FXML
    private Button noiseCal;
    @FXML
    private Button no2Cal;
    @FXML
    private Button coCal;
    @FXML
    private Button o3Cal;
    @FXML
    private Button hchoCal;
    @FXML
    private Button motionCal;
    @FXML
    private Button tempCal;
    @FXML
    private Button co2Cal;
    @FXML
    private Button tvocCal;
    @FXML
    private Button nh3Cal;
    @FXML
    private Button dustCal;
    @FXML
    private Button lightCal;
    @FXML
    private Button eraseBtn;
    @FXML
    private ProgressBar progress;
    double pro = 0.0;

    public CalFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("CalFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == CalFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("Sensor Calibration");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/adjust32_orange.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("CalFXML Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                CalFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(CalFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    @FXML
    void coCalOnAction(ActionEvent event) {
        CoCalFXMLController open = new CoCalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    void hchoCalOnAction(ActionEvent event) {
        HchoCalFXMLController open = new HchoCalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    void motionCalOnAction(ActionEvent event) {
        MotionCalFXMLController open = new MotionCalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    void no2CalOnAction(ActionEvent event) {
        NO2CalFXMLController open = new NO2CalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    void noiseCalOnAction(ActionEvent event) {
        NoiseCalFXMLController open = new NoiseCalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    void o3CalOnAction(ActionEvent event) {
        O3CalFXMLController open = new O3CalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    void tempCalOnAction(ActionEvent event) {
        TempCalFXMLController open = new TempCalFXMLController(this.myStage);
        open.show();
    }

    public void initialize(URL url, ResourceBundle rb) {
    }

    @Override
    public void onEvent(String id, String event) {
    }

    @FXML
    private void co2CalOnAction(ActionEvent event) {
        CO2CalFXMLController open = new CO2CalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    private void tvocCalOnAction(ActionEvent event) {
        TVOCCalFXMLController open = new TVOCCalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    private void nh3CalOnAction(ActionEvent event) {
        NH3CalFXMLController open = new NH3CalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    private void dustCalOnAction(ActionEvent event) {
        DustCalFXMLController open = new DustCalFXMLController(this.myStage);
        open.show();
    }

    @FXML
    private void lightCalOnAction(ActionEvent event) {
        LightCalFXMLController open = new LightCalFXMLController(this.myStage);
        open.show();
    }

    private void popupScreen() {
        InfoSFXMLController open = new InfoSFXMLController(this.sysData.primaryStage);
        open.show();
    }

    @FXML
    private void eraseOnAction(ActionEvent event) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Confirmation Dialog");
        alert.setHeaderText("Look, a Confirmation Dialog");
        alert.setContentText("LEO internal memory format??");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            if (this.sysData.comm.comPort) {
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(54);
                txFormat.setLength(1);
                txFormat.setTxData("REQ,");
                this.sysData.comm.setTxArray(txFormat);
                InfoSFXMLController open = new InfoSFXMLController(this.myStage);
                open.btnDisable();
                open.show();
                this.progress.setProgress(0.0);
                new Thread(() -> {
                    while (this.threadStatus) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        Platform.runLater(() -> this.progress.setProgress(this.pro += 0.1));
                        if (!(this.pro >= 1.0)) continue;
                        break;
                    }
                }).start();
            } else {
                System.out.println("Comport Open Error");
                SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
            }
        }
    }
}

