/*
 * Decompiled with CFR 0.152.
 */
package main;

import Control.MainCommThread;
import ControlSerial.BoardDataParsing;
import ControlSerial.CommFormat;
import ControlSerial.JSSCSerial;
import Data.SystemData;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import jssc.SerialPortList;

public class CommOpenFXMLController
implements EventBusListener,
Initializable {
    @FXML
    private ComboBox<String> portCombo;
    @FXML
    private Button openBtn;
    @FXML
    private Label infoLabel;
    @FXML
    private Button chkBtn;
    @FXML
    private Label infoLabel1;
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    CommOpenFXMLController me;
    boolean portSts = false;
    boolean commChk = false;
    boolean chkPress = false;

    public CommOpenFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("CommOpenFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == CommOpenFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("COM Port Setup");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/antena32_blue.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("CommOpenFXMLController Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                CommOpenFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(CommOpenFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    @FXML
    void openBtnOnAction(ActionEvent event) {
        if (!this.sysData.comm.comPort) {
            String portName = (String)this.portCombo.getSelectionModel().getSelectedItem();
            this.sysData.comportIndex = this.portCombo.getSelectionModel().getSelectedIndex();
            System.out.println(portName);
            BoardDataParsing chParsing = new BoardDataParsing();
            JSSCSerial chSerial = new JSSCSerial(portName, chParsing);
            if (!chSerial.getStatus()) {
                chSerial = null;
                this.infoLabel.setText("COM Port can't open");
                this.chkBtn.setVisible(false);
                this.sysData.connect = false;
                this.infoLabel1.setText("Board Not Found");
                this.sysData.mainScreen.offLabel();
            } else {
                this.sysData.comm.SerialClass = chSerial;
                MainCommThread mainCommThread = new MainCommThread();
                mainCommThread.start();
                this.sysData.mainCommThread = mainCommThread;
                this.commChk = true;
                this.sysData.comm.comPort = true;
                this.portCombo.setDisable(true);
                this.openBtn.setText("Port Close");
                this.portSts = true;
                this.infoLabel.setText("COM Port open success");
                this.chkBtn.setVisible(true);
                this.sysData.connect = true;
                this.sysData.mainScreen.onLabel();
                String string = SongUtil.nowDateTimeToFormatString();
            }
        } else {
            this.sysData.comm.SerialClass.serialClose();
            this.sysData.comm.SerialClass = null;
            this.sysData.comm.comPort = false;
            this.portSts = false;
            this.commChk = false;
            this.portCombo.setDisable(false);
            this.openBtn.setText("Port Open");
            this.infoLabel.setText("Select COM Port and Open Btn Press...");
            this.chkBtn.setVisible(false);
            this.sysData.connect = false;
            this.sysData.mainCommThread.threadExit();
            this.sysData.mainCommThread = null;
            this.infoLabel1.setText("Board Not Found");
            this.sysData.mainScreen.offLabel();
        }
    }

    @FXML
    void chkBtnOnAction(ActionEvent event) {
        if (this.commChk) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(2);
            txFormat.setLength(1);
            txFormat.setTxData("WHO,");
            this.sysData.comm.setTxArray(txFormat);
            this.chkPress = true;
        }
    }

    @FXML
    void closeBtnOnAction(ActionEvent event) {
        this.threadStatus = false;
        System.out.println("user close");
        EventBusHandler.removeListener(this.me);
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        System.out.println("CommOpen Windows Init");
        Object[] portNames = SerialPortList.getPortNames();
        Arrays.sort(portNames, String.CASE_INSENSITIVE_ORDER);
        this.portCombo.getItems().addAll(portNames);
        this.portCombo.setVisibleRowCount(10);
        this.portCombo.getSelectionModel().select(this.sysData.comportIndex);
        if (this.sysData.comm.comPort) {
            this.portCombo.setDisable(true);
            this.openBtn.setText("Port Close");
            this.chkBtn.setVisible(true);
            this.infoLabel.setText("COM Port Open success");
            this.infoLabel1.setText("Board Connection OK");
        } else {
            this.chkBtn.setVisible(false);
        }
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(CommOpenFXMLController.class.getName()).log(Level.SEVERE, null, ex);
                }
                if (!this.sysData.connect || !this.chkPress) continue;
                this.chkPress = false;
                Platform.runLater(() -> this.infoLabel1.setText("Board Connection OK"));
                System.out.println("Board Connect OK");
            }
        }).start();
    }

    @Override
    public void onEvent(String id, String event) {
    }
}

