/*
 * Decompiled with CFR 0.152.
 */
package main;

import Data.SystemData;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.commons.lang3.math.NumberUtils;

public class DataSaveFXMLController
implements Initializable {
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    @FXML
    private TextField fileTextBox;
    @FXML
    private TextField timeTextBox;
    @FXML
    private CheckBox autoCheck;

    public DataSaveFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DataSaveFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == DataSaveFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("Data Save");
            this.myStage.setResizable(false);
        }
        catch (IOException ex) {
            System.out.println("DataSaveFXML Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                DataSaveFXMLController.this.threadStatus = false;
                System.out.println("user close");
            }
        });
        this.myStage.showAndWait();
    }

    public void initialize(URL url, ResourceBundle rb) {
        this.fileTextBox.setText(this.sysData.fileName.toString());
        this.timeTextBox.setText(Integer.toString(this.sysData.intervalTime));
        if (this.sysData.autoStart == 1) {
            this.autoCheck.setSelected(true);
        } else {
            this.autoCheck.setSelected(false);
        }
    }

    @FXML
    private void saveOnAction(ActionEvent event) {
        boolean sts = true;
        this.sysData.fileName.setLength(0);
        this.sysData.fileName.append(this.fileTextBox.getText());
        if (NumberUtils.isParsable((String)this.timeTextBox.getText())) {
            this.sysData.intervalTime = Integer.parseInt(this.timeTextBox.getText());
        } else {
            SongUtil.messageBox("Information", "\uc798\ubabb\ub41c\uc785\ub825", "\ubb38\uc790\uc5f4\uc5d0 \uc22b\uc790\ub9cc \uc788\uc5b4\uc57c \ud569\ub2c8\ub2e4.");
            sts = false;
        }
        this.sysData.autoStart = this.autoCheck.isSelected() ? 1 : 0;
        if (sts) {
            this.sysData.dataSave();
            this.threadStatus = false;
            System.out.println("user close");
            Window window = this.myScene.getWindow();
            if (window instanceof Stage) {
                ((Stage)window).close();
            }
        }
    }

    @FXML
    private void escOnAction(ActionEvent event) {
        this.threadStatus = false;
        System.out.println("user close");
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }
}

