/*
 * Decompiled with CFR 0.152.
 */
package main;

import ControlSerial.CommFormat;
import Data.SystemData;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import main.InfoSFXMLController;
import org.apache.commons.lang3.math.NumberUtils;

public class DustCalFXMLController
implements EventBusListener,
Initializable {
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    DustCalFXMLController me;
    @FXML
    private TextField beforeDust01Text;
    @FXML
    private TextField afterDust01Text;
    @FXML
    private TextField beforeDust25Text;
    @FXML
    private TextField afterDust25Text;
    @FXML
    private TextField beforeDust10Text;
    @FXML
    private TextField afterDust10Text;
    @FXML
    private TextField calDust25BText;
    @FXML
    private TextField calDust01BText;
    @FXML
    private TextField calDust10BText;
    @FXML
    private TextField calDust01AText;
    @FXML
    private TextField calDust25AText;
    @FXML
    private TextField calDust10AText;
    @FXML
    private TextField calDust10A1Text;
    @FXML
    private TextField calDust25A1Text;
    @FXML
    private TextField calDust01A1Text;
    @FXML
    private TextField calDust25B1Text;
    @FXML
    private TextField calDust01B1Text;
    @FXML
    private TextField calDust10B1Text;
    @FXML
    private TextField calDust10A2Text;
    @FXML
    private TextField calDust25A2Text;
    @FXML
    private TextField calDust01A2Text;
    @FXML
    private TextField calDust10B2Text;
    @FXML
    private TextField calDust25B2Text;
    @FXML
    private TextField calDust01B2Text;
    @FXML
    private TextField Dust10Range1;
    @FXML
    private TextField Dust10Range2;
    @FXML
    private TextField Dust10Range3;
    @FXML
    private TextField Dust25Range1;
    @FXML
    private TextField Dust25Range2;
    @FXML
    private TextField Dust25Range3;
    @FXML
    private TextField Dust01Range1;
    @FXML
    private TextField Dust01Range2;
    @FXML
    private TextField Dust01Range3;

    public DustCalFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("DustCalFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == DustCalFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("PM Calibration");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/adjust32_orange.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("DustCalFXMLController Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                DustCalFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(DustCalFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    @FXML
    void closeBtnOnAction(ActionEvent event) {
        this.threadStatus = false;
        System.out.println("user close");
        EventBusHandler.removeListener(this.me);
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }

    private void popupScreen() {
        InfoSFXMLController open = new InfoSFXMLController(this.sysData.primaryStage);
        open.show();
    }

    @FXML
    void readBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(50);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            this.popupScreen();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void writeBtnOnAction(ActionEvent event) {
        String dust01A = this.calDust01AText.getText();
        String dust01B = this.calDust01BText.getText();
        String dust25A = this.calDust25AText.getText();
        String dust25B = this.calDust25BText.getText();
        String dust10A = this.calDust10AText.getText();
        String dust10B = this.calDust10BText.getText();
        String dust01A1 = this.calDust01A1Text.getText();
        String dust01B1 = this.calDust01B1Text.getText();
        String dust25A1 = this.calDust25A1Text.getText();
        String dust25B1 = this.calDust25B1Text.getText();
        String dust10A1 = this.calDust10A1Text.getText();
        String dust10B1 = this.calDust10B1Text.getText();
        String dust01A2 = this.calDust01A2Text.getText();
        String dust01B2 = this.calDust01B2Text.getText();
        String dust25A2 = this.calDust25A2Text.getText();
        String dust25B2 = this.calDust25B2Text.getText();
        String dust10A2 = this.calDust10A2Text.getText();
        String dust10B2 = this.calDust10B2Text.getText();
        String d10Range1 = this.Dust10Range1.getText();
        String d10Range2 = this.Dust10Range2.getText();
        String d10Range3 = this.Dust10Range3.getText();
        String d25Range1 = this.Dust25Range1.getText();
        String d25Range2 = this.Dust25Range2.getText();
        String d25Range3 = this.Dust25Range3.getText();
        String d01Range1 = this.Dust01Range1.getText();
        String d01Range2 = this.Dust01Range2.getText();
        String d01Range3 = this.Dust01Range3.getText();
        if (NumberUtils.isParsable((String)dust01A) && NumberUtils.isParsable((String)dust25A) && NumberUtils.isParsable((String)dust10A) && NumberUtils.isParsable((String)dust01B) && NumberUtils.isParsable((String)dust25B) && NumberUtils.isParsable((String)dust10B) && NumberUtils.isParsable((String)dust01A1) && NumberUtils.isParsable((String)dust01B1) && NumberUtils.isParsable((String)dust25A1) && NumberUtils.isParsable((String)dust25B1) && NumberUtils.isParsable((String)dust10A1) && NumberUtils.isParsable((String)dust10B1) && NumberUtils.isParsable((String)dust01A2) && NumberUtils.isParsable((String)dust01B2) && NumberUtils.isParsable((String)dust25A2) && NumberUtils.isParsable((String)dust25B2) && NumberUtils.isParsable((String)dust10A2) && NumberUtils.isParsable((String)dust10B2) && NumberUtils.isParsable((String)d10Range1) && NumberUtils.isParsable((String)d10Range2) && NumberUtils.isParsable((String)d10Range3) && NumberUtils.isParsable((String)d25Range1) && NumberUtils.isParsable((String)d25Range2) && NumberUtils.isParsable((String)d25Range3) && NumberUtils.isParsable((String)d01Range1) && NumberUtils.isParsable((String)d01Range2) && NumberUtils.isParsable((String)d01Range3)) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(51);
            txFormat.setLength(27);
            txFormat.setTxData(dust01A + "," + dust01B + "," + dust25A + "," + dust25B + "," + dust10A + "," + dust10B + "," + dust01A1 + "," + dust01B1 + "," + dust25A1 + "," + dust25B1 + "," + dust10A1 + "," + dust10B1 + "," + dust01A2 + "," + dust01B2 + "," + dust25A2 + "," + dust25B2 + "," + dust10A2 + "," + dust10B2 + "," + d10Range1 + "," + d10Range2 + "," + d10Range3 + "," + d25Range1 + "," + d25Range2 + "," + d25Range3 + "," + d01Range1 + "," + d01Range2 + "," + d01Range3 + ",");
            this.sysData.comm.setTxArray(txFormat);
            this.sysData.sensor.tempCalFlag = true;
            System.out.println("Dust10CalData1 = " + dust10A + "," + dust10B + "," + d10Range1);
            System.out.println("Dust10CalData2 = " + dust10A1 + "," + dust10B1 + "," + d10Range2);
            System.out.println("Dust10CalData3 = " + dust10A2 + "," + dust10B2 + "," + d10Range3);
            System.out.println("Dust25CalData1 = " + dust25A + "," + dust25B + "," + d25Range1);
            System.out.println("Dust25CalData2 = " + dust25A1 + "," + dust25B1 + "," + d25Range2);
            System.out.println("Dust25CalData3 = " + dust25A2 + "," + dust25B2 + "," + d25Range3);
            System.out.println("Dust01CalData1 = " + dust01A + "," + dust01B + "," + d01Range1);
            System.out.println("Dust01CalData2 = " + dust01A1 + "," + dust01B1 + "," + d01Range2);
            System.out.println("Dust01CalData3 = " + dust01A2 + "," + dust01B2 + "," + d01Range3);
            this.popupScreen();
        } else {
            SongUtil.messageBox("Information", "Numeric invalid Alert", "Only numbers are allowed.");
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    this.beforeDust01Text.setText(String.format("%3.1f", this.sysData.sensor.Dust01Src));
                    this.beforeDust25Text.setText(String.format("%3.1f", this.sysData.sensor.Dust25Src));
                    this.beforeDust10Text.setText(String.format("%3.1f", this.sysData.sensor.Dust10Src));
                    if (this.sysData.sensor.dustReadFlag) {
                        this.calDust01AText.setText(String.format("%3.3f", this.sysData.sensor.calDust01A));
                        this.calDust01BText.setText(String.format("%3.3f", this.sysData.sensor.calDust01B));
                        this.calDust25AText.setText(String.format("%3.3f", this.sysData.sensor.calDust25A));
                        this.calDust25BText.setText(String.format("%3.3f", this.sysData.sensor.calDust25B));
                        this.calDust10AText.setText(String.format("%3.3f", this.sysData.sensor.calDust10A));
                        this.calDust10BText.setText(String.format("%3.3f", this.sysData.sensor.calDust10B));
                        this.calDust01A1Text.setText(String.format("%3.3f", this.sysData.sensor.calDust01A1));
                        this.calDust01B1Text.setText(String.format("%3.3f", this.sysData.sensor.calDust01B1));
                        this.calDust25A1Text.setText(String.format("%3.3f", this.sysData.sensor.calDust25A1));
                        this.calDust25B1Text.setText(String.format("%3.3f", this.sysData.sensor.calDust25B1));
                        this.calDust10A1Text.setText(String.format("%3.3f", this.sysData.sensor.calDust10A1));
                        this.calDust10B1Text.setText(String.format("%3.3f", this.sysData.sensor.calDust10B1));
                        this.calDust01A2Text.setText(String.format("%3.3f", this.sysData.sensor.calDust01A2));
                        this.calDust01B2Text.setText(String.format("%3.3f", this.sysData.sensor.calDust01B2));
                        this.calDust25A2Text.setText(String.format("%3.3f", this.sysData.sensor.calDust25A2));
                        this.calDust25B2Text.setText(String.format("%3.3f", this.sysData.sensor.calDust25B2));
                        this.calDust10A2Text.setText(String.format("%3.3f", this.sysData.sensor.calDust10A2));
                        this.calDust10B2Text.setText(String.format("%3.3f", this.sysData.sensor.calDust10B2));
                        this.Dust10Range1.setText(String.format("%3.1f", this.sysData.sensor.calDust10Range1));
                        this.Dust10Range2.setText(String.format("%3.1f", this.sysData.sensor.calDust10Range2));
                        this.Dust10Range3.setText(String.format("%3.1f", this.sysData.sensor.calDust10Range3));
                        this.Dust25Range1.setText(String.format("%3.1f", this.sysData.sensor.calDust25Range1));
                        this.Dust25Range2.setText(String.format("%3.1f", this.sysData.sensor.calDust25Range2));
                        this.Dust25Range3.setText(String.format("%3.1f", this.sysData.sensor.calDust25Range3));
                        this.Dust01Range1.setText(String.format("%3.1f", this.sysData.sensor.calDust01Range1));
                        this.Dust01Range2.setText(String.format("%3.1f", this.sysData.sensor.calDust01Range2));
                        this.Dust01Range3.setText(String.format("%3.1f", this.sysData.sensor.calDust01Range3));
                        this.sysData.sensor.dustReadFlag = false;
                    }
                    this.afterDust01Text.setText(String.format("%3.1f", this.sysData.sensor.Dust01));
                    this.afterDust25Text.setText(String.format("%3.1f", this.sysData.sensor.Dust25));
                    this.afterDust10Text.setText(String.format("%3.1f", this.sysData.sensor.Dust10));
                });
            }
        }).start();
    }

    @Override
    public void onEvent(String id, String event) {
    }
}

