/*
 * Decompiled with CFR 0.152.
 */
package main;

import ControlSerial.CommFormat;
import Data.SystemData;
import DialogBox.WaitBoxFXMLController;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import Utility.SongUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.apache.commons.lang3.math.NumberUtils;

public class HchoCalFXMLController
implements EventBusListener,
Initializable {
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    HchoCalFXMLController me;
    @FXML
    private TextField beforeText;
    @FXML
    private TextField afterText;
    @FXML
    private TextField zeromvText;
    @FXML
    private TextField spanmvText;
    @FXML
    private TextField zeroCalText;
    @FXML
    private TextField spanCalText;
    @FXML
    private Button readBtn;
    @FXML
    private Button zeroCalBtn;
    @FXML
    private Button spanCalBtn;
    @FXML
    private CheckBox zeroUserCheck;
    @FXML
    private CheckBox spanUserCheck;
    @FXML
    private Button writeBtn;
    @FXML
    private Button defaultBtn;

    public HchoCalFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("HchoCalFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == HchoCalFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("HCHO Calibration");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/adjust32_orange.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("HchoCalFXML Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                HchoCalFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(HchoCalFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    @FXML
    void readBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(21);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            WaitBoxFXMLController wait = new WaitBoxFXMLController(this.myStage);
            wait.show();
        } else {
            System.out.println("Comport Open Error");
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void spanCalBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            String span = this.spanCalText.getText();
            String spanmV = null;
            if (this.spanUserCheck.isSelected()) {
                spanmV = this.spanmvText.getText();
            } else {
                this.spanmvText.setText(Double.toString(this.sysData.sensor.HCHOmV));
                spanmV = this.zeromvText.getText();
            }
            if (NumberUtils.isParsable((String)span) && NumberUtils.isParsable((String)spanmV)) {
                if (this.spanUserCheck.isSelected()) {
                    this.sysData.sensor.spanHCHOmV = Double.parseDouble(this.spanmvText.getText());
                } else {
                    this.sysData.sensor.spanHCHOmV = this.sysData.sensor.HCHOmV;
                    this.spanmvText.setText(String.format("%3.1f", this.sysData.sensor.spanHCHOmV));
                }
                String mv0 = Double.toString(this.sysData.sensor.spanHCHOmV);
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(23);
                txFormat.setLength(2);
                txFormat.setTxData(span + "," + mv0 + ",");
                this.sysData.comm.setTxArray(txFormat);
                this.sysData.sensor.hchoSpanCalFlag = true;
            } else {
                SongUtil.messageBox("Information", "Numeric invalid Alert", "Only numbers are allowed.");
            }
        } else {
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void zeroCalBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            String zero = this.zeroCalText.getText();
            String zeromV = null;
            if (this.zeroUserCheck.isSelected()) {
                zeromV = this.zeromvText.getText();
            } else {
                this.zeromvText.setText(Double.toString(this.sysData.sensor.HCHOmV));
                zeromV = this.zeromvText.getText();
            }
            if (NumberUtils.isParsable((String)zero) && NumberUtils.isParsable((String)zeromV)) {
                if (this.zeroUserCheck.isSelected()) {
                    this.sysData.sensor.zeroHCHOmV = Double.parseDouble(this.zeromvText.getText());
                } else {
                    this.sysData.sensor.zeroHCHOmV = this.sysData.sensor.HCHOmV;
                    this.zeromvText.setText(String.format("%3.1f", this.sysData.sensor.zeroHCHOmV));
                }
                String mv0 = Double.toString(this.sysData.sensor.zeroHCHOmV);
                CommFormat txFormat = new CommFormat();
                txFormat.setAddr(1);
                txFormat.setFuncCode(22);
                txFormat.setLength(2);
                txFormat.setTxData(zero + "," + mv0 + ",");
                this.sysData.comm.setTxArray(txFormat);
                this.sysData.sensor.hchoZeroCalFlag = true;
            } else {
                SongUtil.messageBox("Information", "Numeric invalid Alert", "Only numbers are allowed.");
            }
        } else {
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    @FXML
    void writeBtnOnAction(ActionEvent event) {
        if (this.sysData.comm.comPort) {
            CommFormat txFormat = new CommFormat();
            txFormat.setAddr(1);
            txFormat.setFuncCode(24);
            txFormat.setLength(1);
            txFormat.setTxData("REQ,");
            this.sysData.comm.setTxArray(txFormat);
            WaitBoxFXMLController wait = new WaitBoxFXMLController(this.myStage);
            wait.show();
        } else {
            SongUtil.messageBox("Information", "Comport Open Alert", "Open the communication port and use it.");
        }
    }

    public void initialize(URL url, ResourceBundle rb) {
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    this.beforeText.setText(String.format("%3.1f", this.sysData.sensor.HCHOmV));
                    this.afterText.setText(String.format("%3.2f", this.sysData.sensor.HCHO));
                    if (this.sysData.sensor.hchoReadFlag) {
                        this.zeromvText.setText(String.format("%3.1f", this.sysData.sensor.zeroHCHOmV));
                        this.spanmvText.setText(String.format("%3.1f", this.sysData.sensor.spanHCHOmV));
                        this.zeroCalText.setText(String.format("%3.1f", this.sysData.sensor.zeroHCHO));
                        this.spanCalText.setText(String.format("%3.1f", this.sysData.sensor.spanHCHO));
                        this.sysData.sensor.hchoReadFlag = false;
                    }
                });
            }
        }).start();
    }

    @Override
    public void onEvent(String id, String event) {
    }

    @FXML
    private void defaultBtnOnAction(ActionEvent event) {
        this.zeroUserCheck.setSelected(true);
        this.spanUserCheck.setSelected(true);
        this.zeromvText.setText("1.0");
        this.zeroCalText.setText("1.0");
        this.spanmvText.setText("1000.0");
        this.spanCalText.setText("98.0");
    }
}

