/*
 * Decompiled with CFR 0.152.
 */
package main;

import Data.SystemData;
import Utility.EventBus.EventBusHandler;
import Utility.EventBus.EventBusListener;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class InfoFXMLController
implements Initializable,
EventBusListener {
    private boolean popup = false;
    SystemData sysData = SystemData.getInstance();
    private Stage myStage;
    private Scene myScene;
    private boolean threadStatus = true;
    private boolean eventBusSts = false;
    InfoFXMLController me;
    @FXML
    private Label infoLabel;

    public InfoFXMLController(Stage parent) {
        try {
            FXMLLoader loader = new FXMLLoader(this.getClass().getResource("InfoFXML.fxml"));
            loader.setControllerFactory(type -> {
                if (type == InfoFXMLController.class) {
                    return this;
                }
                try {
                    return type.newInstance();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            Parent root = (Parent)loader.load();
            this.myScene = new Scene(root);
            this.myStage = new Stage();
            this.myStage.initOwner((Window)parent);
            this.myStage.initModality(Modality.WINDOW_MODAL);
            this.myStage.setScene(this.myScene);
            this.myStage.setTitle("Sensor Calibration");
            this.myStage.setResizable(false);
            this.myStage.getIcons().add((Object)new Image("/res32/adjust32_orange.png"));
            this.me = this;
            EventBusHandler.addListener(this);
        }
        catch (IOException ex) {
            System.out.println("CalFXML Windows Load Error");
        }
    }

    public void show() {
        this.myStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                InfoFXMLController.this.threadStatus = false;
                System.out.println("user close");
                EventBusHandler.removeListener(InfoFXMLController.this.me);
            }
        });
        this.myStage.showAndWait();
    }

    public void initialize(URL url, ResourceBundle rb) {
        new Thread(() -> {
            while (this.threadStatus) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Platform.runLater(() -> {
                    if (this.popup) {
                        this.threadStatus = false;
                        EventBusHandler.removeListener(this.me);
                        Window window = this.myScene.getWindow();
                        if (window instanceof Stage) {
                            ((Stage)window).close();
                        }
                    }
                });
            }
        }).start();
    }

    @FXML
    private void okBtnOnAction(ActionEvent event) {
        this.threadStatus = false;
        EventBusHandler.removeListener(this.me);
        Window window = this.myScene.getWindow();
        if (window instanceof Stage) {
            ((Stage)window).close();
        }
    }

    @Override
    public void onEvent(String id, String event) {
        if (id.equals("receive")) {
            this.popup = true;
            Platform.runLater(() -> this.infoLabel.setText("Data Communication OK"));
        }
    }
}

