/*
 * Decompiled with CFR 0.152.
 */
package main;

import Data.SystemData;
import java.net.URL;
import javafx.application.Application;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class Main
extends Application {
    public void init() throws Exception {
        super.init();
    }

    public void reverseArrayString(String[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            String temp = array[i];
            array[i] = array[array.length - 1 - i];
            array[array.length - 1 - i] = temp;
        }
    }

    public void start(Stage stage) throws Exception {
        SystemData sysData = SystemData.getInstance();
        if (sysData.osName.equals("Linux")) {
            sysData.sound.voiceVolume(125);
            sysData.sound.play(1);
            sysData.fanControl.setPwm(0);
            sysData.lcdControl.on();
        }
        sysData.primaryStage = stage;
        Parent root = (Parent)FXMLLoader.load((URL)((Object)((Object)this)).getClass().getResource("MainScreen.fxml"));
        Scene scene = new Scene(root);
        stage.setScene(scene);
        stage.getIcons().add((Object)new Image("/resources/atlasenlogo1.png"));
        stage.centerOnScreen();
        stage.setResizable(false);
        stage.setTitle("Atlasen LEO sensorMonitor");
        stage.requestFocus();
        stage.show();
    }

    public void stop() throws Exception {
        super.stop();
        SystemData sysData = SystemData.getInstance();
        if (sysData.osName.equals("Linux")) {
            sysData.sound.gpioShutDown();
            sysData.fanControl.threadExit();
            sysData.lcdControl.threadExit();
            sysData.lcdControl.on();
        }
        if (sysData.mainCommThread != null) {
            sysData.mainCommThread.threadExit();
        }
        if (sysData.mainScreen != null) {
            sysData.mainScreen.threadExit();
        }
        if (sysData.comm.SerialClass != null) {
            sysData.comm.SerialClass.serialClose();
            sysData.comm.SerialClass = null;
        }
        System.out.println("System Exit");
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    static {
        SystemData systemData = SystemData.getInstance();
    }
}

